/*
 * Decompiled with CFR 0.152.
 */
package me.danjono.inventoryrollback.reflections;

import com.nuclyon.technicallycoded.inventoryrollback.InventoryRollbackPlus;
import com.nuclyon.technicallycoded.inventoryrollback.bukkitversion.BukkitVersion;
import com.nuclyon.technicallycoded.inventoryrollback.customdata.CustomDataItemEditor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.function.Consumer;
import me.danjono.inventoryrollback.config.ConfigData;
import me.danjono.inventoryrollback.reflections.NMSHandler;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class LegacyNBTWrapper
implements CustomDataItemEditor {
    private ItemStack item;
    private final NMSHandler nmsHandler = new NMSHandler();
    private static HashMap<Class<?>, String> getTagElementMethodNames;
    private static HashMap<Class<?>, String> setTagElementMethodNames;
    private static String getTagMethodName;
    private static String setTagMethodName;
    private static Method getDataComponentMapMethod;
    private static Object customDataComponentMapKey;
    private static Method getDataComponentValueMethod;
    private static Method getCustomDataNBTCopyMethod;
    private static Method updateCustomDataNBTStaticMethod;

    public LegacyNBTWrapper(ItemStack item) {
        this.item = item;
        if (getTagElementMethodNames == null) {
            InventoryRollbackPlus irp = InventoryRollbackPlus.getInstance();
            if (ConfigData.isDebugEnabled()) {
                irp.getLogger().info("NBTWrapper created for the first time since startup!");
            }
            BukkitVersion nmsVersion = irp.getVersion();
            if (ConfigData.isDebugEnabled()) {
                irp.getLogger().info("Using NMS Version: " + nmsVersion.toString());
            }
            if (nmsVersion.greaterOrEqThan(BukkitVersion.v1_20_R4)) {
                LegacyNBTWrapper.resolve1_20_5OrHigherReflectionNames(nmsVersion);
            } else {
                LegacyNBTWrapper.resolvePre1_20_5ReflectionNames(nmsVersion);
            }
            this.resolveNbtTagCompoundReflectionNames(nmsVersion);
        }
    }

    private static void resolve1_20_5OrHigherReflectionNames(BukkitVersion nmsVersion) {
        try {
            String getDataComponentMapMethodName = "a";
            Class<?> dataComponentsClass = Class.forName("net.minecraft.core.component.DataComponents");
            customDataComponentMapKey = dataComponentsClass.getField("b").get(null);
            Class<?> nmsItemStackClass = Class.forName("net.minecraft.world.item.ItemStack");
            getDataComponentMapMethod = nmsItemStackClass.getMethod(getDataComponentMapMethodName, new Class[0]);
            Class<?> dataComponentMapClass = Class.forName("net.minecraft.core.component.DataComponentMap");
            Class<?> dataComponentTypeClass = Class.forName("net.minecraft.core.component.DataComponentType");
            getDataComponentValueMethod = dataComponentMapClass.getMethod("a", dataComponentTypeClass);
            Class<?> customDataClass = Class.forName("net.minecraft.world.item.component.CustomData");
            Class<?> itemStackClass = Class.forName("net.minecraft.world.item.ItemStack");
            getCustomDataNBTCopyMethod = nmsVersion.greaterOrEqThan(BukkitVersion.v1_21_R3) ? customDataClass.getMethod("d", new Class[0]) : customDataClass.getMethod("c", new Class[0]);
            updateCustomDataNBTStaticMethod = customDataClass.getMethod("a", dataComponentTypeClass, itemStackClass, Consumer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void resolvePre1_20_5ReflectionNames(BukkitVersion nmsVersion) {
        if (nmsVersion.greaterOrEqThan(BukkitVersion.v1_18_R1)) {
            getTagMethodName = nmsVersion.greaterOrEqThan(BukkitVersion.v1_20_R1) ? "v" : (nmsVersion.greaterOrEqThan(BukkitVersion.v1_19_R1) ? "u" : (nmsVersion.greaterOrEqThan(BukkitVersion.v1_18_R2) ? "t" : "s"));
            setTagMethodName = "c";
        } else {
            getTagMethodName = "getTag";
            setTagMethodName = "setTag";
        }
    }

    private void resolveNbtTagCompoundReflectionNames(BukkitVersion nmsVersion) {
        getTagElementMethodNames = new HashMap();
        setTagElementMethodNames = new HashMap();
        if (nmsVersion.greaterOrEqThan(BukkitVersion.v1_18_R1)) {
            getTagElementMethodNames.put(Integer.class, "h");
            getTagElementMethodNames.put(Long.class, "i");
            getTagElementMethodNames.put(Float.class, "j");
            getTagElementMethodNames.put(Double.class, "k");
            getTagElementMethodNames.put(String.class, "l");
            setTagElementMethodNames.put(Integer.class, "a");
            setTagElementMethodNames.put(Long.class, "a");
            setTagElementMethodNames.put(Float.class, "a");
            setTagElementMethodNames.put(Double.class, "a");
            setTagElementMethodNames.put(String.class, "a");
        } else {
            getTagElementMethodNames.put(Integer.class, "getInt");
            getTagElementMethodNames.put(Long.class, "getLong");
            getTagElementMethodNames.put(Float.class, "getFloat");
            getTagElementMethodNames.put(Double.class, "getDouble");
            getTagElementMethodNames.put(String.class, "getString");
            setTagElementMethodNames.put(Integer.class, "setInt");
            setTagElementMethodNames.put(Long.class, "setLong");
            setTagElementMethodNames.put(Float.class, "setFloat");
            setTagElementMethodNames.put(Double.class, "setDouble");
            setTagElementMethodNames.put(String.class, "setString");
        }
    }

    @Override
    public ItemStack setItemData() {
        return this.item;
    }

    @Override
    public boolean hasUUID() {
        String uuid = this.getString("uuid");
        return uuid != null && !uuid.isEmpty();
    }

    @Override
    public ItemStack setString(String key, String data) {
        return this.writeDataToBukkitItem(key, String.class, data);
    }

    @Override
    public ItemStack setInt(String key, Integer data) {
        return this.writeDataToBukkitItem(key, Integer.TYPE, data);
    }

    @Override
    public ItemStack setLong(String key, Long data) {
        return this.writeDataToBukkitItem(key, Long.TYPE, data);
    }

    @Override
    public ItemStack setDouble(String key, Double data) {
        return this.writeDataToBukkitItem(key, Double.TYPE, data);
    }

    @Override
    public ItemStack setFloat(String key, Float data) {
        return this.writeDataToBukkitItem(key, Float.TYPE, data);
    }

    @Override
    public String getString(String key) {
        return this.readDataFromBukkitItem(key, String.class, String.class);
    }

    @Override
    public int getInt(String key) {
        return this.readDataFromBukkitItem(key, Integer.TYPE, Integer.class);
    }

    @Override
    public Long getLong(String key) {
        return this.readDataFromBukkitItem(key, Long.TYPE, Long.class);
    }

    @Override
    public double getDouble(String key) {
        return this.readDataFromBukkitItem(key, Double.TYPE, Double.class);
    }

    @Override
    public Float getFloat(String key) {
        return this.readDataFromBukkitItem(key, Float.TYPE, Float.class);
    }

    @Nullable
    private <T> T readDataFromBukkitItem(String key, Class<T> dataType, Class<?> mapType) {
        T result = null;
        try {
            Object itemstack = this.nmsHandler.getCraftBukkitClass("inventory.CraftItemStack").getMethod("asNMSCopy", ItemStack.class).invoke(null, this.item);
            result = InventoryRollbackPlus.getInstance().getVersion().greaterOrEqThan(BukkitVersion.v1_20_R4) ? (T)this.readCustomDataFromNmsItem(itemstack, key, dataType, mapType) : (T)this.readNbtFromNmsItem(itemstack, key, dataType, mapType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private <T> T readCustomDataFromNmsItem(Object nmsItem, String key, Class<T> dataType, Class<?> mapType) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object compMap = getDataComponentMapMethod.invoke(nmsItem, new Object[0]);
        Object customData = getDataComponentValueMethod.invoke(compMap, customDataComponentMapKey);
        if (customData == null) {
            return null;
        }
        Object nbtComp = getCustomDataNBTCopyMethod.invoke(customData, new Object[0]);
        return this.readNbtValue(key, mapType, nbtComp);
    }

    private <T> T readNbtFromNmsItem(Object nmsItem, String key, Class<T> dataType, Class<?> mapType) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object comp = null;
        try {
            comp = nmsItem.getClass().getMethod(getTagMethodName, new Class[0]).invoke(nmsItem, new Object[0]);
        }
        catch (NullPointerException e) {
            return null;
        }
        return this.readNbtValue(key, mapType, comp);
    }

    @Nullable
    private <T> T readNbtValue(String key, Class<?> mapType, Object nbtComponent) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            return (T)nbtComponent.getClass().getMethod(getTagElementMethodNames.get(mapType), String.class).invoke(nbtComponent, key);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    private ItemStack writeDataToBukkitItem(String key, Class<?> dataType, Object data) {
        try {
            Object nmsItem = this.nmsHandler.getCraftBukkitClass("inventory.CraftItemStack").getMethod("asNMSCopy", ItemStack.class).invoke(null, this.item);
            if (InventoryRollbackPlus.getInstance().getVersion().greaterOrEqThan(BukkitVersion.v1_20_R4)) {
                this.writeCustomDataToNmsItem(nmsItem, key, dataType, data);
            } else {
                this.writeNbtToNmsItem(nmsItem, key, dataType, data);
            }
            this.item = (ItemStack)this.nmsHandler.getCraftBukkitClass("inventory.CraftItemStack").getMethod("asBukkitCopy", nmsItem.getClass()).invoke(null, nmsItem);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.item;
    }

    private void writeCustomDataToNmsItem(Object nmsItem, String key, Class<?> dataType, Object data) throws InvocationTargetException, IllegalAccessException {
        updateCustomDataNBTStaticMethod.invoke(null, customDataComponentMapKey, nmsItem, comp -> {
            try {
                LegacyNBTWrapper.writeNbtValue(comp, key, dataType, data);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                ex.printStackTrace();
            }
        });
    }

    private void writeNbtToNmsItem(Object nmsItem, String key, Class<?> dataType, Object data) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
        Object comp = nmsItem.getClass().getMethod(getTagMethodName, new Class[0]).invoke(nmsItem, new Object[0]);
        if (comp == null) {
            comp = InventoryRollbackPlus.getInstance().getVersion().greaterOrEqThan(BukkitVersion.v1_17_R1) ? this.nmsHandler.getNMSClass("nbt.NBTTagCompound").newInstance() : this.nmsHandler.getNMSClass("NBTTagCompound").newInstance();
        }
        LegacyNBTWrapper.writeNbtValue(comp, key, dataType, data);
        nmsItem.getClass().getMethod(setTagMethodName, comp.getClass()).invoke(nmsItem, comp);
    }

    private static void writeNbtValue(Object nbtComponent, String key, Class<?> dataType, Object data) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        nbtComponent.getClass().getMethod(setTagElementMethodNames.get(data.getClass()), String.class, dataType).invoke(nbtComponent, key, data);
    }
}

