/*
 * Decompiled with CFR 0.152.
 */
package com.nuclyon.technicallycoded.inventoryrollback;

import com.nuclyon.technicallycoded.inventoryrollback.UpdateChecker;
import com.nuclyon.technicallycoded.inventoryrollback.bstats.bukkit.Metrics;
import com.nuclyon.technicallycoded.inventoryrollback.bstats.charts.SimplePie;
import com.nuclyon.technicallycoded.inventoryrollback.bukkitversion.BukkitVersion;
import com.nuclyon.technicallycoded.inventoryrollback.bukkitversion.MCVersion;
import com.nuclyon.technicallycoded.inventoryrollback.commands.Commands;
import com.nuclyon.technicallycoded.inventoryrollback.paperlib.PaperLib;
import com.nuclyon.technicallycoded.inventoryrollback.util.TimeZoneUtil;
import com.nuclyon.technicallycoded.inventoryrollback.util.test.SelfTestSerialization;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import me.danjono.inventoryrollback.InventoryRollback;
import me.danjono.inventoryrollback.config.ConfigData;
import me.danjono.inventoryrollback.config.MessageData;
import me.danjono.inventoryrollback.data.LogType;
import me.danjono.inventoryrollback.inventory.SaveInventory;
import me.danjono.inventoryrollback.listeners.ClickGUI;
import me.danjono.inventoryrollback.listeners.EventLogs;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class InventoryRollbackPlus
extends InventoryRollback {
    private static InventoryRollbackPlus instancePlus;
    private TimeZoneUtil timeZoneUtil = null;
    private ConfigData configData;
    private BukkitVersion version = BukkitVersion.v1_13_R1;
    private AtomicBoolean shuttingDown = new AtomicBoolean(false);

    public static InventoryRollbackPlus getInstance() {
        return instancePlus;
    }

    @Override
    public void onEnable() {
        instancePlus = this;
        InventoryRollback.setInstance(instancePlus);
        this.timeZoneUtil = new TimeZoneUtil();
        this.configData = new ConfigData();
        this.configData.setVariables();
        String serverVersion = this.getServer().getVersion();
        this.getLogger().info("Attempting support for version: " + serverVersion);
        MCVersion mcVersion = MCVersion.fromServerVersion(serverVersion);
        BukkitVersion nmsVersion = mcVersion.toBukkitVersion();
        if (nmsVersion == null) {
            this.getLogger().severe(MessageData.getPluginPrefix() + "\n ** WARNING! IRP may not be compatible with this version of Minecraft. **\n ** Please fully test the plugin before using on your server as features may be broken. **\n" + MessageData.getPluginPrefix());
            InventoryRollbackPlus.setPackageVersion(BukkitVersion.getLatest().name());
        } else {
            this.setVersion(nmsVersion);
            InventoryRollback.setPackageVersion(nmsVersion.name());
        }
        this.getLogger().info("Using CraftBukkit version: " + InventoryRollbackPlus.getPackageVersion());
        super.startupTasks();
        if (ConfigData.isbStatsEnabled()) {
            this.initBStats();
        }
        PluginCommand plCmd = this.getCommand("inventoryrollbackplus");
        Commands cmds = new Commands(this);
        if (plCmd == null) {
            return;
        }
        plCmd.setExecutor((CommandExecutor)cmds);
        plCmd.setTabCompleter((TabCompleter)cmds);
        this.getServer().getPluginManager().registerEvents((Listener)new ClickGUI(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EventLogs(), (Plugin)this);
        this.getServer().getScheduler().runTask((Plugin)this, EventLogs::patchLowestHandlers);
        if (!PaperLib.isPaper()) {
            this.getLogger().info("----------------------------------------");
            this.getLogger().info("We recommend updating your server to use Paper :)");
            this.getLogger().info("Paper significantly reduces lag spikes among other benefits.");
            this.getLogger().info("Learn more at: https://papermc.io/");
            this.getLogger().info("----------------------------------------");
        }
        SelfTestSerialization.runTests();
    }

    @Override
    public void onDisable() {
        this.getLogger().info("Setting shutdown state");
        this.shuttingDown.set(true);
        this.getLogger().info("Saving player inventories...");
        for (Player player : this.getServer().getOnlinePlayers()) {
            if (!player.hasPermission("inventoryrollbackplus.leavesave")) continue;
            new SaveInventory(player, LogType.QUIT, null, null).snapshotAndSave(player.getInventory(), player.getEnderChest(), false);
        }
        this.getLogger().info("Done saving player inventories!");
        HandlerList.unregisterAll((Plugin)this);
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        instancePlus = null;
        super.onDisable();
        this.getLogger().info("Plugin is disabled!");
    }

    public void setVersion(BukkitVersion versionName) {
        this.version = versionName;
    }

    @Override
    public boolean isCompatibleCb(String cbVersion) {
        for (BukkitVersion v : BukkitVersion.values()) {
            if (!v.name().equalsIgnoreCase(cbVersion)) continue;
            this.setVersion(v);
            return true;
        }
        return false;
    }

    @Override
    public void checkUpdate() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)InventoryRollback.getInstance(), () -> {
            InventoryRollbackPlus.getInstance().getConsoleSender().sendMessage(MessageData.getPluginPrefix() + "Checking for updates...");
            UpdateChecker.UpdateResult result = new UpdateChecker(InventoryRollbackPlus.getInstance(), 85811).getResult();
            int prioLevel = 0;
            String prioColor = ChatColor.AQUA.toString();
            String prioLevelName = "null";
            switch (result.getType()) {
                case FAIL_SPIGOT: {
                    this.getConsoleSender().sendMessage(MessageData.getPluginPrefix() + ChatColor.GOLD + "Warning: Could not contact Spigot to check if an update is available.");
                    break;
                }
                case UPDATE_LOW: {
                    prioLevel = 1;
                    prioLevelName = "minor";
                    break;
                }
                case UPDATE_MEDIUM: {
                    prioLevel = 2;
                    prioLevelName = "feature";
                    prioColor = ChatColor.GOLD.toString();
                    break;
                }
                case UPDATE_HIGH: {
                    prioLevel = 3;
                    prioLevelName = "MAJOR";
                    prioColor = ChatColor.RED.toString();
                    break;
                }
                case DEV_BUILD: {
                    this.getConsoleSender().sendMessage(MessageData.getPluginPrefix() + ChatColor.GOLD + "Warning: You are running an experimental/development build! Proceed with caution.");
                    break;
                }
                case NO_UPDATE: {
                    this.getConsoleSender().sendMessage(MessageData.getPluginPrefix() + ChatColor.RESET + "You are running the latest version.");
                    break;
                }
            }
            if (prioLevel > 0) {
                this.getConsoleSender().sendMessage("\n" + prioColor + "===============================================================================\nA " + prioLevelName + " update to InventoryRollbackPlus is available!\nDownload at https://www.spigotmc.org/resources/inventoryrollbackplus-1-8-1-16-x.85811/\n(current: " + result.getCurrentVer() + ", latest: " + result.getLatestVer() + ")\n===============================================================================\n");
            }
        });
    }

    public void initBStats() {
        this.bStats();
    }

    @Override
    public void bStats() {
        Metrics metrics = new Metrics(this, 9437);
        if (ConfigData.isbStatsEnabled()) {
            InventoryRollbackPlus.getInstance().getConsoleSender().sendMessage(MessageData.getPluginPrefix() + "bStats are enabled");
        }
        metrics.addCustomChart(new SimplePie("database_type", () -> ConfigData.getSaveType().getName()));
        metrics.addCustomChart(new SimplePie("restore_to_player_enabled", () -> {
            if (ConfigData.isRestoreToPlayerButton()) {
                return "Enabled";
            }
            return "Disabled";
        }));
        metrics.addCustomChart(new SimplePie("save_location", () -> {
            if (ConfigData.getFolderLocation() == InventoryRollback.getInstance().getDataFolder()) {
                return "Default";
            }
            return "Not Default";
        }));
        metrics.addCustomChart(new SimplePie("storage_type", () -> {
            if (ConfigData.isMySQLEnabled()) {
                return "MySQL";
            }
            return "YAML";
        }));
        metrics.addCustomChart(new SimplePie("time_zone", () -> ConfigData.getTimeZone().getID()));
        metrics.addCustomChart(new SimplePie("allow_other_plugins_edit_death_inventory", () -> String.valueOf(ConfigData.isAllowOtherPluginEditDeathInventory())));
        metrics.addCustomChart(new SimplePie("custom_online_mode", () -> {
            File modernPaperConfig;
            File legacyPaperConfig;
            boolean vanillaOnline = this.getServer().getOnlineMode();
            boolean spigotProxyMode = false;
            boolean legacyPaperProxyEnabled = false;
            boolean legacyPaperProxyMode = false;
            boolean modernPaperProxyEnabled = false;
            boolean modernPaperProxyMode = false;
            File mainFolder = new File(System.getProperty("user.dir"));
            File spigotConfig = new File(mainFolder, "spigot.yml");
            if (spigotConfig.exists()) {
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)spigotConfig);
                spigotProxyMode = config.getBoolean("settings.bungeecord", false);
            }
            if ((legacyPaperConfig = new File(mainFolder, "paper.yml")).exists()) {
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)legacyPaperConfig);
                legacyPaperProxyEnabled = config.getBoolean("settings.velocity-support.enabled", false);
                legacyPaperProxyMode = config.getBoolean("settings.velocity-support.online-mode", false);
            }
            if ((modernPaperConfig = new File(mainFolder, "config/paper-global.yml")).exists()) {
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)modernPaperConfig);
                modernPaperProxyEnabled = config.getBoolean("proxies.velocity.enabled", false);
                modernPaperProxyMode = config.getBoolean("proxies.velocity.online-mode", false);
            }
            if (modernPaperProxyEnabled) {
                if (modernPaperProxyMode) {
                    return "Modern Paper Proxy - Online";
                }
                return "Modern Paper Proxy - Offline";
            }
            if (legacyPaperProxyEnabled) {
                if (legacyPaperProxyMode) {
                    return "Legacy Paper Proxy - Online";
                }
                return "Legacy Paper Proxy - Offline";
            }
            if (spigotProxyMode) {
                if (vanillaOnline) {
                    return "Bungeecord - Online";
                }
                return "Bungeecord - Offline";
            }
            if (vanillaOnline) {
                return "Vanilla - Online";
            }
            return "Vanilla - Offline";
        }));
    }

    public boolean isShuttingDown() {
        return this.shuttingDown.get();
    }

    public BukkitVersion getVersion() {
        return this.version;
    }

    public ConsoleCommandSender getConsoleSender() {
        return this.getServer().getConsoleSender();
    }

    public TimeZoneUtil getTimeZoneUtil() {
        return this.timeZoneUtil;
    }

    public ConfigData getConfigData() {
        return this.configData;
    }
}

