/*
 * Decompiled with CFR 0.152.
 */
package com.nuclyon.technicallycoded.inventoryrollback.commands.inventoryrollback;

import com.nuclyon.technicallycoded.inventoryrollback.InventoryRollbackPlus;
import com.nuclyon.technicallycoded.inventoryrollback.commands.IRPCommand;
import java.util.UUID;
import me.danjono.inventoryrollback.InventoryRollback;
import me.danjono.inventoryrollback.config.ConfigData;
import me.danjono.inventoryrollback.config.MessageData;
import me.danjono.inventoryrollback.gui.menu.MainMenu;
import me.danjono.inventoryrollback.gui.menu.PlayerMenu;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class RestoreSubCmd
extends IRPCommand {
    public RestoreSubCmd(InventoryRollbackPlus mainIn) {
        super(mainIn);
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (sender instanceof Player) {
            if (sender.hasPermission("inventoryrollbackplus.viewbackups")) {
                if (!ConfigData.isEnabled()) {
                    sender.sendMessage(MessageData.getPluginPrefix() + MessageData.getPluginDisabled());
                    return;
                }
                Player staff = (Player)sender;
                this.openBackupMenu(sender, staff, args);
            } else {
                sender.sendMessage(MessageData.getPluginPrefix() + MessageData.getNoPermission());
            }
        } else {
            sender.sendMessage(MessageData.getPluginPrefix() + MessageData.getPlayerOnlyError());
        }
    }

    private void openBackupMenu(CommandSender sender, Player staff, String[] args) {
        if (args.length <= 0 || args.length == 1) {
            try {
                this.openMainMenu(staff);
            }
            catch (NullPointerException nullPointerException) {}
        } else if (args.length == 2) {
            OfflinePlayer rollbackPlayer;
            String uuidStr = args[1];
            if (uuidStr.length() == 36 || args[1].length() == 32) {
                if (args[1].length() == 32) {
                    String oldUuidStr = uuidStr;
                    uuidStr = oldUuidStr.substring(0, 8);
                    uuidStr = uuidStr + "-";
                    uuidStr = uuidStr + oldUuidStr.substring(8, 12);
                    uuidStr = uuidStr + "-";
                    uuidStr = uuidStr + oldUuidStr.substring(12, 16);
                    uuidStr = uuidStr + "-";
                    uuidStr = uuidStr + oldUuidStr.substring(16, 20);
                    uuidStr = uuidStr + "-";
                    uuidStr = uuidStr + oldUuidStr.substring(20);
                }
                try {
                    rollbackPlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(uuidStr));
                }
                catch (IllegalArgumentException e) {
                    sender.sendMessage(MessageData.getPluginPrefix() + MessageData.getError());
                    return;
                }
            } else {
                rollbackPlayer = Bukkit.getOfflinePlayer((String)args[1]);
            }
            try {
                this.openPlayerMenu(staff, rollbackPlayer);
            }
            catch (NullPointerException nullPointerException) {}
        } else {
            sender.sendMessage(MessageData.getPluginPrefix() + MessageData.getError());
        }
    }

    private void openMainMenu(Player staff) {
        MainMenu menu = new MainMenu(staff, 1);
        staff.openInventory(menu.getInventory());
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)InventoryRollback.getInstance(), menu::getMainMenu);
    }

    private void openPlayerMenu(Player staff, OfflinePlayer offlinePlayer) {
        PlayerMenu menu = new PlayerMenu(staff, offlinePlayer);
        staff.openInventory(menu.getInventory());
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)InventoryRollback.getInstance(), menu::getPlayerMenu);
    }
}

