/*
 * Decompiled with CFR 0.152.
 */
package com.nuclyon.technicallycoded.inventoryrollback.util.serialization;

import com.nuclyon.technicallycoded.inventoryrollback.util.serialization.DeserializationResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public class Version2Serialization {
    public static final int ID = 2;

    public static DeserializationResult deserialize(String data) {
        try {
            byte[] b64decoded = Base64.getDecoder().decode(data);
            ByteArrayInputStream bais = new ByteArrayInputStream(b64decoded);
            return Version2Serialization.deserialize(bais);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DeserializationResult(null, "Failed to deserialize item stack: " + e.getMessage());
        }
    }

    public static DeserializationResult deserialize(InputStream bais) throws IOException {
        ItemStack[] items = new ItemStack[Version2Serialization.readInt(bais)];
        for (int i = 0; i < items.length; ++i) {
            int length = Version2Serialization.readInt(bais);
            if (length == 0) {
                items[i] = null;
                continue;
            }
            byte[] serializedItem = new byte[length];
            for (int j = 0; j < length; ++j) {
                serializedItem[j] = (byte)bais.read();
            }
            try {
                items[i] = Version2Serialization.deserializeItem(serializedItem);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return new DeserializationResult(null, "Failed to deserialize item stack: " + ex.getMessage());
            }
        }
        return new DeserializationResult(items, null);
    }

    public static String serialize(ItemStack[] items) {
        try {
            byte[] serializedBytes = Version2Serialization.serializeBytes(items);
            return Base64.getEncoder().encodeToString(serializedBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] serializeBytes(ItemStack[] items) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Version2Serialization.writeInt(baos, items.length);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        for (ItemStack item : items) {
            if (item == null) {
                Version2Serialization.writeInt(baos, 0);
                continue;
            }
            try {
                byte[] serializedItem = Version2Serialization.serializeItem(item);
                Version2Serialization.writeInt(baos, serializedItem.length);
                baos.write(serializedItem);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        try {
            baos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return baos.toByteArray();
    }

    private static byte[] serializeItem(ItemStack item) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BukkitObjectOutputStream boos = new BukkitObjectOutputStream((OutputStream)baos);
        boos.writeObject((Object)item);
        boos.close();
        return baos.toByteArray();
    }

    private static ItemStack deserializeItem(byte[] serialized) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(serialized);
        BukkitObjectInputStream bois = new BukkitObjectInputStream((InputStream)bais);
        return (ItemStack)bois.readObject();
    }

    private static int readInt(InputStream is) throws IOException {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result |= (is.read() & 0xFF) << i * 8;
        }
        return result;
    }

    private static void writeInt(OutputStream os, int value) throws IOException {
        for (int i = 0; i < 4; ++i) {
            os.write(value >> i * 8 & 0xFF);
        }
    }
}

