/*
 * Decompiled with CFR 0.152.
 */
package me.danjono.inventoryrollback;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.bukkit.plugin.java.JavaPlugin;

public class UpdateChecker {
    private JavaPlugin plugin;
    private URL checkURL;
    private String currentVersion;
    private String availableVersion;
    private UpdateResult result = UpdateResult.FAIL_SPIGOT;

    public UpdateChecker(JavaPlugin plugin, Integer resourceId) {
        this.plugin = plugin;
        this.currentVersion = this.regex(this.plugin.getDescription().getVersion());
        try {
            this.checkURL = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + resourceId);
        }
        catch (MalformedURLException e) {
            this.result = UpdateResult.FAIL_SPIGOT;
            return;
        }
        this.run();
    }

    private void run() {
        URLConnection con = null;
        try {
            con = this.checkURL.openConnection();
        }
        catch (IOException e1) {
            this.result = UpdateResult.FAIL_SPIGOT;
            return;
        }
        try {
            this.availableVersion = this.regex(new BufferedReader(new InputStreamReader(con.getInputStream())).readLine());
        }
        catch (IOException e) {
            this.result = UpdateResult.FAIL_SPIGOT;
            return;
        }
        if (this.availableVersion.isEmpty()) {
            this.result = UpdateResult.FAIL_SPIGOT;
            return;
        }
        if (this.availableVersion.equalsIgnoreCase(this.currentVersion)) {
            this.result = UpdateResult.NO_UPDATE;
            return;
        }
        if (!this.availableVersion.equalsIgnoreCase(this.currentVersion)) {
            this.result = UpdateResult.UPDATE_AVAILABLE;
            return;
        }
        this.result = UpdateResult.FAIL_SPIGOT;
    }

    public UpdateResult getResult() {
        return this.result;
    }

    public String getVersion() {
        return this.regex(this.availableVersion);
    }

    private String regex(String version) {
        return version.replaceAll("[^0-9.]", "");
    }

    public static enum UpdateResult {
        NO_UPDATE,
        FAIL_SPIGOT,
        UPDATE_AVAILABLE;

    }
}

