/*
 * Decompiled with CFR 0.152.
 */
package me.danjono.inventoryrollback.config;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import me.danjono.inventoryrollback.InventoryRollback;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessageData {
    private File messagesFile;
    private FileConfiguration messages;
    private static final String configurationFileName = "messages.yml";
    private boolean saveChanges = false;
    private static String pluginPrefix;
    private static String adminAlerts;
    private static String noPermission;
    private static String error;
    private static String errorInventory;
    private static String enabledMessage;
    private static String disabledMessage;
    private static String reloadMessage;
    private static String playerOnly;
    private static String importSuccess;
    private static String noBackup;
    private static String notOnline;
    private static String forceSavedPlayer;
    private static String forceSavedAll;
    private static String notForcedSaved;
    private static String mainInventoryRestored;
    private static String mainInventoryRestoredPlayer;
    private static String mainInventoryNotOnline;
    private static String mainInventoryButton;
    private static String mainInventoryDisabledButton;
    private static String enderChestRestored;
    private static String enderChestRestoredPlayer;
    private static String enderChestNotOnline;
    private static String enderChestButton;
    private static String healthRestored;
    private static String healthRestoredPlayer;
    private static String healthNotOnline;
    private static String healthButton;
    private static String hungerRestored;
    private static String hungerRestoredPlayer;
    private static String hungerNotOnline;
    private static String hungerButton;
    private static String experienceRestored;
    private static String experienceRestoredPlayer;
    private static String experienceNotOnline;
    private static String experienceButton;
    private static String experienceButtonLore;
    private static String deathLocationWorld;
    private static String deathLocationX;
    private static String deathLocationY;
    private static String deathLocationZ;
    private static String deathReason;
    private static String deathTime;
    private static String deathLocationTeleportTo;
    private static String deathLocationTeleport;
    private static String deathLocationInvalidWorld;
    private static String mainMenuButton;
    private static String nextPageButton;
    private static String previousPageButton;
    private static String backButton;
    private static String nameVariable;
    private static String xpVariable;

    public MessageData() {
        this.generateMessagesFile();
    }

    private void generateMessagesFile() {
        this.getMessagesFile();
        if (!this.messagesFile.exists()) {
            InventoryRollback.getInstance().saveResource(configurationFileName, false);
            this.getMessagesFile();
        }
        this.getMessagesData();
    }

    private void getMessagesFile() {
        this.messagesFile = new File(InventoryRollback.getInstance().getDataFolder(), configurationFileName);
    }

    private void getMessagesData() {
        this.messages = YamlConfiguration.loadConfiguration((File)this.messagesFile);
    }

    public boolean saveConfig() {
        try {
            this.messages.save(this.messagesFile);
        }
        catch (IOException e) {
            InventoryRollback.getInstance().getLogger().log(Level.SEVERE, "Could not save data to messages file", e);
            return false;
        }
        this.saveChanges = false;
        return true;
    }

    public void setMessages() {
        MessageData.setPluginPrefix(MessageData.convertColorCodes((String)this.getDefaultValue("general.prefix", "&f[&bInventoryRollbackPlus&f]&r ")));
        MessageData.setNoPermission(MessageData.convertColorCodes((String)this.getDefaultValue("commands.no-permission", "&cYou do not have permission!")));
        MessageData.setError(MessageData.convertColorCodes((String)this.getDefaultValue("commands.error", "&cInvalid command.")));
        MessageData.setPluginEnabled(MessageData.convertColorCodes((String)this.getDefaultValue("commands.enable", "&2The plugin has been enabled.")));
        MessageData.setPluginDisabled(MessageData.convertColorCodes((String)this.getDefaultValue("commands.disable", "&2The plugin has been disabled.")));
        MessageData.setPluginReload(MessageData.convertColorCodes((String)this.getDefaultValue("commands.reload", "&2The plugin has been reloaded successfully.")));
        MessageData.setPlayerOnlyError(MessageData.convertColorCodes((String)this.getDefaultValue("commands.player-only", "&cCommand can only be run by a player.")));
        MessageData.setImportSuccess(MessageData.convertColorCodes((String)this.getDefaultValue("commands.import", "&aSuccessfully imported all backup data from the old plugin.")));
        MessageData.setNoBackupError(MessageData.convertColorCodes((String)this.getDefaultValue("backup.no-backup", "There is currently no backups for %NAME%.")));
        MessageData.setNotOnlineError(MessageData.convertColorCodes((String)this.getDefaultValue("backup.not-online", "%NAME% is not currently online.")));
        MessageData.setForceBackupPlayer(MessageData.convertColorCodes((String)this.getDefaultValue("backup.force-saved-player", "%NAME%'s inventory has been force saved.")));
        MessageData.setForceBackupAll(MessageData.convertColorCodes((String)this.getDefaultValue("backup.force-saved-all", "All online player inventories have been force saved.")));
        MessageData.setForceBackupError(MessageData.convertColorCodes((String)this.getDefaultValue("backup.not-forced-saved", "There was an issue with saving %NAME%'s inventory.")));
        MessageData.setMainInventoryRestored(MessageData.convertColorCodes((String)this.getDefaultValue("attribute-restore.main-inventory.restored", "%NAME%''s main inventory has been restored.")));
        MessageData.setMainInventoryRestoredPlayer(MessageData.convertColorCodes((String)this.getDefaultValue("attribute-restore.main-inventory.restored-player", "Your inventory has been restored by %NAME%.")));
        MessageData.setMainInventoryNotOnline(MessageData.convertColorCodes((String)this.getDefaultValue("attribute-restore.main-inventory.not-online", "You can't restore %NAME%'s inventory while they are offline.")));
        MessageData.setMainInventoryButton(MessageData.convertColorCodes((String)this.getDefaultValue("attribute-restore.main-inventory.button-name", "&cOverwrite Main Inventory from Backup")));
        MessageData.setMainInventoryDisabledButton(MessageData.convertColorCodes((String)this.getDefaultValue("attribute-restore.main-inventory.button-disabled", "&cYou must enable this option in the configuration")));
        MessageData.setEnderChestRestored(MessageData.convertColorCodes((String)this.getDefaultValue("attribute-restore.ender-chest.restored", "%NAME%'s ender chest has been restored.")));
        MessageData.setEnderChestRestoredPlayer(MessageData.convertColorCodes((String)this.getDefaultValue("attribute-restore.ender-chest.restored-player", "Your ender chest has been restored by %NAME%.")));
        MessageData.setEnderChestNotOnline(MessageData.convertColorCodes((String)this.getDefaultValue("attribute-restore.ender-chest.not-online", "You can't restore %NAME%'s ender chest while they are offline.")));
        MessageData.setEnderChestButton(MessageData.convertColorCodes((String)this.getDefaultValue("attribute-restore.ender-chest.button-name", "&dRestore Ender Chest")));
        MessageData.setHealthRestored(MessageData.convertColorCodes((String)this.getDefaultValue("attribute-restore.health.restored", "%NAME%'s health has been restored.")));
        MessageData.setHealthRestoredPlayer(MessageData.convertColorCodes((String)this.getDefaultValue("attribute-restore.health.restored-player", "Your health has been restored by %NAME%.")));
        MessageData.setHealthNotOnline(MessageData.convertColorCodes((String)this.getDefaultValue("attribute-restore.health.not-online", "You can't restore %NAME%'s health while they are offline.")));
        MessageData.setHealthButton(MessageData.convertColorCodes((String)this.getDefaultValue("attribute-restore.health.button-name", "&aRestore Health")));
        MessageData.setHungerRestored(MessageData.convertColorCodes((String)this.getDefaultValue("attribute-restore.hunger.restored", "%NAME%'s hunger has been restored.")));
        MessageData.setHungerRestoredPlayer(MessageData.convertColorCodes((String)this.getDefaultValue("attribute-restore.hunger.restored-player", "Your hunger has been restored by %NAME%.")));
        MessageData.setHungerNotOnline(MessageData.convertColorCodes((String)this.getDefaultValue("attribute-restore.hunger.not-online", "You can't restore %NAME%'s hunger while they are offline.")));
        MessageData.setHungerButton(MessageData.convertColorCodes((String)this.getDefaultValue("attribute-restore.hunger.button-name", "&cRestore Food")));
        MessageData.setExperienceRestored(MessageData.convertColorCodes((String)this.getDefaultValue("attribute-restore.experience.restored", "%NAME%'s XP has been set to level %XP%.")));
        MessageData.setExperienceRestoredPlayer(MessageData.convertColorCodes((String)this.getDefaultValue("attribute-restore.experience.restored-player", "Your XP has been restored to level %XP% by %NAME%.")));
        MessageData.setExperienceNotOnlinePlayer(MessageData.convertColorCodes((String)this.getDefaultValue("attribute-restore.experience.not-online", "You can't restore %NAME%'s experience while they are offline.")));
        MessageData.setExperienceButton(MessageData.convertColorCodes((String)this.getDefaultValue("attribute-restore.experience.button-name", "&2Restore Player XP")));
        MessageData.setExperienceButtonLore(MessageData.convertColorCodes((String)this.getDefaultValue("attribute-restore.experience.button-lore", "&rLevel %XP%")));
        MessageData.setDeathLocationWorld(MessageData.convertColorCodes((String)this.getDefaultValue("death-location.world", "&6World: &f%WORLD%")));
        MessageData.setDeathLocationX(MessageData.convertColorCodes((String)this.getDefaultValue("death-location.x", "&6X: &f%X%")));
        MessageData.setDeathLocationY(MessageData.convertColorCodes((String)this.getDefaultValue("death-location.y", "&6Y: &f%Y%")));
        MessageData.setDeathLocationZ(MessageData.convertColorCodes((String)this.getDefaultValue("death-location.z", "&6Z: &f%Z%")));
        MessageData.setDeathReason(MessageData.convertColorCodes((String)this.getDefaultValue("death-location.reason", "&6Death reason: &f%REASON%")));
        MessageData.setDeathTime(MessageData.convertColorCodes((String)this.getDefaultValue("death-location.time", "&6Time: &f%TIME%")));
        MessageData.setDeathLocation(MessageData.convertColorCodes((String)this.getDefaultValue("death-location.teleport-to", "&3Teleport to where this entry was logged.")));
        MessageData.setDeathLocationTeleport(MessageData.convertColorCodes((String)this.getDefaultValue("death-location.teleport", "You have been teleported to %LOCATION%")));
        MessageData.setDeathLocationInvalidWorldError(MessageData.convertColorCodes((String)this.getDefaultValue("death-location.invalid-world", "The world %WORLD% is not currently loaded on the server.")));
        MessageData.setMainMenuButton(MessageData.convertColorCodes((String)this.getDefaultValue("menu-buttons.main-menu", "&fMain Menu")));
        MessageData.setNextPageButton(MessageData.convertColorCodes((String)this.getDefaultValue("menu-buttons.next-page", "&fNext Page")));
        MessageData.setPreviousPageButton(MessageData.convertColorCodes((String)this.getDefaultValue("menu-buttons.previous-page", "&fPrevious Page")));
        MessageData.setBackButton(MessageData.convertColorCodes((String)this.getDefaultValue("menu-buttons.back-page", "&fBack")));
        if (this.saveChanges()) {
            this.saveConfig();
        }
    }

    public static void setPluginPrefix(String message) {
        pluginPrefix = message;
    }

    public static void setNoPermission(String message) {
        noPermission = message;
    }

    public static void setError(String message) {
        error = message;
    }

    public static void setErrorInventory(String message) {
        errorInventory = message;
    }

    public static void setPluginEnabled(String message) {
        enabledMessage = message;
    }

    public static void setPluginDisabled(String message) {
        disabledMessage = message;
    }

    public static void setPluginReload(String message) {
        reloadMessage = message;
    }

    public static void setPlayerOnlyError(String message) {
        playerOnly = message;
    }

    public static void setImportSuccess(String message) {
        importSuccess = message;
    }

    public static void setNoBackupError(String message) {
        noBackup = message;
    }

    public static void setNotOnlineError(String message) {
        notOnline = message;
    }

    public static void setForceBackupPlayer(String message) {
        forceSavedPlayer = message;
    }

    public static void setForceBackupAll(String message) {
        forceSavedAll = message;
    }

    public static void setForceBackupError(String message) {
        notForcedSaved = message;
    }

    public static void setMainInventoryRestored(String message) {
        mainInventoryRestored = message;
    }

    public static void setMainInventoryRestoredPlayer(String message) {
        mainInventoryRestoredPlayer = message;
    }

    public static void setMainInventoryNotOnline(String message) {
        mainInventoryNotOnline = message;
    }

    public static void setMainInventoryButton(String message) {
        mainInventoryButton = message;
    }

    public static void setMainInventoryDisabledButton(String message) {
        mainInventoryDisabledButton = message;
    }

    public static void setEnderChestRestored(String message) {
        enderChestRestored = message;
    }

    public static void setEnderChestRestoredPlayer(String message) {
        enderChestRestoredPlayer = message;
    }

    public static void setEnderChestNotOnline(String message) {
        enderChestNotOnline = message;
    }

    public static void setEnderChestButton(String message) {
        enderChestButton = message;
    }

    public static void setHealthRestored(String message) {
        healthRestored = message;
    }

    public static void setHealthRestoredPlayer(String message) {
        healthRestoredPlayer = message;
    }

    public static void setHealthNotOnline(String message) {
        healthNotOnline = message;
    }

    public static void setHealthButton(String message) {
        healthButton = message;
    }

    public static void setHungerRestored(String message) {
        hungerRestored = message;
    }

    public static void setHungerRestoredPlayer(String message) {
        hungerRestoredPlayer = message;
    }

    public static void setHungerNotOnline(String message) {
        hungerNotOnline = message;
    }

    public static void setHungerButton(String message) {
        hungerButton = message;
    }

    public static void setExperienceRestored(String message) {
        experienceRestored = message;
    }

    public static void setExperienceRestoredPlayer(String message) {
        experienceRestoredPlayer = message;
    }

    public static void setExperienceNotOnlinePlayer(String message) {
        experienceNotOnline = message;
    }

    public static void setExperienceButton(String message) {
        experienceButton = message;
    }

    public static void setExperienceButtonLore(String message) {
        experienceButtonLore = message;
    }

    public static void setDeathLocationWorld(String message) {
        deathLocationWorld = message;
    }

    public static void setDeathLocationX(String message) {
        deathLocationX = message;
    }

    public static void setDeathLocationY(String message) {
        deathLocationY = message;
    }

    public static void setDeathLocationZ(String message) {
        deathLocationZ = message;
    }

    public static void setDeathReason(String message) {
        deathReason = message;
    }

    public static void setDeathTime(String message) {
        deathTime = message;
    }

    public static void setDeathLocation(String message) {
        deathLocationTeleportTo = message;
    }

    public static void setDeathLocationTeleport(String message) {
        deathLocationTeleport = message;
    }

    public static void setDeathLocationInvalidWorldError(String message) {
        deathLocationInvalidWorld = message;
    }

    public static void setMainMenuButton(String message) {
        mainMenuButton = message;
    }

    public static void setNextPageButton(String message) {
        nextPageButton = message;
    }

    public static void setPreviousPageButton(String message) {
        previousPageButton = message;
    }

    public static void setBackButton(String message) {
        backButton = message;
    }

    public static String getAdminAlerts() {
        return adminAlerts;
    }

    public static String getPluginPrefix() {
        return pluginPrefix;
    }

    public static String getNoPermission() {
        return noPermission;
    }

    public static String getError() {
        return error;
    }

    public static String getErrorInventory() {
        return errorInventory;
    }

    public static String getPluginEnabled() {
        return enabledMessage;
    }

    public static String getPluginDisabled() {
        return disabledMessage;
    }

    public static String getPluginReload() {
        return reloadMessage;
    }

    public static String getPlayerOnlyError() {
        return playerOnly;
    }

    public static String getImportSuccess() {
        return importSuccess;
    }

    public static String getNoBackupError(String name) {
        return noBackup.replaceAll(nameVariable, name);
    }

    public static String getNotOnlineError(String name) {
        return notOnline.replaceAll(nameVariable, name);
    }

    public static String getForceBackupPlayer(String name) {
        return forceSavedPlayer.replaceAll(nameVariable, name);
    }

    public static String getForceBackupAll() {
        return forceSavedAll;
    }

    public static String getForceBackupError(String name) {
        return notForcedSaved.replaceAll(nameVariable, name);
    }

    public static String getMainInventoryRestored(String name) {
        return mainInventoryRestored.replaceAll(nameVariable, name);
    }

    public static String getMainInventoryRestoredPlayer(String name) {
        return mainInventoryRestoredPlayer.replaceAll(nameVariable, name);
    }

    public static String getMainInventoryNotOnline(String name) {
        return mainInventoryNotOnline.replaceAll(nameVariable, name);
    }

    public static String getMainInventoryRestoreButton() {
        return mainInventoryButton;
    }

    public static String getMainInventoryDisabledButton() {
        return mainInventoryDisabledButton;
    }

    public static String getEnderChestRestored(String name) {
        return enderChestRestored.replaceAll(nameVariable, name);
    }

    public static String getEnderChestRestoredPlayer(String name) {
        return enderChestRestoredPlayer.replaceAll(nameVariable, name);
    }

    public static String getEnderChestNotOnline(String name) {
        return enderChestNotOnline.replaceAll(nameVariable, name);
    }

    public static String getEnderChestRestoreButton() {
        return enderChestButton;
    }

    public static String getHealthRestored(String name) {
        return healthRestored.replaceAll(nameVariable, name);
    }

    public static String getHealthRestoredPlayer(String name) {
        return healthRestoredPlayer.replaceAll(nameVariable, name);
    }

    public static String getHealthNotOnline(String name) {
        return healthNotOnline.replaceAll(nameVariable, name);
    }

    public static String getHealthRestoreButton() {
        return healthButton;
    }

    public static String getHungerRestored(String name) {
        return hungerRestored.replaceAll(nameVariable, name);
    }

    public static String getHungerRestoredPlayer(String name) {
        return hungerRestoredPlayer.replaceAll(nameVariable, name);
    }

    public static String getHungerNotOnline(String name) {
        return hungerNotOnline.replaceAll(nameVariable, name);
    }

    public static String getHungerRestoreButton() {
        return hungerButton;
    }

    public static String getExperienceRestored(String name, int xp) {
        return experienceRestored.replaceAll(nameVariable, name).replaceAll(xpVariable, xp + "");
    }

    public static String getExperienceRestoredPlayer(String name, int xp) {
        return experienceRestoredPlayer.replaceAll(nameVariable, name).replaceAll(xpVariable, xp + "");
    }

    public static String getExperienceNotOnlinePlayer(String name) {
        return experienceNotOnline.replaceAll(nameVariable, name);
    }

    public static String getExperienceRestoreButton() {
        return experienceButton;
    }

    public static String getExperienceRestoreLevel(int xp) {
        return experienceButtonLore.replaceAll(xpVariable, xp + "");
    }

    public static String getDeathLocationWorld(String world) {
        return deathLocationWorld.replace("%WORLD%", world);
    }

    public static String getDeathLocationX(Double x) {
        return deathLocationX.replace("%X%", Math.floor(x) + "");
    }

    public static String getDeathLocationY(Double y) {
        return deathLocationY.replace("%Y%", Math.floor(y) + "");
    }

    public static String getDeathLocationZ(Double z) {
        return deathLocationZ.replace("%Z%", Math.floor(z) + "");
    }

    public static String getDeathReason(String reason) {
        return deathReason.replace("%REASON%", reason);
    }

    public static String getDeathTime(String time) {
        return deathTime.replace("%TIME%", time);
    }

    public static String getDeathLocation() {
        return deathLocationTeleportTo;
    }

    public static String getDeathLocationTeleport(Location location) {
        return deathLocationTeleport.replace("%LOCATION%", "X:" + (int)location.getX() + " Y:" + (int)location.getY() + " Z:" + (int)location.getZ());
    }

    public static String getDeathLocationInvalidWorldError(String world) {
        return deathLocationInvalidWorld.replace("%WORLD%", world);
    }

    public static String getMainMenuButton() {
        return mainMenuButton;
    }

    public static String getNextPageButton() {
        return nextPageButton;
    }

    public static String getPreviousPageButton() {
        return previousPageButton;
    }

    public static String getBackButton() {
        return backButton;
    }

    private static String convertColorCodes(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    public Object getDefaultValue(String path, Object defaultValue) {
        Object obj = this.messages.get(path);
        if (obj == null) {
            obj = defaultValue;
            this.messages.set(path, defaultValue);
            this.saveChanges = true;
        }
        return obj;
    }

    private boolean saveChanges() {
        return this.saveChanges;
    }

    static {
        adminAlerts = ChatColor.RED + "Admin Only Alert: null";
        errorInventory = "You cannot access this backup due to an error. The backup was likely generated on another Minecraft server version and a Material ID has now changed.";
        nameVariable = "%NAME%";
        xpVariable = "%XP%";
    }
}

