/*
 * Decompiled with CFR 0.152.
 */
package me.danjono.inventoryrollback.data;

import com.nuclyon.technicallycoded.inventoryrollback.InventoryRollbackPlus;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.danjono.inventoryrollback.InventoryRollback;
import me.danjono.inventoryrollback.config.ConfigData;
import me.danjono.inventoryrollback.data.LogType;
import me.danjono.inventoryrollback.data.MySQL;
import me.danjono.inventoryrollback.data.YAML;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerData {
    private final OfflinePlayer offlinePlayer;
    private final LogType logType;
    private final Long timestamp;
    private YAML yaml;
    private MySQL mysql;

    public PlayerData(OfflinePlayer offlinePlayer, LogType logType, Long timestamp) {
        this.offlinePlayer = offlinePlayer;
        this.logType = logType;
        this.timestamp = timestamp;
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            this.yaml = new YAML(offlinePlayer.getUniqueId(), logType, timestamp);
        } else if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            this.mysql = new MySQL(offlinePlayer.getUniqueId(), logType, timestamp);
        }
    }

    public PlayerData(UUID uuid, LogType logType, Long timestamp) {
        this.offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
        this.logType = logType;
        this.timestamp = timestamp;
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            this.yaml = new YAML(uuid, logType, timestamp);
        } else if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            this.mysql = new MySQL(uuid, logType, timestamp);
        }
    }

    public OfflinePlayer getOfflinePlayer() {
        return this.offlinePlayer;
    }

    public LogType getLogType() {
        return this.logType;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public boolean doesBackupTypeExist() {
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            return this.yaml.doesBackupTypeExist();
        }
        if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            try {
                return this.mysql.doesBackupTypeExist();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public int getAmountOfBackups() {
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            return this.yaml.getAmountOfBackups();
        }
        if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            try {
                return this.mysql.getAmountOfBackups();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    public List<Long> getSelectedPageTimestamps(int pageNumber) {
        List<Long> timeStamps = new ArrayList<Long>();
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            timeStamps = this.yaml.getSelectedPageTimestamps(pageNumber);
        } else if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            try {
                timeStamps = this.mysql.getSelectedPageTimestamps(pageNumber);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return timeStamps;
    }

    public CompletableFuture<Void> purgeExcessSaves(boolean shouldSaveAsync) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        boolean saveAsync = !InventoryRollbackPlus.getInstance().isShuttingDown() && shouldSaveAsync;
        Runnable purgeTask = () -> {
            int maxSaves = this.getMaxSaves();
            int currentSaves = this.getAmountOfBackups();
            if (maxSaves > 0 && currentSaves >= maxSaves) {
                int deleteAmount = currentSaves - maxSaves + 1;
                if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
                    this.yaml.purgeExcessSaves(deleteAmount);
                } else if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
                    try {
                        this.mysql.purgeExcessSaves(deleteAmount);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
            future.complete(null);
        };
        InventoryRollbackPlus instance = InventoryRollbackPlus.getInstance();
        if (saveAsync) {
            instance.getServer().getScheduler().runTaskAsynchronously((Plugin)instance, purgeTask);
        } else {
            purgeTask.run();
        }
        return future;
    }

    public void setMainInventory(ItemStack[] items) {
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            this.yaml.setMainInventory(items);
        } else if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            this.mysql.setMainInventory(items);
        }
    }

    public void setArmour(ItemStack[] items) {
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            this.yaml.setArmour(items);
        } else if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            this.mysql.setArmour(items);
        }
    }

    public void setEnderChest(ItemStack[] items) {
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            this.yaml.setEnderChest(items);
        } else if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            this.mysql.setEnderChest(items);
        }
    }

    public void setXP(float xp) {
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            this.yaml.setXP(xp);
        } else if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            this.mysql.setXP(xp);
        }
    }

    public void setHealth(double health) {
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            this.yaml.setHealth(health);
        } else if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            this.mysql.setHealth(health);
        }
    }

    public void setFoodLevel(int foodLevel) {
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            this.yaml.setFoodLevel(foodLevel);
        } else if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            this.mysql.setFoodLevel(foodLevel);
        }
    }

    public void setSaturation(float saturation) {
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            this.yaml.setSaturation(saturation);
        } else if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            this.mysql.setSaturation(saturation);
        }
    }

    public void setWorld(String world) {
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            this.yaml.setWorld(world);
        } else if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            this.mysql.setWorld(world);
        }
    }

    public void setX(double x) {
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            this.yaml.setX(x);
        } else if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            this.mysql.setX(x);
        }
    }

    public void setY(double y) {
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            this.yaml.setY(y);
        } else if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            this.mysql.setY(y);
        }
    }

    public void setZ(double z) {
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            this.yaml.setZ(z);
        } else if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            this.mysql.setZ(z);
        }
    }

    public void setLogType(LogType logType) {
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            this.yaml.setLogType(logType);
        }
    }

    public void setVersion(String packageVersion) {
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            this.yaml.setVersion(packageVersion);
        } else if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            this.mysql.setVersion(packageVersion);
        }
    }

    public void setDeathReason(String deathReason) {
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            this.yaml.setDeathReason(deathReason);
        } else if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            this.mysql.setDeathReason(deathReason);
        }
    }

    public void getRollbackMenuData() {
        if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            try {
                this.mysql.getRollbackMenuData();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public CompletableFuture<Void> getAllBackupData() {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            new BukkitRunnable(){

                public void run() {
                    try {
                        PlayerData.this.mysql.getAllBackupData();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    future.complete(null);
                }
            }.runTaskAsynchronously((Plugin)InventoryRollbackPlus.getInstance());
        }
        return future;
    }

    public ItemStack[] getMainInventory() {
        ItemStack[] items = new ItemStack[]{};
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            items = this.yaml.getMainInventory();
        } else if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            items = this.mysql.getMainInventory();
        }
        return items;
    }

    public ItemStack[] getArmour() {
        ItemStack[] items = new ItemStack[]{};
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            items = this.yaml.getArmour();
        } else if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            items = this.mysql.getArmour();
        }
        return items;
    }

    public ItemStack[] getEnderChest() {
        ItemStack[] items = new ItemStack[]{};
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            items = this.yaml.getEnderChest();
        } else if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            items = this.mysql.getEnderChest();
        }
        return items;
    }

    public float getXP() {
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            return this.yaml.getXP();
        }
        if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            return this.mysql.getXP();
        }
        return 0.0f;
    }

    public double getHealth() {
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            return this.yaml.getHealth();
        }
        if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            return this.mysql.getHealth();
        }
        return 0.0;
    }

    public int getFoodLevel() {
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            return this.yaml.getFoodLevel();
        }
        if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            return this.mysql.getFoodLevel();
        }
        return 0;
    }

    public float getSaturation() {
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            return this.yaml.getSaturation();
        }
        if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            return this.mysql.getSaturation();
        }
        return 0.0f;
    }

    public String getWorld() {
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            return this.yaml.getWorld();
        }
        if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            return this.mysql.getWorld();
        }
        return null;
    }

    public double getX() {
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            return this.yaml.getX();
        }
        if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            return this.mysql.getX();
        }
        return 0.0;
    }

    public double getY() {
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            return this.yaml.getY();
        }
        if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            return this.mysql.getY();
        }
        return 0.0;
    }

    public double getZ() {
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            return this.yaml.getZ();
        }
        if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            return this.mysql.getZ();
        }
        return 0.0;
    }

    public LogType getSaveType() {
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            return this.yaml.getSaveType();
        }
        return null;
    }

    public String getVersion() {
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            return this.yaml.getVersion();
        }
        if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            return this.mysql.getVersion();
        }
        return null;
    }

    public String getDeathReason() {
        if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
            return this.yaml.getDeathReason();
        }
        if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
            return this.mysql.getDeathReason();
        }
        return null;
    }

    public void saveData(boolean shouldSaveAsync) {
        boolean saveAsync = !InventoryRollbackPlus.getInstance().isShuttingDown() && shouldSaveAsync;
        Runnable saveDataTask = () -> {
            if (ConfigData.getSaveType() == ConfigData.SaveType.YAML) {
                this.yaml.saveData();
            } else if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
                try {
                    this.mysql.saveData();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        };
        if (saveAsync) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)InventoryRollback.getInstance(), saveDataTask);
        } else {
            saveDataTask.run();
        }
    }

    public int getMaxSaves() {
        if (this.logType == LogType.JOIN) {
            return ConfigData.getMaxSavesJoin();
        }
        if (this.logType == LogType.QUIT) {
            return ConfigData.getMaxSavesQuit();
        }
        if (this.logType == LogType.DEATH) {
            return ConfigData.getMaxSavesDeath();
        }
        if (this.logType == LogType.WORLD_CHANGE) {
            return ConfigData.getMaxSavesWorldChange();
        }
        if (this.logType == LogType.FORCE) {
            return ConfigData.getMaxSavesForce();
        }
        return 0;
    }

    public static String getTime(Long time) {
        SimpleDateFormat sdf = ConfigData.getTimeFormat();
        sdf.setTimeZone(ConfigData.getTimeZone());
        return sdf.format(new Date(time));
    }
}

