/*
 * Decompiled with CFR 0.152.
 */
package me.danjono.inventoryrollback.gui.menu;

import com.nuclyon.technicallycoded.inventoryrollback.InventoryRollbackPlus;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import me.danjono.inventoryrollback.config.ConfigData;
import me.danjono.inventoryrollback.config.MessageData;
import me.danjono.inventoryrollback.data.LogType;
import me.danjono.inventoryrollback.data.PlayerData;
import me.danjono.inventoryrollback.gui.Buttons;
import me.danjono.inventoryrollback.gui.InventoryName;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MainInventoryBackupMenu {
    private final InventoryRollbackPlus main = InventoryRollbackPlus.getInstance();
    private final Player staff;
    private final UUID playerUUID;
    private final LogType logType;
    private final Long timestamp;
    private final ItemStack[] mainInventory;
    private final ItemStack[] armour;
    private final ItemStack[] enderChest;
    private final String location;
    private final double health;
    private final int hunger;
    private final float saturation;
    private final float xp;
    private final Buttons buttons;
    private Inventory inventory;
    private int mainInvLen;

    public MainInventoryBackupMenu(Player staff, PlayerData data, String location) {
        this.staff = staff;
        this.playerUUID = data.getOfflinePlayer().getUniqueId();
        this.logType = data.getLogType();
        this.timestamp = data.getTimestamp();
        this.mainInventory = data.getMainInventory();
        this.armour = data.getArmour();
        this.enderChest = data.getEnderChest();
        this.location = location;
        this.health = data.getHealth();
        this.hunger = data.getFoodLevel();
        this.saturation = data.getSaturation();
        this.xp = data.getXP();
        this.buttons = new Buttons(this.playerUUID);
        this.mainInvLen = this.mainInventory == null ? 0 : this.mainInventory.length;
        this.createInventory();
    }

    public void createInventory() {
        this.inventory = Bukkit.createInventory((InventoryHolder)this.staff, (int)InventoryName.MAIN_BACKUP.getSize(), (String)InventoryName.MAIN_BACKUP.getName());
        this.inventory.setItem(46, this.buttons.inventoryMenuBackButton(MessageData.getBackButton(), this.logType, this.timestamp));
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void showBackupItems() {
        assert (!Bukkit.isPrimaryThread());
        int item = 0;
        int position = 0;
        try {
            new BukkitRunnable(){
                int invPosition = 0;
                int itemPos = 0;
                final int max = MainInventoryBackupMenu.access$000(MainInventoryBackupMenu.this) - 5;

                public void run() {
                    for (int i = 0; i < 6; ++i) {
                        if (this.itemPos >= this.max) {
                            this.cancel();
                            return;
                        }
                        ItemStack itemStack = MainInventoryBackupMenu.this.mainInventory[this.itemPos];
                        if (itemStack != null) {
                            MainInventoryBackupMenu.this.inventory.setItem(this.invPosition, itemStack);
                            ++this.invPosition;
                        }
                        ++this.itemPos;
                    }
                }
            }.runTaskTimer((Plugin)this.main, 0L, 1L);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.staff.sendMessage(MessageData.getPluginPrefix() + MessageData.getErrorInventory());
            return;
        }
        item = 36;
        position = 44;
        if (this.armour != null && this.armour.length > 0) {
            try {
                int i = 0;
                while (i < this.armour.length) {
                    int finalPos = position--;
                    int finalItem = i++;
                    Future placeItemFuture = this.main.getServer().getScheduler().callSyncMethod((Plugin)this.main, () -> {
                        this.inventory.setItem(finalPos, this.armour[finalItem]);
                        return null;
                    });
                    placeItemFuture.get();
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                ex.printStackTrace();
            }
        } else {
            try {
                for (int i = 36; i < this.mainInvLen; ++i) {
                    if (this.mainInventory[item] != null) {
                        int finalPos = position--;
                        int finalItem = item;
                        Future placeItemFuture = this.main.getServer().getScheduler().callSyncMethod((Plugin)this.main, () -> {
                            this.inventory.setItem(finalPos, this.mainInventory[finalItem]);
                            return null;
                        });
                        placeItemFuture.get();
                    }
                    ++item;
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                ex.printStackTrace();
            }
        }
        if (ConfigData.isRestoreToPlayerButton()) {
            this.inventory.setItem(48, this.buttons.restoreAllInventory(this.logType, this.timestamp));
        } else {
            this.inventory.setItem(48, this.buttons.restoreAllInventoryDisabled(this.logType, this.timestamp));
        }
        this.inventory.setItem(49, this.buttons.enderPearlButton(this.logType, this.location));
        this.inventory.setItem(50, this.buttons.enderChestButton(this.logType, this.timestamp, this.enderChest));
        this.inventory.setItem(51, this.buttons.healthButton(this.logType, this.health));
        this.inventory.setItem(52, this.buttons.hungerButton(this.logType, this.hunger, this.saturation));
        this.inventory.setItem(53, this.buttons.experiencePotion(this.logType, this.xp));
    }

    static /* synthetic */ int access$000(MainInventoryBackupMenu x0) {
        return x0.mainInvLen;
    }
}

