/*
 * Decompiled with CFR 0.152.
 */
package me.danjono.inventoryrollback.gui.menu;

import java.util.ArrayList;
import java.util.List;
import me.danjono.inventoryrollback.config.MessageData;
import me.danjono.inventoryrollback.data.LogType;
import me.danjono.inventoryrollback.gui.Buttons;
import me.danjono.inventoryrollback.gui.InventoryName;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class MainMenu {
    private Player staff;
    private int pagesRequired;
    private int pageNumber;
    private Buttons buttons;
    private int startSelection;
    private int playerHeadLoops;
    private List<Player> onlinePlayers;
    private Inventory inventory;

    public MainMenu(Player staff, int pageNumber) {
        this.staff = staff;
        this.pageNumber = pageNumber;
        this.buttons = new Buttons(staff.getUniqueId());
        this.getPlayerHeadData();
        this.createInventory();
    }

    public void createInventory() {
        this.inventory = Bukkit.createInventory((InventoryHolder)this.staff, (int)InventoryName.MAIN_MENU.getSize(), (String)InventoryName.MAIN_MENU.getName());
        ArrayList<String> lore = new ArrayList<String>();
        if (this.pageNumber > 1) {
            lore.add("Page " + (this.pageNumber - 1));
            ItemStack previousPage = this.buttons.backButton(MessageData.getPreviousPageButton(), LogType.UNKNOWN, this.pageNumber - 1, lore);
            this.inventory.setItem(InventoryName.MAIN_MENU.getSize() - 8, previousPage);
            lore.clear();
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void getMainMenu() {
        int selection = this.startSelection;
        for (int i = 0; i < this.playerHeadLoops; ++i) {
            Player player = this.onlinePlayers.get(selection);
            Buttons playerButton = new Buttons((OfflinePlayer)player);
            this.inventory.setItem(i, playerButton.playerHead(null, true));
            ++selection;
        }
        ArrayList<String> lore = new ArrayList<String>();
        if (this.pageNumber < this.pagesRequired) {
            lore.add("Page " + (this.pageNumber + 1));
            ItemStack nextPage = this.buttons.nextButton(MessageData.getNextPageButton(), LogType.UNKNOWN, this.pageNumber + 1, lore);
            this.inventory.setItem(InventoryName.MAIN_MENU.getSize() - 2, nextPage);
            lore.clear();
        }
    }

    public void getPlayerHeadData() {
        this.onlinePlayers = new ArrayList<Player>(Bukkit.getOnlinePlayers());
        int playersOnline = this.onlinePlayers.size();
        int spaceRequired = InventoryName.MAIN_MENU.getSize() - 9;
        this.pagesRequired = (int)Math.ceil((double)playersOnline / (double)spaceRequired);
        if (this.pageNumber > this.pagesRequired) {
            this.pageNumber = this.pagesRequired;
        } else if (this.pageNumber <= 0) {
            this.pageNumber = 1;
        }
        this.startSelection = (InventoryName.MAIN_MENU.getSize() - 9) * this.pageNumber - (InventoryName.MAIN_MENU.getSize() - 9);
        int variance = playersOnline - (spaceRequired + this.startSelection);
        this.playerHeadLoops = variance > 0 ? spaceRequired : spaceRequired + variance;
    }
}

