/*
 * Decompiled with CFR 0.152.
 */
package me.danjono.inventoryrollback.gui.menu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import me.danjono.inventoryrollback.config.MessageData;
import me.danjono.inventoryrollback.data.LogType;
import me.danjono.inventoryrollback.data.PlayerData;
import me.danjono.inventoryrollback.gui.Buttons;
import me.danjono.inventoryrollback.gui.InventoryName;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class PlayerMenu {
    private Player staff;
    private OfflinePlayer offlinePlayer;
    private Buttons buttons;
    private Inventory inventory;

    public PlayerMenu(Player staff, OfflinePlayer player) {
        this.staff = staff;
        this.offlinePlayer = player;
        this.buttons = new Buttons(player.getUniqueId());
        this.createInventory();
    }

    public void createInventory() {
        this.inventory = Bukkit.createInventory((InventoryHolder)this.staff, (int)InventoryName.PLAYER_MENU.getSize(), (String)InventoryName.PLAYER_MENU.getName());
        this.inventory.setItem(2, this.buttons.createDeathLogButton(LogType.DEATH, null));
        this.inventory.setItem(3, this.buttons.createJoinLogButton(LogType.JOIN, null));
        this.inventory.setItem(4, this.buttons.createQuitLogButton(LogType.QUIT, null));
        this.inventory.setItem(5, this.buttons.createWorldChangeLogButton(LogType.WORLD_CHANGE, null));
        this.inventory.setItem(6, this.buttons.createForceSaveLogButton(LogType.FORCE, null));
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void getPlayerMenu() {
        ArrayList<String> lore = new ArrayList<String>();
        if (this.offlinePlayer.isOnline()) {
            lore.add(ChatColor.GREEN + "Online now");
        } else if (!this.offlinePlayer.hasPlayedBefore()) {
            lore.add(ChatColor.RED + "Never played on this server");
        } else {
            lore.add(ChatColor.RED + "Offline");
            String dateTime = "Unknown";
            if (this.offlinePlayer.getLastPlayed() != 0L) {
                dateTime = PlayerData.getTime(this.offlinePlayer.getLastPlayed());
            }
            lore.add(ChatColor.RED + "Last online: " + dateTime);
        }
        this.inventory.setItem(0, this.buttons.playerHead(lore, true));
        UUID uuid = this.offlinePlayer.getUniqueId();
        PlayerData deathBackup = new PlayerData(uuid, LogType.DEATH, null);
        PlayerData joinBackup = new PlayerData(uuid, LogType.JOIN, null);
        PlayerData quitBackup = new PlayerData(uuid, LogType.QUIT, null);
        PlayerData worldChangeBackup = new PlayerData(uuid, LogType.WORLD_CHANGE, null);
        PlayerData forceSaveBackup = new PlayerData(uuid, LogType.FORCE, null);
        if (!(joinBackup.doesBackupTypeExist() || quitBackup.doesBackupTypeExist() || deathBackup.doesBackupTypeExist() || worldChangeBackup.doesBackupTypeExist() || forceSaveBackup.doesBackupTypeExist())) {
            this.staff.sendMessage(MessageData.getPluginPrefix() + MessageData.getNoBackupError(this.offlinePlayer.getName()));
        }
        String backupsAvailable = " backup(s) available";
        List<String> deaths = Arrays.asList(deathBackup.getAmountOfBackups() + backupsAvailable);
        this.inventory.setItem(2, this.buttons.createDeathLogButton(LogType.DEATH, deaths));
        List<String> joins = Arrays.asList(joinBackup.getAmountOfBackups() + backupsAvailable);
        this.inventory.setItem(3, this.buttons.createJoinLogButton(LogType.JOIN, joins));
        List<String> quits = Arrays.asList(quitBackup.getAmountOfBackups() + backupsAvailable);
        this.inventory.setItem(4, this.buttons.createQuitLogButton(LogType.QUIT, quits));
        List<String> worldChange = Arrays.asList(worldChangeBackup.getAmountOfBackups() + backupsAvailable);
        this.inventory.setItem(5, this.buttons.createWorldChangeLogButton(LogType.WORLD_CHANGE, worldChange));
        List<String> forceSaves = Arrays.asList(forceSaveBackup.getAmountOfBackups() + backupsAvailable);
        this.inventory.setItem(6, this.buttons.createForceSaveLogButton(LogType.FORCE, forceSaves));
    }
}

