/*
 * Decompiled with CFR 0.152.
 */
package me.danjono.inventoryrollback.listeners;

import com.nuclyon.technicallycoded.inventoryrollback.InventoryRollbackPlus;
import com.nuclyon.technicallycoded.inventoryrollback.bukkitversion.BukkitVersion;
import com.nuclyon.technicallycoded.inventoryrollback.customdata.CustomDataItemEditor;
import com.nuclyon.technicallycoded.inventoryrollback.paperlib.PaperLib;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import me.danjono.inventoryrollback.InventoryRollback;
import me.danjono.inventoryrollback.config.ConfigData;
import me.danjono.inventoryrollback.config.MessageData;
import me.danjono.inventoryrollback.config.SoundData;
import me.danjono.inventoryrollback.data.LogType;
import me.danjono.inventoryrollback.data.PlayerData;
import me.danjono.inventoryrollback.gui.Buttons;
import me.danjono.inventoryrollback.gui.InventoryName;
import me.danjono.inventoryrollback.gui.menu.EnderChestBackupMenu;
import me.danjono.inventoryrollback.gui.menu.MainInventoryBackupMenu;
import me.danjono.inventoryrollback.gui.menu.MainMenu;
import me.danjono.inventoryrollback.gui.menu.PlayerMenu;
import me.danjono.inventoryrollback.gui.menu.RollbackListMenu;
import me.danjono.inventoryrollback.inventory.RestoreInventory;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ClickGUI
implements Listener {
    private final InventoryRollbackPlus main = InventoryRollbackPlus.getInstance();

    private static boolean isLocationAvailable(Location location) {
        return location != null;
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent e) {
        String title = e.getView().getTitle();
        if (!(title.equals(InventoryName.MAIN_MENU.getName()) || title.equals(InventoryName.PLAYER_MENU.getName()) || title.equalsIgnoreCase(InventoryName.ROLLBACK_LIST.getName()) || title.equalsIgnoreCase(InventoryName.MAIN_BACKUP.getName()) || title.equalsIgnoreCase(InventoryName.ENDER_CHEST_BACKUP.getName()))) {
            return;
        }
        e.setCancelled(true);
        if (this.main.getVersion().greaterOrEqThan(BukkitVersion.v1_9_R1) && ClickGUI.isLocationAvailable(e.getInventory().getLocation())) {
            e.setCancelled(false);
            return;
        }
        for (Integer slot : e.getRawSlots()) {
            if (slot >= e.getInventory().getSize()) continue;
            return;
        }
        e.setCancelled(false);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        String title = e.getView().getTitle();
        if (!(title.equals(InventoryName.MAIN_MENU.getName()) || title.equals(InventoryName.PLAYER_MENU.getName()) || title.equalsIgnoreCase(InventoryName.ROLLBACK_LIST.getName()) || title.equalsIgnoreCase(InventoryName.MAIN_BACKUP.getName()) || title.equalsIgnoreCase(InventoryName.ENDER_CHEST_BACKUP.getName()))) {
            return;
        }
        if (this.main.getVersion().greaterOrEqThan(BukkitVersion.v1_9_R1) && ClickGUI.isLocationAvailable(e.getInventory().getLocation())) {
            return;
        }
        e.setCancelled(true);
        Player staff = (Player)e.getWhoClicked();
        ItemStack icon = e.getCurrentItem();
        if (title.equals(InventoryName.MAIN_MENU.getName())) {
            this.mainMenu(e, staff, icon);
        } else if (title.equals(InventoryName.PLAYER_MENU.getName())) {
            this.playerMenu(e, staff, icon);
        } else if (title.equals(InventoryName.ROLLBACK_LIST.getName())) {
            this.rollbackMenu(e, staff, icon);
        } else if (title.equals(InventoryName.MAIN_BACKUP.getName())) {
            this.mainBackupMenu(e, staff, icon);
        } else if (title.equals(InventoryName.ENDER_CHEST_BACKUP.getName())) {
            this.enderChestBackupMenu(e, staff, icon);
        } else {
            e.setCancelled(true);
        }
    }

    private void mainMenu(InventoryClickEvent e, Player staff, ItemStack icon) {
        if (e.getRawSlot() >= 0 && e.getRawSlot() < InventoryName.MAIN_MENU.getSize()) {
            CustomDataItemEditor nbt = CustomDataItemEditor.editItem(icon);
            if (!nbt.hasUUID()) {
                return;
            }
            if (icon.getType().equals((Object)Buttons.getPageSelectorIcon())) {
                int page = nbt.getInt("page");
                MainMenu menu = new MainMenu(staff, page);
                staff.openInventory(menu.getInventory());
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)InventoryRollback.getInstance(), menu::getMainMenu);
            } else {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(nbt.getString("uuid")));
                PlayerMenu menu = new PlayerMenu(staff, offlinePlayer);
                staff.openInventory(menu.getInventory());
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)InventoryRollback.getInstance(), menu::getPlayerMenu);
            }
        } else if (e.getRawSlot() >= e.getInventory().getSize() && !e.isShiftClick()) {
            e.setCancelled(false);
        }
    }

    private void playerMenu(InventoryClickEvent e, Player staff, ItemStack icon) {
        if (icon == null) {
            return;
        }
        if (e.getRawSlot() >= 0 && e.getRawSlot() < InventoryName.PLAYER_MENU.getSize()) {
            CustomDataItemEditor nbt = CustomDataItemEditor.editItem(icon);
            if (!nbt.hasUUID()) {
                return;
            }
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(nbt.getString("uuid")));
            if (e.getRawSlot() == 0) {
                MainMenu menu = new MainMenu(staff, 1);
                staff.openInventory(menu.getInventory());
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)InventoryRollback.getInstance(), menu::getMainMenu);
            } else {
                LogType logType = LogType.valueOf(nbt.getString("logType"));
                RollbackListMenu menu = new RollbackListMenu(staff, offlinePlayer, logType, 1);
                staff.openInventory(menu.getInventory());
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)InventoryRollback.getInstance(), menu::showBackups);
            }
        } else if (e.getRawSlot() >= e.getInventory().getSize() && !e.isShiftClick()) {
            e.setCancelled(false);
        }
    }

    private void rollbackMenu(InventoryClickEvent e, final Player staff, ItemStack icon) {
        if (e.getRawSlot() >= 0 && e.getRawSlot() < InventoryName.ROLLBACK_LIST.getSize()) {
            if (icon == null) {
                return;
            }
            CustomDataItemEditor nbt = CustomDataItemEditor.editItem(icon);
            if (!nbt.hasUUID()) {
                return;
            }
            if (icon.getType().equals((Object)Material.CHEST)) {
                final UUID uuid = UUID.fromString(nbt.getString("uuid"));
                final Long timestamp = nbt.getLong("timestamp");
                final LogType logType = LogType.valueOf(nbt.getString("logType"));
                final String location = nbt.getString("location");
                new BukkitRunnable(){

                    public void run() {
                        PlayerData data = new PlayerData(uuid, logType, timestamp);
                        if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
                            try {
                                data.getAllBackupData().get();
                            }
                            catch (InterruptedException | ExecutionException ex) {
                                ex.printStackTrace();
                            }
                        }
                        MainInventoryBackupMenu menu = new MainInventoryBackupMenu(staff, data, location);
                        Future inventoryViewFuture = ClickGUI.this.main.getServer().getScheduler().callSyncMethod((Plugin)ClickGUI.this.main, () -> staff.openInventory(menu.getInventory()));
                        try {
                            inventoryViewFuture.get();
                            menu.showBackupItems();
                        }
                        catch (InterruptedException | NullPointerException | ExecutionException ex) {
                            ex.printStackTrace();
                        }
                    }
                }.runTaskAsynchronously((Plugin)this.main);
            } else if (icon.getType().equals((Object)Buttons.getPageSelectorIcon())) {
                int page = nbt.getInt("page");
                OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)UUID.fromString(nbt.getString("uuid")));
                if (page == 0) {
                    PlayerMenu menu = new PlayerMenu(staff, player);
                    staff.openInventory(menu.getInventory());
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)InventoryRollback.getInstance(), menu::getPlayerMenu);
                } else {
                    LogType logType = LogType.valueOf(nbt.getString("logType"));
                    RollbackListMenu menu = new RollbackListMenu(staff, player, logType, page);
                    staff.openInventory(menu.getInventory());
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)InventoryRollback.getInstance(), menu::showBackups);
                }
            }
        } else if (e.getRawSlot() >= e.getInventory().getSize() && !e.isShiftClick()) {
            e.setCancelled(false);
        }
    }

    private void mainBackupMenu(InventoryClickEvent e, final Player staff, ItemStack icon) {
        if (!e.getView().getTitle().equals(InventoryName.MAIN_BACKUP.getName())) {
            return;
        }
        if (e.getRawSlot() >= InventoryName.MAIN_BACKUP.getSize() - 9 && e.getRawSlot() < InventoryName.MAIN_BACKUP.getSize()) {
            CustomDataItemEditor nbt = CustomDataItemEditor.editItem(icon);
            if (!nbt.hasUUID()) {
                return;
            }
            final OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(nbt.getString("uuid")));
            final LogType logType = LogType.valueOf(nbt.getString("logType"));
            final Long timestamp = nbt.getLong("timestamp");
            if (icon.getType().equals((Object)Buttons.getPageSelectorIcon())) {
                RollbackListMenu menu = new RollbackListMenu(staff, offlinePlayer, logType, 1);
                staff.openInventory(menu.getInventory());
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)InventoryRollback.getInstance(), menu::showBackups);
            } else if (icon.getType().equals((Object)Buttons.getRestoreAllInventoryIcon())) {
                if (!staff.hasPermission("inventoryrollbackplus.restore")) {
                    staff.sendMessage(MessageData.getPluginPrefix() + MessageData.getNoPermission());
                    return;
                }
                if (offlinePlayer.isOnline()) {
                    final Player player = (Player)offlinePlayer;
                    new BukkitRunnable(){

                        public void run() {
                            PlayerData data = new PlayerData(offlinePlayer, logType, timestamp);
                            if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
                                try {
                                    data.getAllBackupData().get();
                                }
                                catch (InterruptedException | ExecutionException ex) {
                                    ex.printStackTrace();
                                }
                            }
                            ItemStack[] inventory = data.getMainInventory();
                            ItemStack[] armour = data.getArmour();
                            Future futureSetInv = ClickGUI.this.main.getServer().getScheduler().callSyncMethod((Plugin)ClickGUI.this.main, () -> {
                                player.getInventory().setContents(inventory);
                                return null;
                            });
                            try {
                                futureSetInv.get();
                            }
                            catch (InterruptedException | ExecutionException ex) {
                                ex.printStackTrace();
                            }
                            if (ClickGUI.this.main.getVersion().lessOrEqThan(BukkitVersion.v1_8_R3)) {
                                Future futureSetArmor = ClickGUI.this.main.getServer().getScheduler().callSyncMethod((Plugin)ClickGUI.this.main, () -> {
                                    player.getInventory().setArmorContents(armour);
                                    return null;
                                });
                                try {
                                    futureSetArmor.get();
                                }
                                catch (InterruptedException | ExecutionException ex) {
                                    ex.printStackTrace();
                                }
                            }
                            if (SoundData.isInventoryRestoreEnabled()) {
                                Future futurePlaySound = ClickGUI.this.main.getServer().getScheduler().callSyncMethod((Plugin)ClickGUI.this.main, () -> {
                                    player.playSound(player.getLocation(), SoundData.getInventoryRestored(), 1.0f, 1.0f);
                                    return null;
                                });
                                try {
                                    futurePlaySound.get();
                                }
                                catch (InterruptedException | ExecutionException ex) {
                                    ex.printStackTrace();
                                }
                            }
                            player.sendMessage(MessageData.getPluginPrefix() + MessageData.getMainInventoryRestoredPlayer(staff.getName()));
                            if (!staff.getUniqueId().equals(player.getUniqueId())) {
                                staff.sendMessage(MessageData.getPluginPrefix() + MessageData.getMainInventoryRestored(offlinePlayer.getName()));
                            }
                        }
                    }.runTaskAsynchronously((Plugin)this.main);
                } else {
                    staff.sendMessage(MessageData.getPluginPrefix() + MessageData.getMainInventoryNotOnline(offlinePlayer.getName()));
                }
            } else if (icon.getType().equals((Object)Buttons.getTeleportLocationIcon())) {
                if (!staff.hasPermission("inventoryrollbackplus.restore.teleport")) {
                    staff.sendMessage(MessageData.getPluginPrefix() + MessageData.getNoPermission());
                    return;
                }
                String[] location = nbt.getString("location").split(",");
                World world = Bukkit.getWorld((String)location[0]);
                if (world == null) {
                    staff.sendMessage(MessageData.getPluginPrefix() + MessageData.getDeathLocationInvalidWorldError(location[0]));
                    return;
                }
                Location loc = new Location(world, Math.floor(Double.parseDouble(location[1])), Math.floor(Double.parseDouble(location[2])), Math.floor(Double.parseDouble(location[3]))).add(0.5, 0.5, 0.5);
                Bukkit.getScheduler().runTaskLater((Plugin)InventoryRollback.getInstance(), () -> {
                    e.getWhoClicked().closeInventory();
                    PaperLib.teleportAsync((Entity)staff, loc).thenAccept(result -> {
                        if (SoundData.isTeleportEnabled()) {
                            staff.playSound(loc, SoundData.getTeleport(), 1.0f, 1.0f);
                        }
                        staff.sendMessage(MessageData.getPluginPrefix() + MessageData.getDeathLocationTeleport(loc));
                    });
                }, 1L);
            } else if (icon.getType().equals((Object)Buttons.getEnderChestIcon())) {
                new BukkitRunnable(){

                    public void run() {
                        PlayerData data = new PlayerData(offlinePlayer, logType, timestamp);
                        if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
                            try {
                                data.getAllBackupData().get();
                            }
                            catch (InterruptedException | ExecutionException ex) {
                                ex.printStackTrace();
                            }
                        }
                        EnderChestBackupMenu menu = new EnderChestBackupMenu(staff, data, 1);
                        Future futureOpenInv = ClickGUI.this.main.getServer().getScheduler().callSyncMethod((Plugin)ClickGUI.this.main, () -> {
                            staff.openInventory(menu.getInventory());
                            return null;
                        });
                        try {
                            futureOpenInv.get();
                        }
                        catch (InterruptedException | ExecutionException ex) {
                            ex.printStackTrace();
                        }
                        menu.showEnderChestItems();
                    }
                }.runTaskAsynchronously((Plugin)this.main);
            } else if (icon.getType().equals((Object)Buttons.getHealthIcon())) {
                if (!staff.hasPermission("inventoryrollbackplus.restore")) {
                    staff.sendMessage(MessageData.getPluginPrefix() + MessageData.getNoPermission());
                    return;
                }
                if (offlinePlayer.isOnline()) {
                    Player player = (Player)offlinePlayer;
                    double health = nbt.getDouble("health");
                    player.setHealth(health);
                    if (SoundData.isFoodRestoredEnabled()) {
                        player.playSound(player.getLocation(), SoundData.getFoodRestored(), 1.0f, 1.0f);
                    }
                    player.sendMessage(MessageData.getPluginPrefix() + MessageData.getHealthRestoredPlayer(staff.getName()));
                    if (!staff.getUniqueId().equals(player.getUniqueId())) {
                        staff.sendMessage(MessageData.getPluginPrefix() + MessageData.getHealthRestored(player.getName()));
                    }
                } else {
                    staff.sendMessage(MessageData.getPluginPrefix() + MessageData.getHealthNotOnline(offlinePlayer.getName()));
                }
            } else if (icon.getType().equals((Object)Buttons.getHungerIcon())) {
                if (!staff.hasPermission("inventoryrollbackplus.restore")) {
                    staff.sendMessage(MessageData.getPluginPrefix() + MessageData.getNoPermission());
                    return;
                }
                if (offlinePlayer.isOnline()) {
                    Player player = (Player)offlinePlayer;
                    int hunger = nbt.getInt("hunger");
                    Float saturation = nbt.getFloat("saturation");
                    player.setFoodLevel(hunger);
                    player.setSaturation(saturation.floatValue());
                    if (SoundData.isHungerRestoredEnabled()) {
                        player.playSound(player.getLocation(), SoundData.getHungerRestored(), 1.0f, 1.0f);
                    }
                    player.sendMessage(MessageData.getPluginPrefix() + MessageData.getHungerRestoredPlayer(staff.getName()));
                    if (!staff.getUniqueId().equals(player.getUniqueId())) {
                        staff.sendMessage(MessageData.getPluginPrefix() + MessageData.getHungerRestored(player.getName()));
                    }
                } else {
                    staff.sendMessage(MessageData.getPluginPrefix() + MessageData.getHungerNotOnline(offlinePlayer.getName()));
                }
            } else if (icon.getType().equals((Object)Buttons.getExperienceIcon())) {
                if (!staff.hasPermission("inventoryrollbackplus.restore")) {
                    staff.sendMessage(MessageData.getPluginPrefix() + MessageData.getNoPermission());
                    return;
                }
                if (offlinePlayer.isOnline()) {
                    Player player = (Player)offlinePlayer;
                    Float xp = nbt.getFloat("xp");
                    RestoreInventory.setTotalExperience(player, xp.floatValue());
                    if (SoundData.isExperienceRestoredEnabled()) {
                        player.playSound(player.getLocation(), SoundData.getExperienceSound(), 1.0f, 1.0f);
                    }
                    int level = (int)RestoreInventory.getLevel(xp.floatValue());
                    player.sendMessage(MessageData.getPluginPrefix() + MessageData.getExperienceRestoredPlayer(staff.getName(), level));
                    if (!staff.getUniqueId().equals(player.getUniqueId())) {
                        staff.sendMessage(MessageData.getPluginPrefix() + MessageData.getExperienceRestored(player.getName(), level));
                    }
                } else {
                    staff.sendMessage(MessageData.getPluginPrefix() + MessageData.getExperienceNotOnlinePlayer(offlinePlayer.getName()));
                }
            }
        } else {
            boolean isValidBackupMenuInteraction;
            int topInvSize;
            int slotIndex = e.getRawSlot();
            boolean clickIsWithinPlayerInventory = slotIndex >= (topInvSize = e.getView().getTopInventory().getSize());
            boolean clickIsWithinMainBackupInv = slotIndex < topInvSize - 18;
            boolean notInLastLine = slotIndex < topInvSize - 9;
            boolean notBeforeArmorSlots = slotIndex > topInvSize - 15;
            boolean clickIsWithinArmorOrOffHandSlots = notInLastLine && notBeforeArmorSlots;
            boolean bl = isValidBackupMenuInteraction = clickIsWithinMainBackupInv || clickIsWithinArmorOrOffHandSlots;
            if (clickIsWithinPlayerInventory && !e.isShiftClick()) {
                e.setCancelled(false);
            } else if (isValidBackupMenuInteraction) {
                if (staff.hasPermission("inventoryrollbackplus.restore")) {
                    e.setCancelled(false);
                } else {
                    staff.sendMessage(MessageData.getPluginPrefix() + MessageData.getNoPermission());
                }
            }
        }
    }

    private void enderChestBackupMenu(InventoryClickEvent e, final Player staff, ItemStack icon) {
        if (!e.getView().getTitle().equals(InventoryName.ENDER_CHEST_BACKUP.getName())) {
            return;
        }
        if (e.getRawSlot() >= InventoryName.ENDER_CHEST_BACKUP.getSize() - 9 && e.getRawSlot() < InventoryName.ENDER_CHEST_BACKUP.getSize()) {
            CustomDataItemEditor nbt = CustomDataItemEditor.editItem(icon);
            if (!nbt.hasUUID()) {
                return;
            }
            final OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(nbt.getString("uuid")));
            final LogType logType = LogType.valueOf(nbt.getString("logType"));
            final Long timestamp = nbt.getLong("timestamp");
            if (icon.getType().equals((Object)Buttons.getPageSelectorIcon())) {
                final int page = nbt.getInt("page");
                if (page == 0) {
                    new BukkitRunnable(){

                        public void run() {
                            PlayerData data = new PlayerData(offlinePlayer, logType, timestamp);
                            if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
                                try {
                                    data.getAllBackupData().get();
                                }
                                catch (InterruptedException | ExecutionException ex) {
                                    ex.printStackTrace();
                                }
                            }
                            String location = data.getWorld() + "," + data.getX() + "," + data.getY() + "," + data.getZ();
                            MainInventoryBackupMenu menu = new MainInventoryBackupMenu(staff, data, location);
                            Future inventoryViewFuture = ClickGUI.this.main.getServer().getScheduler().callSyncMethod((Plugin)ClickGUI.this.main, () -> staff.openInventory(menu.getInventory()));
                            try {
                                inventoryViewFuture.get();
                                menu.showBackupItems();
                            }
                            catch (InterruptedException | NullPointerException | ExecutionException ex) {
                                ex.printStackTrace();
                            }
                        }
                    }.runTaskAsynchronously((Plugin)this.main);
                } else {
                    new BukkitRunnable(){

                        public void run() {
                            PlayerData data = new PlayerData(offlinePlayer, logType, timestamp);
                            if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
                                try {
                                    data.getAllBackupData().get();
                                }
                                catch (InterruptedException | ExecutionException ex) {
                                    ex.printStackTrace();
                                }
                            }
                            EnderChestBackupMenu menu = new EnderChestBackupMenu(staff, data, page);
                            Future futureOpenInv = ClickGUI.this.main.getServer().getScheduler().callSyncMethod((Plugin)ClickGUI.this.main, () -> {
                                staff.openInventory(menu.getInventory());
                                return null;
                            });
                            try {
                                futureOpenInv.get();
                            }
                            catch (InterruptedException | ExecutionException ex) {
                                ex.printStackTrace();
                            }
                            menu.showEnderChestItems();
                        }
                    }.runTaskAsynchronously((Plugin)this.main);
                }
            } else if (icon.getType().equals((Object)Buttons.getRestoreAllInventoryIcon())) {
                if (!staff.hasPermission("inventoryrollbackplus.restore")) {
                    staff.sendMessage(MessageData.getPluginPrefix() + MessageData.getNoPermission());
                    return;
                }
                if (offlinePlayer.isOnline()) {
                    final Player player = (Player)offlinePlayer;
                    new BukkitRunnable(){

                        public void run() {
                            PlayerData data = new PlayerData(offlinePlayer, logType, timestamp);
                            if (ConfigData.getSaveType() == ConfigData.SaveType.MYSQL) {
                                try {
                                    data.getAllBackupData().get();
                                }
                                catch (InterruptedException | ExecutionException ex) {
                                    ex.printStackTrace();
                                }
                            }
                            Future inventoryReplaceFuture = ClickGUI.this.main.getServer().getScheduler().callSyncMethod((Plugin)ClickGUI.this.main, () -> {
                                ItemStack[] enderChest = data.getEnderChest();
                                if (enderChest == null) {
                                    enderChest = new ItemStack[]{};
                                }
                                player.getEnderChest().setContents(enderChest);
                                return null;
                            });
                            try {
                                inventoryReplaceFuture.get();
                            }
                            catch (InterruptedException | NullPointerException | ExecutionException ex) {
                                ex.printStackTrace();
                            }
                        }
                    }.runTaskAsynchronously((Plugin)this.main);
                    if (SoundData.isInventoryRestoreEnabled()) {
                        player.playSound(player.getLocation(), SoundData.getInventoryRestored(), 1.0f, 1.0f);
                    }
                    player.sendMessage(MessageData.getPluginPrefix() + MessageData.getEnderChestRestoredPlayer(staff.getName()));
                    if (!staff.getUniqueId().equals(player.getUniqueId())) {
                        staff.sendMessage(MessageData.getPluginPrefix() + MessageData.getEnderChestRestored(offlinePlayer.getName()));
                    }
                } else {
                    staff.sendMessage(MessageData.getPluginPrefix() + MessageData.getEnderChestNotOnline(offlinePlayer.getName()));
                }
            }
        } else {
            int topInvSize;
            boolean clickIsWithinPlayerInventory;
            int slotIndex = e.getRawSlot();
            boolean bl = clickIsWithinPlayerInventory = slotIndex >= (topInvSize = e.getView().getTopInventory().getSize());
            if (clickIsWithinPlayerInventory && !e.isShiftClick()) {
                e.setCancelled(false);
            } else if (slotIndex < topInvSize - 9) {
                if (!staff.hasPermission("inventoryrollbackplus.restore")) {
                    staff.sendMessage(MessageData.getPluginPrefix() + MessageData.getNoPermission());
                    return;
                }
                e.setCancelled(false);
            }
        }
    }
}

