/*
 * Decompiled with CFR 0.152.
 */
package me.danjono.inventoryrollback.listeners;

import com.nuclyon.technicallycoded.inventoryrollback.InventoryRollbackPlus;
import com.nuclyon.technicallycoded.inventoryrollback.bukkitversion.BukkitVersion;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.danjono.inventoryrollback.config.ConfigData;
import me.danjono.inventoryrollback.data.LogType;
import me.danjono.inventoryrollback.inventory.SaveInventory;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;

public class EventLogs
implements Listener {
    private InventoryRollbackPlus main = InventoryRollbackPlus.getInstance();
    private Map<UUID, SaveInventory.PlayerDataSnapshot> inventoryCache = new ConcurrentHashMap<UUID, SaveInventory.PlayerDataSnapshot>();

    public static void patchLowestHandlers() {
        HandlerList deathEventHandlers = PlayerDeathEvent.getHandlerList();
        ArrayList<RegisteredListener> otherDeathHandlers = new ArrayList<RegisteredListener>();
        for (RegisteredListener handler : deathEventHandlers.getRegisteredListeners()) {
            if (handler.getPriority() != EventPriority.LOWEST || handler.getListener().getClass() == EventLogs.class) continue;
            otherDeathHandlers.add(handler);
        }
        for (RegisteredListener handler : otherDeathHandlers) {
            deathEventHandlers.unregister(handler);
            deathEventHandlers.register(handler);
        }
        deathEventHandlers.bake();
    }

    @EventHandler
    private void playerJoin(PlayerJoinEvent e) {
        if (!ConfigData.isEnabled()) {
            return;
        }
        Player player = e.getPlayer();
        if (player.hasPermission("inventoryrollbackplus.joinsave")) {
            new SaveInventory(e.getPlayer(), LogType.JOIN, null, null).snapshotAndSave(player.getInventory(), player.getEnderChest(), true);
        }
        if (player.hasPermission("inventoryrollbackplus.adminalerts")) {
            // empty if block
        }
    }

    @EventHandler
    private void playerQuit(PlayerQuitEvent e) {
        if (!ConfigData.isEnabled()) {
            return;
        }
        Player player = e.getPlayer();
        if (player.hasPermission("inventoryrollbackplus.leavesave")) {
            new SaveInventory(e.getPlayer(), LogType.QUIT, null, null).snapshotAndSave(player.getInventory(), player.getEnderChest(), true);
        }
        UUID uuid = player.getUniqueId();
        this.main.getServer().getScheduler().runTaskLater((Plugin)this.main, () -> {
            if (this.main.getServer().getPlayer(uuid) != null) {
                return;
            }
            SaveInventory.cleanup(uuid);
        }, 1L);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void playerPreDeath(EntityDamageEvent event) {
        if (ConfigData.isAllowOtherPluginEditDeathInventory()) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        UUID uuid = player.getUniqueId();
        if (!this.isDeathDamage(event)) {
            this.inventoryCache.remove(uuid);
            return;
        }
        SaveInventory saveInventory = new SaveInventory(player, LogType.DEATH, event.getCause(), null);
        SaveInventory.PlayerDataSnapshot snapshot = saveInventory.createSnapshot(player.getInventory(), player.getEnderChest());
        this.inventoryCache.put(uuid, snapshot);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void playerPreDeathCheck(EntityDamageEvent event) {
        if (ConfigData.isAllowOtherPluginEditDeathInventory()) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        UUID uuid = player.getUniqueId();
        if (event.isCancelled() || event.getFinalDamage() == 0.0) {
            this.inventoryCache.remove(uuid);
            return;
        }
        SaveInventory.PlayerDataSnapshot firstSnapshot = this.inventoryCache.get(uuid);
        if (firstSnapshot == null) {
            return;
        }
        SaveInventory saveInventory = new SaveInventory(player, LogType.DEATH, event.getCause(), null);
        SaveInventory.PlayerDataSnapshot lastSnapshot = saveInventory.createSnapshot(player.getInventory(), player.getEnderChest());
        if (firstSnapshot.equals(lastSnapshot)) {
            this.inventoryCache.remove(uuid);
            return;
        }
        InventoryRollbackPlus.getInstance().getLogger().warning(player.getName() + "'s inventory was edited during damage handling (instead of death, this is bad). Please find which plugin is doing this by disabling one plugin at the time (or use \"binary search\" if you know how) until this message disappears!");
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void playerDeathEarly(PlayerDeathEvent event) {
        if (ConfigData.isAllowOtherPluginEditDeathInventory()) {
            return;
        }
        this.playerDeathHandle(event);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void playerDeathLate(PlayerDeathEvent event) {
        if (!ConfigData.isAllowOtherPluginEditDeathInventory()) {
            return;
        }
        this.playerDeathHandle(event);
    }

    public void playerDeathHandle(PlayerDeathEvent event) {
        if (!ConfigData.isEnabled()) {
            return;
        }
        Player player = event.getEntity();
        if (player.hasPermission("inventoryrollbackplus.deathsave")) {
            EntityDamageEvent damageEvent = event.getEntity().getLastDamageCause();
            DetailedReason detailedReason = this.getDetailedReason(damageEvent);
            SaveInventory saveInventory = new SaveInventory(player, LogType.DEATH, detailedReason.damageCause, detailedReason.reason);
            UUID uuid = player.getUniqueId();
            SaveInventory.PlayerDataSnapshot preSnapshot = this.inventoryCache.get(uuid);
            if (preSnapshot == null) {
                saveInventory.snapshotAndSave(player.getInventory(), player.getEnderChest(), true);
            } else {
                saveInventory.save(preSnapshot, true);
                this.inventoryCache.remove(uuid);
            }
        }
    }

    @EventHandler
    private void playerChangeWorld(PlayerChangedWorldEvent e) {
        if (!ConfigData.isEnabled()) {
            return;
        }
        Player player = e.getPlayer();
        if (player.hasPermission("inventoryrollbackplus.worldchangesave")) {
            new SaveInventory(e.getPlayer(), LogType.WORLD_CHANGE, null, null).snapshotAndSave(player.getInventory(), player.getEnderChest(), true);
        }
    }

    public boolean isEntityCause(EntityDamageEvent.DamageCause cause) {
        if (cause.equals((Object)EntityDamageEvent.DamageCause.ENTITY_ATTACK) || cause.equals((Object)EntityDamageEvent.DamageCause.PROJECTILE)) {
            return true;
        }
        return this.main.getVersion().greaterOrEqThan(BukkitVersion.v1_11_R1) && cause.equals((Object)EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK);
    }

    private boolean isDeathDamage(EntityDamageEvent event) {
        if (!(event.getEntity() instanceof LivingEntity)) {
            return false;
        }
        LivingEntity living = (LivingEntity)event.getEntity();
        return event.getFinalDamage() >= living.getHealth();
    }

    @NotNull
    private DetailedReason getDetailedReason(EntityDamageEvent damageEvent) {
        EntityDamageEvent.DamageCause damageCause = damageEvent == null ? EntityDamageEvent.DamageCause.CUSTOM : damageEvent.getCause();
        String reason = null;
        if (this.isEntityCause(damageCause) && damageEvent instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent damageByEntityEvent = (EntityDamageByEntityEvent)damageEvent;
            Entity damager = damageByEntityEvent.getDamager();
            String shooterName = "";
            if (damager instanceof Projectile) {
                Projectile proj = (Projectile)damager;
                ProjectileSource shooter = proj.getShooter();
                if (shooter instanceof LivingEntity) {
                    LivingEntity shooterEntity = (LivingEntity)shooter;
                    shooterName = ", " + shooterEntity.getName();
                } else if (shooter instanceof BlockProjectileSource) {
                    BlockProjectileSource shooterBlock = (BlockProjectileSource)shooter;
                    shooterName = ", " + shooterBlock.getBlock().getType().name();
                }
            }
            reason = damageCause.name() + " (" + damageByEntityEvent.getDamager().getName() + shooterName + ")";
        }
        DetailedReason detailedReason = new DetailedReason(damageCause, reason);
        return detailedReason;
    }

    private static class DetailedReason {
        public final EntityDamageEvent.DamageCause damageCause;
        public final String reason;

        public DetailedReason(EntityDamageEvent.DamageCause damageCause, String reason) {
            this.damageCause = damageCause;
            this.reason = reason;
        }
    }
}

