/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.client;

import baguchan.earthmobsmod.capability.ShadowCapability;
import baguchan.earthmobsmod.client.ClientRegistrar;
import baguchan.earthmobsmod.client.animation.ShakeAnimations;
import baguchi.bagus_lib.client.event.BagusModelEvent;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PigModel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import org.joml.Quaternionfc;

@EventBusSubscriber(modid="earthmobsmod", value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void renderAnimationEvent(BagusModelEvent.PostAnimate event) {
        EntityModel entityModel = event.getModel();
        if (entityModel instanceof PigModel) {
            PigModel model = (PigModel)entityModel;
            ShakeAnimations.shake.bake(event.getModel().root()).applyWalk(event.getEntityRenderState().ageInTicks, 1.0f, 1.0f, ((Float)event.getEntityRenderState().getRenderDataOrDefault(ClientRegistrar.SHAKE, (Object)Float.valueOf(0.0f))).floatValue());
        }
    }

    @SubscribeEvent
    public static void renderEvent(RenderLivingEvent.Post<LivingEntity, LivingEntityRenderState, EntityModel<LivingEntityRenderState>> event) {
        SubmitNodeCollector buffer = event.getSubmitNodeCollector();
        LivingEntityRenderState entity = event.getRenderState();
        LivingEntityRenderer renderer = event.getRenderer();
        PoseStack posestack = event.getPoseStack();
        int light = event.getRenderState().lightCoords;
        float partialtick = event.getPartialTick();
        ShadowCapability shadow = (ShadowCapability)entity.getRenderData(ClientRegistrar.SHADOW);
        if (shadow != null && shadow.getPercentBoost() >= 0.65f) {
            double shadowX = shadow.getPrevShadow().x + (shadow.getShadow().x - shadow.getPrevShadow().x) * (double)partialtick;
            double shadowY = shadow.getPrevShadow().y + (shadow.getShadow().y - shadow.getPrevShadow().y) * (double)partialtick;
            double shadowZ = shadow.getPrevShadow().z + (shadow.getShadow().z - shadow.getPrevShadow().z) * (double)partialtick;
            double shadowX2 = shadow.getPrevShadow2().x + (shadow.getShadow2().x - shadow.getPrevShadow2().x) * (double)partialtick;
            double shadowY2 = shadow.getPrevShadow2().y + (shadow.getShadow2().y - shadow.getPrevShadow2().y) * (double)partialtick;
            double shadowZ2 = shadow.getPrevShadow2().z + (shadow.getShadow2().z - shadow.getPrevShadow2().z) * (double)partialtick;
            double ownerInX = entity.x;
            double ownerInY = entity.y;
            double ownerInZ = entity.z;
            double deltaX = shadowX - ownerInX;
            double deltaY = shadowY - ownerInY;
            double deltaZ = shadowZ - ownerInZ;
            double deltaX2 = shadowX2 - shadowX;
            double deltaY2 = shadowY2 - shadowY;
            double deltaZ2 = shadowZ2 - shadowZ;
            posestack.pushPose();
            posestack.translate(deltaX, deltaY, deltaZ);
            ClientEvents.setupRender(entity, (LivingEntityRenderer<LivingEntity, LivingEntityRenderState, EntityModel<LivingEntityRenderState>>)renderer, posestack, buffer, light);
            posestack.popPose();
            posestack.pushPose();
            posestack.translate(deltaX2, deltaY2, deltaZ2);
            ClientEvents.setupRender(entity, (LivingEntityRenderer<LivingEntity, LivingEntityRenderState, EntityModel<LivingEntityRenderState>>)renderer, posestack, buffer, light);
            posestack.popPose();
        }
    }

    private static void setupRender(LivingEntityRenderState entity, LivingEntityRenderer<LivingEntity, LivingEntityRenderState, EntityModel<LivingEntityRenderState>> renderer, PoseStack posestack, SubmitNodeCollector buffer, int light) {
        EntityModel entityModel;
        Direction direction;
        if (entity.hasPose(Pose.SLEEPING) && (direction = entity.bedOrientation) != null) {
            float f = entity.eyeHeight - 0.1f;
            posestack.translate((float)(-direction.getStepX()) * f, 0.0f, (float)(-direction.getStepZ()) * f);
        }
        float f1 = entity.scale;
        posestack.scale(f1, f1, f1);
        ClientEvents.setupRotations(renderer, entity, posestack, entity.bodyRot, f1);
        posestack.scale(-1.0f, -1.0f, 1.0f);
        posestack.translate(0.0f, -1.501f, 0.0f);
        RenderType rendertype = RenderType.entityTranslucent((ResourceLocation)renderer.getTextureLocation(entity));
        if (rendertype != null && (entityModel = renderer.getModel()) instanceof EntityModel) {
            EntityModel entityModel2 = entityModel;
            int i = LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)entity, (float)0.0f);
            int j = 0x26FFFFFF;
            int k = ARGB.multiply((int)j, (int)-1);
            buffer.submitModel((Model)entityModel2, (Object)entity, posestack, rendertype, light, i, k, null, entity.outlineColor, null);
        }
    }

    private static void setupRotations(LivingEntityRenderer<LivingEntity, LivingEntityRenderState, EntityModel<LivingEntityRenderState>> renderer, LivingEntityRenderState entity, PoseStack poseStack, float bodyRot, float scale) {
        if (!entity.hasPose(Pose.SLEEPING)) {
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f - bodyRot));
        }
        if (entity.isAutoSpinAttack) {
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-90.0f - entity.xRot));
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(entity.ageInTicks * -75.0f));
        } else if (entity.isUpsideDown) {
            poseStack.translate(0.0f, (entity.boundingBoxHeight + 0.1f) / scale, 0.0f);
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
        }
    }

    protected static float getBob(LivingEntityRenderState p_115305_, float p_115306_) {
        return p_115305_.ageInTicks;
    }
}

