/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.client;

import baguchan.earthmobsmod.EarthMobsMod;
import baguchan.earthmobsmod.api.IMoss;
import baguchan.earthmobsmod.api.IMuddyPig;
import baguchan.earthmobsmod.capability.ShadowCapability;
import baguchan.earthmobsmod.client.ModModelLayers;
import baguchan.earthmobsmod.client.model.BoneSpiderModel;
import baguchan.earthmobsmod.client.model.BoulderingDrownedModel;
import baguchan.earthmobsmod.client.model.BoulderingZombieModel;
import baguchan.earthmobsmod.client.model.CluckShroomModel;
import baguchan.earthmobsmod.client.model.FancyChickenModel;
import baguchan.earthmobsmod.client.model.FurnaceGolemModel;
import baguchan.earthmobsmod.client.model.HornedSheepModel;
import baguchan.earthmobsmod.client.model.HyperRabbitModel;
import baguchan.earthmobsmod.client.model.JollyLlamaModel;
import baguchan.earthmobsmod.client.model.JumboRabbitModel;
import baguchan.earthmobsmod.client.model.LobberDrownedModel;
import baguchan.earthmobsmod.client.model.LobberZombieModel;
import baguchan.earthmobsmod.client.model.MagmaCowModel;
import baguchan.earthmobsmod.client.model.MoobloomModel;
import baguchan.earthmobsmod.client.model.MuddyPigModel;
import baguchan.earthmobsmod.client.model.TeaCupPigModel;
import baguchan.earthmobsmod.client.model.VilerWitchModel;
import baguchan.earthmobsmod.client.model.WoolyCowModel;
import baguchan.earthmobsmod.client.render.BoneSpiderRender;
import baguchan.earthmobsmod.client.render.CluckShroomRender;
import baguchan.earthmobsmod.client.render.FancyChickenRenderer;
import baguchan.earthmobsmod.client.render.FurnaceGolemRenderer;
import baguchan.earthmobsmod.client.render.HornedSheepRenderer;
import baguchan.earthmobsmod.client.render.HyperRabbitRenderer;
import baguchan.earthmobsmod.client.render.JollyLlamaRenderer;
import baguchan.earthmobsmod.client.render.JumboRabbitRenderer;
import baguchan.earthmobsmod.client.render.MagmaCowRenderer;
import baguchan.earthmobsmod.client.render.MelonGolemRenderer;
import baguchan.earthmobsmod.client.render.MoobloomRenderer;
import baguchan.earthmobsmod.client.render.MoolipRenderer;
import baguchan.earthmobsmod.client.render.SkeletonWolfRenderer;
import baguchan.earthmobsmod.client.render.StrayBoneSpiderRender;
import baguchan.earthmobsmod.client.render.TeaCupPigRenderer;
import baguchan.earthmobsmod.client.render.TropicalSlimeRenderer;
import baguchan.earthmobsmod.client.render.UmbraCowRenderer;
import baguchan.earthmobsmod.client.render.VilerWitchRenderer;
import baguchan.earthmobsmod.client.render.WitherSkeletonWolfRenderer;
import baguchan.earthmobsmod.client.render.WoolyCowRenderer;
import baguchan.earthmobsmod.client.render.layer.MossSheepLayer;
import baguchan.earthmobsmod.client.render.layer.MuddyPigFlowerLayer;
import baguchan.earthmobsmod.client.render.layer.MuddyPigMudLayer;
import baguchan.earthmobsmod.client.render.zombie.BoulderingDrownedRenderer;
import baguchan.earthmobsmod.client.render.zombie.BoulderingFrozenZombieRenderer;
import baguchan.earthmobsmod.client.render.zombie.BoulderingZombieRenderer;
import baguchan.earthmobsmod.client.render.zombie.LobberDrownedRenderer;
import baguchan.earthmobsmod.client.render.zombie.LobberHuskRenderer;
import baguchan.earthmobsmod.client.render.zombie.LobberZombieRenderer;
import baguchan.earthmobsmod.client.render.zombie.ZombifiedPigRenderer;
import baguchan.earthmobsmod.client.render.zombie.ZombifiedRabbitRenderer;
import baguchan.earthmobsmod.fluidtype.MudFluidType;
import baguchan.earthmobsmod.registry.ModCapability;
import baguchan.earthmobsmod.registry.ModEntities;
import baguchan.earthmobsmod.registry.ModFluidTypes;
import com.google.common.reflect.TypeToken;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import net.minecraft.client.model.CowModel;
import net.minecraft.client.model.PigModel;
import net.minecraft.client.model.ZombieModel;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.PigRenderer;
import net.minecraft.client.renderer.entity.SheepRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.context.ContextKey;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterRenderPipelinesEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.renderstate.RegisterRenderStateModifiersEvent;
import net.neoforged.neoforge.fluids.FluidType;

@EventBusSubscriber(modid="earthmobsmod", value={Dist.CLIENT})
public class ClientRegistrar {
    public static final ContextKey<ShadowCapability> SHADOW = new ContextKey(ResourceLocation.fromNamespaceAndPath((String)"earthmobsmod", (String)"shadow"));
    public static final ContextKey<Float> SHAKE = new ContextKey(ResourceLocation.fromNamespaceAndPath((String)"earthmobsmod", (String)"shake"));
    public static final RenderPipeline ANIMATION_ENTITY = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.ENTITY_SNIPPET}).withLocation(EarthMobsMod.prefix("pipeline/animation_entity")).withShaderDefine("APPLY_TEXTURE_MATRIX").withShaderDefine("ALPHA_CUTOUT", 0.1f).withSampler("Sampler1").withCull(false).build();

    public static void setup(FMLClientSetupEvent event) {
    }

    @SubscribeEvent
    public static void registerEntityRenders(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(ModEntities.CLUCK_SHROOM.get(), CluckShroomRender::new);
        event.registerEntityRenderer(ModEntities.FANCY_CHICKEN.get(), FancyChickenRenderer::new);
        event.registerEntityRenderer(ModEntities.WOOLY_COW.get(), WoolyCowRenderer::new);
        event.registerEntityRenderer(ModEntities.UMBRA_COW.get(), UmbraCowRenderer::new);
        event.registerEntityRenderer(ModEntities.TEACUP_PIG.get(), TeaCupPigRenderer::new);
        event.registerEntityRenderer(ModEntities.HORNED_SHEEP.get(), HornedSheepRenderer::new);
        event.registerEntityRenderer(ModEntities.HYPER_RABBIT.get(), HyperRabbitRenderer::new);
        event.registerEntityRenderer(ModEntities.ZOMBIFIED_RABBIT.get(), ZombifiedRabbitRenderer::new);
        event.registerEntityRenderer(ModEntities.MOOBLOOM.get(), MoobloomRenderer::new);
        event.registerEntityRenderer(ModEntities.MOOLIP.get(), MoolipRenderer::new);
        event.registerEntityRenderer(ModEntities.JUMBO_RABBIT.get(), JumboRabbitRenderer::new);
        event.registerEntityRenderer(ModEntities.ZOMBIFIED_PIG.get(), ZombifiedPigRenderer::new);
        event.registerEntityRenderer(ModEntities.MELON_GOLEM.get(), MelonGolemRenderer::new);
        event.registerEntityRenderer(ModEntities.BONE_SPIDER.get(), BoneSpiderRender::new);
        event.registerEntityRenderer(ModEntities.STRAY_BONE_SPIDER.get(), StrayBoneSpiderRender::new);
        event.registerEntityRenderer(ModEntities.VILER_WITCH.get(), VilerWitchRenderer::new);
        event.registerEntityRenderer(ModEntities.BOULDERING_ZOMBIE.get(), BoulderingZombieRenderer::new);
        event.registerEntityRenderer(ModEntities.LOBBER_ZOMBIE.get(), LobberZombieRenderer::new);
        event.registerEntityRenderer(ModEntities.BOULDERING_DROWNED.get(), BoulderingDrownedRenderer::new);
        event.registerEntityRenderer(ModEntities.LOBBER_DROWNED.get(), LobberDrownedRenderer::new);
        event.registerEntityRenderer(ModEntities.BOULDERING_FROZEN_ZOMBIE.get(), BoulderingFrozenZombieRenderer::new);
        event.registerEntityRenderer(ModEntities.LOBBER_HUSK.get(), LobberHuskRenderer::new);
        event.registerEntityRenderer(ModEntities.TROPICAL_SLIME.get(), TropicalSlimeRenderer::new);
        event.registerEntityRenderer(ModEntities.SKELETON_WOLF.get(), SkeletonWolfRenderer::new);
        event.registerEntityRenderer(ModEntities.WITHER_SKELETON_WOLF.get(), WitherSkeletonWolfRenderer::new);
        event.registerEntityRenderer(ModEntities.MAGMA_COW.get(), MagmaCowRenderer::new);
        event.registerEntityRenderer(ModEntities.FURNACE_GOLEM.get(), FurnaceGolemRenderer::new);
        event.registerEntityRenderer(ModEntities.JOLLY_LLAMA.get(), JollyLlamaRenderer::new);
        event.registerEntityRenderer(ModEntities.SMELLY_EGG.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer(ModEntities.FANCY_EGG.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer(ModEntities.BONE_SHARD.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer(ModEntities.STRAY_BONE_SHARD.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer(ModEntities.MELON_SEED.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer(ModEntities.ZOMBIE_FLESH.get(), ThrownItemRenderer::new);
    }

    @SubscribeEvent
    public static void registerLayerDefinition(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ModModelLayers.CLUCK_SHROOM, CluckShroomModel::createBodyLayer);
        event.registerLayerDefinition(ModModelLayers.FANCY_CHICKEN, FancyChickenModel::createBodyLayer);
        event.registerLayerDefinition(ModModelLayers.CLUCK_SHROOM_BABY, () -> CluckShroomModel.createBodyLayer().apply(CluckShroomModel.BABY_TRANSFORMER));
        event.registerLayerDefinition(ModModelLayers.FANCY_CHICKEN_BABY, () -> FancyChickenModel.createBodyLayer().apply(FancyChickenModel.BABY_TRANSFORMER));
        event.registerLayerDefinition(ModModelLayers.HORNED_SHEEP, HornedSheepModel::createBodyLayer);
        event.registerLayerDefinition(ModModelLayers.HORNED_SHEEP_BABY, () -> HornedSheepModel.createBodyLayer().apply(HornedSheepModel.BABY_TRANSFORMER));
        event.registerLayerDefinition(ModModelLayers.HORNED_SHEEP_UNDERCOAT, HornedSheepModel::createUnderLayer);
        event.registerLayerDefinition(ModModelLayers.HORNED_SHEEP_BABY_UNDERCOAT, () -> HornedSheepModel.createUnderLayer().apply(HornedSheepModel.BABY_TRANSFORMER));
        event.registerLayerDefinition(ModModelLayers.HORNED_SHEEP_FUR, HornedSheepModel::createBodyLayer);
        event.registerLayerDefinition(ModModelLayers.WOOLY_COW, WoolyCowModel::createBodyLayer);
        event.registerLayerDefinition(ModModelLayers.WOOLY_COW_BABY, () -> WoolyCowModel.createBodyLayer().apply(WoolyCowModel.BABY_TRANSFORMER));
        event.registerLayerDefinition(ModModelLayers.HYPER_RABBIT, HyperRabbitModel::createBodyLayer);
        event.registerLayerDefinition(ModModelLayers.JUMBO_RABBIT, JumboRabbitModel::createBodyLayer);
        event.registerLayerDefinition(ModModelLayers.TEACUP_PIG, TeaCupPigModel::createBodyLayer);
        event.registerLayerDefinition(ModModelLayers.MUDDY_PIG, () -> MuddyPigModel.createBodyLayer(CubeDeformation.NONE));
        event.registerLayerDefinition(ModModelLayers.MUDDY_PIG_BABY, () -> MuddyPigModel.createBodyLayer(CubeDeformation.NONE).apply(PigModel.BABY_TRANSFORMER));
        event.registerLayerDefinition(ModModelLayers.BONE_SPIDER, BoneSpiderModel::createBodyLayer);
        event.registerLayerDefinition(ModModelLayers.STRAY_BONE_SPIDER, BoneSpiderModel::createBodyLayer);
        event.registerLayerDefinition(ModModelLayers.VILER_WITCH, VilerWitchModel::createBodyLayer);
        event.registerLayerDefinition(ModModelLayers.MAGMA_COW, MagmaCowModel::createBodyLayer);
        event.registerLayerDefinition(ModModelLayers.MAGMA_COW_BABY, () -> MagmaCowModel.createBodyLayer().apply(CowModel.BABY_TRANSFORMER));
        event.registerLayerDefinition(ModModelLayers.MAGMA_COW_GLOW, MagmaCowModel::createAnimateBodyLayer);
        event.registerLayerDefinition(ModModelLayers.FURNACE_GOLEM, FurnaceGolemModel::createBodyLayer);
        event.registerLayerDefinition(ModModelLayers.JOLLY_LLAMA, JollyLlamaModel::createBodyLayer);
        event.registerLayerDefinition(ModModelLayers.MOOBLOOM, MoobloomModel::createBodyLayer);
        event.registerLayerDefinition(ModModelLayers.MOOBLOOM_BABY, () -> MoobloomModel.createBodyLayer().apply(CowModel.BABY_TRANSFORMER));
        event.registerLayerDefinition(ModModelLayers.SKELETON_WOLF, SkeletonWolfRenderer::createBodyLayer);
        event.registerLayerDefinition(ModModelLayers.SKELETON_WOLF_BABY, () -> SkeletonWolfRenderer.createBodyLayer().apply(CowModel.BABY_TRANSFORMER));
        event.registerLayerDefinition(ModModelLayers.TROPICAL_SLIME, TropicalSlimeRenderer::createInnerBodyLayer);
        event.registerLayerDefinition(ModModelLayers.TROPICAL_SLIME_STABLE, TropicalSlimeRenderer::createStableInnerBodyLayer);
        LayerDefinition layerDefinition = BoulderingZombieModel.createBodyLayer();
        LayerDefinition layerDefinition2 = LobberZombieModel.createBodyLayer();
        LayerDefinition layerDefinition3 = BoulderingDrownedModel.createBodyLayer(CubeDeformation.NONE);
        LayerDefinition layerDefinition4 = LobberDrownedModel.createBodyLayer(CubeDeformation.NONE);
        event.registerLayerDefinition(ModModelLayers.BOULDERING_ZOMBIE, () -> layerDefinition);
        event.registerLayerDefinition(ModModelLayers.LOBBER_ZOMBIE, () -> layerDefinition2);
        event.registerLayerDefinition(ModModelLayers.BOULDERING_DROWNED, () -> layerDefinition3);
        event.registerLayerDefinition(ModModelLayers.LOBBER_DROWNED, () -> layerDefinition4);
        event.registerLayerDefinition(ModModelLayers.BOULDERING_ZOMBIE_BABY, () -> layerDefinition.apply(ZombieModel.BABY_TRANSFORMER));
        event.registerLayerDefinition(ModModelLayers.LOBBER_ZOMBIE_BABY, () -> layerDefinition2.apply(ZombieModel.BABY_TRANSFORMER));
        event.registerLayerDefinition(ModModelLayers.BOULDERING_DROWNED_BABY, () -> layerDefinition3.apply(ZombieModel.BABY_TRANSFORMER));
        event.registerLayerDefinition(ModModelLayers.LOBBER_DROWNED_BABY, () -> layerDefinition4.apply(ZombieModel.BABY_TRANSFORMER));
        event.registerLayerDefinition(ModModelLayers.BOULDERING_DROWNED_OUTER, () -> BoulderingDrownedModel.createBodyLayer(new CubeDeformation(0.25f)));
        event.registerLayerDefinition(ModModelLayers.LOBBER_DROWNED_OUTER, () -> LobberDrownedModel.createBodyLayer(new CubeDeformation(0.25f)));
        event.registerLayerDefinition(ModModelLayers.BOULDERING_DROWNED_OUTER_BABY, () -> BoulderingDrownedModel.createBodyLayer(new CubeDeformation(0.25f)).apply(ZombieModel.BABY_TRANSFORMER));
        event.registerLayerDefinition(ModModelLayers.LOBBER_DROWNED_OUTER_BABY, () -> LobberDrownedModel.createBodyLayer(new CubeDeformation(0.25f)).apply(ZombieModel.BABY_TRANSFORMER));
    }

    @SubscribeEvent
    public static void registerClientExtension(RegisterClientExtensionsEvent event) {
        event.registerFluidType((IClientFluidTypeExtensions)new MudFluidType.MudRender(), new FluidType[]{ModFluidTypes.MUD.get()});
    }

    @SubscribeEvent
    public static void registerClientExtension(RegisterRenderPipelinesEvent event) {
        event.registerPipeline(ANIMATION_ENTITY);
    }

    @SubscribeEvent
    public static void registerEntityRenders(EntityRenderersEvent.AddLayers event) {
        event.getEntityTypes().forEach(entityType -> {
            EntityRenderer patt1$temp;
            PigRenderer r;
            EntityRenderer patt0$temp = event.getRenderer(entityType);
            if (patt0$temp instanceof PigRenderer) {
                r = (PigRenderer)patt0$temp;
                r.addLayer(new MuddyPigMudLayer(r, event.getEntityModels()));
                r.addLayer(new MuddyPigFlowerLayer(r, event.getEntityModels()));
            }
            if ((patt1$temp = event.getRenderer(entityType)) instanceof SheepRenderer) {
                r = (SheepRenderer)patt1$temp;
                r.addLayer(new MossSheepLayer(r, event.getEntityModels()));
            }
        });
    }

    @SubscribeEvent
    public static void registerLayerData(RegisterRenderStateModifiersEvent event) {
        event.registerEntityModifier(PigRenderer.class, (pig, renderState) -> {
            if (pig instanceof IMuddyPig) {
                IMuddyPig muddy = (IMuddyPig)pig;
                renderState.setRenderData(MuddyPigMudLayer.IS_MUD, (Object)muddy.isMuddy());
                renderState.setRenderData(SHAKE, (Object)Float.valueOf(muddy.getBodyRollScale(renderState.partialTick)));
            }
            if (pig instanceof IMuddyPig) {
                IMuddyPig sheared = (IMuddyPig)pig;
                renderState.setRenderData(MuddyPigMudLayer.IS_SHEARED, (Object)sheared.isSheared());
                renderState.setRenderData(MuddyPigFlowerLayer.FLOWER_DYE, (Object)sheared.getColor());
            }
        });
        event.registerEntityModifier(TeaCupPigRenderer.class, (pig, renderState) -> {
            if (pig instanceof IMuddyPig) {
                IMuddyPig muddy = (IMuddyPig)((Object)pig);
                renderState.setRenderData(MuddyPigMudLayer.IS_MUD, muddy.isMuddy());
                renderState.setRenderData(SHAKE, Float.valueOf(muddy.getBodyRollScale(renderState.partialTick)));
            }
            if (pig instanceof IMuddyPig) {
                IMuddyPig sheared = (IMuddyPig)((Object)pig);
                renderState.setRenderData(MuddyPigMudLayer.IS_SHEARED, sheared.isSheared());
                renderState.setRenderData(MuddyPigFlowerLayer.FLOWER_DYE, sheared.getColor());
            }
        });
        event.registerEntityModifier(SheepRenderer.class, (sheep, renderState) -> {
            if (sheep instanceof IMoss) {
                IMoss moss = (IMoss)sheep;
                renderState.setRenderData(MossSheepLayer.MOSS, (Object)moss.isMoss());
            }
        });
        event.registerEntityModifier(TypeToken.of(HyperRabbitRenderer.class), (player, renderState) -> {
            if (player.getData(ModCapability.SHADOW_ATTACH.get()) != null) {
                renderState.setRenderData(SHADOW, (ShadowCapability)player.getData(ModCapability.SHADOW_ATTACH.get()));
            }
        });
    }
}

