/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.client.render.layer;

import baguchan.earthmobsmod.client.ModModelLayers;
import baguchan.earthmobsmod.client.model.MuddyPigModel;
import baguchan.earthmobsmod.client.render.layer.MuddyPigMudLayer;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.ColorLerper;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.DyeColor;

public class MuddyPigFlowerLayer<T extends LivingEntityRenderState, S extends EntityModel<T>>
extends RenderLayer<T, S> {
    private static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"earthmobsmod", (String)"textures/entity/muddypig/pig_muddy_flower.png");
    public static final ContextKey<DyeColor> FLOWER_DYE = new ContextKey(ResourceLocation.fromNamespaceAndPath((String)"earthmobsmod", (String)"flower_dye"));
    private final MuddyPigModel model;
    private final MuddyPigModel babyModel;

    public MuddyPigFlowerLayer(RenderLayerParent<T, S> p_174533_, EntityModelSet p_174534_) {
        super(p_174533_);
        this.model = new MuddyPigModel(p_174534_.bakeLayer(ModModelLayers.MUDDY_PIG));
        this.babyModel = new MuddyPigModel(p_174534_.bakeLayer(ModModelLayers.MUDDY_PIG_BABY));
    }

    public void submit(PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int i, T entityRenderState, float v, float v1) {
        MuddyPigModel pigModel;
        DyeColor dyeColor = (DyeColor)entityRenderState.getRenderDataOrDefault(FLOWER_DYE, (Object)DyeColor.PINK);
        boolean mud = (Boolean)entityRenderState.getRenderDataOrDefault(MuddyPigMudLayer.IS_MUD, (Object)false);
        boolean sheared = (Boolean)entityRenderState.getRenderDataOrDefault(MuddyPigMudLayer.IS_SHEARED, (Object)true);
        MuddyPigModel muddyPigModel = pigModel = ((LivingEntityRenderState)entityRenderState).isBaby ? this.babyModel : this.model;
        if (mud && !sheared) {
            if (((LivingEntityRenderState)entityRenderState).isInvisible) {
                Minecraft minecraft = Minecraft.getInstance();
                boolean flag = entityRenderState.appearsGlowing();
                if (flag) {
                    pigModel.setupAnim((LivingEntityRenderState)entityRenderState);
                    submitNodeCollector.submitModel((Model)pigModel, entityRenderState, poseStack, RenderType.outline((ResourceLocation)LOCATION), i, LivingEntityRenderer.getOverlayCoords(entityRenderState, (float)0.0f), -16777216, (TextureAtlasSprite)null, ((LivingEntityRenderState)entityRenderState).outlineColor, (ModelFeatureRenderer.CrumblingOverlay)null);
                }
            } else {
                MuddyPigFlowerLayer.coloredCutoutModelCopyLayerRender((Model)pigModel, (ResourceLocation)LOCATION, (PoseStack)poseStack, (SubmitNodeCollector)submitNodeCollector, (int)i, entityRenderState, (int)this.getWoolColor(dyeColor), (int)0);
            }
        }
    }

    public int getWoolColor(DyeColor woolColor) {
        return ColorLerper.Type.SHEEP.getColor(woolColor);
    }
}

