/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.data;

import baguchan.earthmobsmod.data.BlockTagGenerator;
import baguchan.earthmobsmod.data.CustomTagGenerator;
import baguchan.earthmobsmod.data.EarthModelData;
import baguchan.earthmobsmod.data.EntityTagGenerator;
import baguchan.earthmobsmod.data.ItemTagGenerator;
import baguchan.earthmobsmod.data.ModLootTableProvider;
import baguchan.earthmobsmod.data.RegistryDataGenerator;
import baguchan.earthmobsmod.data.WorldGenerator;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="earthmobsmod")
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        RegistryDataGenerator datapackProvider = new RegistryDataGenerator(packOutput, event.getLookupProvider());
        CompletableFuture lookupProvider = datapackProvider.getRegistryProvider();
        event.getGenerator().addProvider(true, (DataProvider)new EarthModelData(packOutput));
        BlockTagGenerator blocktags = new BlockTagGenerator(event.getGenerator().getPackOutput(), lookupProvider);
        event.getGenerator().addProvider(true, (DataProvider)blocktags);
        event.getGenerator().addProvider(true, (DataProvider)new ItemTagGenerator(event.getGenerator().getPackOutput(), lookupProvider));
        event.getGenerator().addProvider(true, (DataProvider)new EntityTagGenerator(event.getGenerator().getPackOutput(), lookupProvider));
        event.getGenerator().addProvider(true, (DataProvider)ModLootTableProvider.create(packOutput, lookupProvider));
        event.getGenerator().addProvider(true, (DataProvider)new WorldGenerator(event.getGenerator().getPackOutput(), lookupProvider));
        event.getGenerator().addProvider(true, (DataProvider)new CustomTagGenerator.InstrumentTagGenerator(event.getGenerator().getPackOutput(), lookupProvider));
    }
}

