/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity;

import baguchan.earthmobsmod.registry.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.Nullable;

public class HyperRabbit
extends Rabbit {
    private static final EntityDataAccessor<Boolean> DATA_SPARK = SynchedEntityData.defineId(HyperRabbit.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public HyperRabbit(EntityType<? extends Rabbit> p_29656_, Level p_29657_) {
        super(p_29656_, p_29657_);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.getAvailableGoals().stream().map(it -> it.getGoal()).filter(it -> it instanceof PanicGoal && !(it instanceof RabbitPanicGoal)).findFirst().ifPresent(goal -> {
            this.goalSelector.removeGoal(goal);
            this.goalSelector.addGoal(1, (Goal)new RabbitPanicGoal(this, 2.25));
        });
    }

    public void setTarget(@Nullable LivingEntity p_21544_) {
        super.setTarget(p_21544_);
        if (p_21544_ != null) {
            this.setSpark(true);
        } else {
            this.setSpark(false);
        }
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide()) {
            if (this.getLastDamageSource() != null && !this.isSpark()) {
                this.setSpark(true);
            } else if (this.getLastDamageSource() == null && this.isSpark()) {
                this.setSpark(false);
            }
        }
    }

    public Rabbit getBreedOffspring(ServerLevel p_149035_, AgeableMob p_149036_) {
        return (Rabbit)ModEntities.HYPER_RABBIT.get().create((Level)p_149035_, EntitySpawnReason.BREEDING);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_SPARK, (Object)false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Rabbit.createAttributes().add(Attributes.MAX_HEALTH, 4.0).add(Attributes.MOVEMENT_SPEED, (double)0.32f).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    public static boolean checkHyperSpawnRules(EntityType<HyperRabbit> p_29699_, LevelAccessor p_29700_, EntitySpawnReason p_29701_, BlockPos p_29702_, RandomSource p_29703_) {
        return p_29700_.getBlockState(p_29702_.below()).is(BlockTags.RABBITS_SPAWNABLE_ON) && HyperRabbit.isBrightEnoughToSpawn((BlockAndTintGetter)p_29700_, (BlockPos)p_29702_);
    }

    public boolean isSpark() {
        return (Boolean)this.entityData.get(DATA_SPARK);
    }

    public void setSpark(boolean spark) {
        this.entityData.set(DATA_SPARK, (Object)spark);
    }

    public void push(Entity p_33636_) {
        if (p_33636_ instanceof LivingEntity && !(p_33636_ instanceof HyperRabbit)) {
            this.dealDamage((LivingEntity)p_33636_);
        }
        super.push(p_33636_);
    }

    protected void dealDamage(LivingEntity livingentity) {
        Level level;
        float i;
        float f = i = this.getVariant() == Rabbit.Variant.EVIL ? 1.5f : 1.0f;
        if (this.isAlive() && this.isSpark() && !this.isAlliedTo((Entity)livingentity) && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            float blocked = livingentity.applyItemBlocking(serverLevel, this.damageSources().indirectMagic((Entity)this, (Entity)this), 2.0f * i);
            float f1 = (float)Mth.clamp((double)(livingentity.getDeltaMovement().horizontalDistanceSqr() * (double)1.15f), (double)0.2f, (double)3.0);
            double d1 = this.getX() - livingentity.getX();
            double d2 = this.getZ() - livingentity.getZ();
            if (livingentity.hurtOrSimulate(this.damageSources().indirectMagic((Entity)this, (Entity)this), 2.0f * i)) {
                this.playSound(SoundEvents.PLAYER_ATTACK_KNOCKBACK, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                livingentity.knockback((double)(blocked * f1), d1, d2);
            }
        }
    }

    static class RabbitPanicGoal
    extends PanicGoal {
        private final HyperRabbit rabbit;

        public RabbitPanicGoal(HyperRabbit p_29775_, double p_29776_) {
            super((PathfinderMob)p_29775_, p_29776_);
            this.rabbit = p_29775_;
        }

        public void start() {
            super.start();
        }

        public void stop() {
            super.stop();
        }

        public void tick() {
            super.tick();
            this.rabbit.setSpeedModifier(this.speedModifier);
        }
    }

    static class RabbitAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final HyperRabbit rabbit;

        public RabbitAvoidEntityGoal(HyperRabbit p_29743_, Class<T> p_29744_, float p_29745_, double p_29746_, double p_29747_) {
            super((PathfinderMob)p_29743_, p_29744_, p_29745_, p_29746_, p_29747_);
            this.rabbit = p_29743_;
        }

        public boolean canUse() {
            return this.rabbit.getVariant() != Rabbit.Variant.EVIL && super.canUse();
        }

        public void start() {
            super.start();
            this.rabbit.setSpark(true);
        }

        public void stop() {
            super.stop();
            this.rabbit.setSpark(false);
        }
    }
}

