/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity;

import baguchan.earthmobsmod.registry.ModEntities;
import baguchi.bagus_lib.entity.ISmartJump;
import baguchi.bagus_lib.entity.path.node.SmartNodeEvaluator;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;

public class JumboRabbit
extends Rabbit
implements ISmartJump {
    public JumboRabbit(EntityType<? extends Rabbit> p_29656_, Level p_29657_) {
        super(p_29656_, p_29657_);
    }

    protected PathNavigation createNavigation(Level p_21480_) {
        return new GroundPathNavigation(this, (Mob)this, p_21480_){

            protected PathFinder createPathFinder(int p_219479_) {
                this.nodeEvaluator = new SmartNodeEvaluator();
                this.nodeEvaluator.setCanPassDoors(true);
                this.nodeEvaluator.setCanOpenDoors(false);
                this.nodeEvaluator.setCanFloat(true);
                return new PathFinder(this.nodeEvaluator, p_219479_);
            }
        };
    }

    public Rabbit getBreedOffspring(ServerLevel p_149035_, AgeableMob p_149036_) {
        return (Rabbit)ModEntities.JUMBO_RABBIT.get().create((Level)p_149035_, EntitySpawnReason.BREEDING);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Rabbit.createAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, (double)0.325f).add(Attributes.ATTACK_DAMAGE, 5.0);
    }

    public static boolean checkJumboSpawnRules(EntityType<JumboRabbit> p_29699_, LevelAccessor p_29700_, EntitySpawnReason p_29701_, BlockPos p_29702_, RandomSource p_29703_) {
        return p_29700_.getBlockState(p_29702_.below()).is(BlockTags.RABBITS_SPAWNABLE_ON) && JumboRabbit.isBrightEnoughToSpawn((BlockAndTintGetter)p_29700_, (BlockPos)p_29702_);
    }

    public boolean doHurtTarget(ServerLevel serverLevel, Entity p_29659_) {
        if (this.getVariant() == Rabbit.Variant.EVIL) {
            this.playSound(SoundEvents.RABBIT_ATTACK, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            return p_29659_.hurtServer(serverLevel, this.damageSources().mobAttack((LivingEntity)this), 9.0f);
        }
        return p_29659_.hurtServer(serverLevel, this.damageSources().mobAttack((LivingEntity)this), 5.0f);
    }

    protected float getJumpPower() {
        float f = 0.3f;
        Path path = this.navigation.getPath();
        if (path != null && !path.isDone()) {
            Vec3 vec3 = path.getNextEntityPos((Entity)this);
            if (vec3.y > this.getY() + 0.5) {
                f = 0.5f;
            }
            if (vec3.y > this.getY() + 1.5) {
                f = 0.65f;
            }
        }
        return super.getJumpPower((float)((double)f / this.getAttributeValue(Attributes.JUMP_STRENGTH)));
    }

    public float getSuppportJump() {
        return 2.125f;
    }
}

