/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity;

import baguchan.earthmobsmod.entity.LobberZombie;
import baguchan.earthmobsmod.entity.projectile.ZombieFlesh;
import baguchan.earthmobsmod.registry.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class LobberHusk
extends LobberZombie {
    public LobberHusk(EntityType<? extends LobberHusk> p_34271_, Level p_34272_) {
        super(p_34271_, p_34272_);
        this.xpReward = 5;
    }

    public static boolean checkHuskSpawnRules(EntityType<LobberHusk> husk, ServerLevelAccessor level, EntitySpawnReason spawnType, BlockPos pos, RandomSource random) {
        return LobberHusk.checkMonsterSpawnRules(husk, (ServerLevelAccessor)level, (EntitySpawnReason)spawnType, (BlockPos)pos, (RandomSource)random) && (EntitySpawnReason.isSpawner((EntitySpawnReason)spawnType) || level.canSeeSky(pos));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.MAX_HEALTH, 24.0).add(Attributes.MOVEMENT_SPEED, (double)0.22f).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ARMOR, 2.0).add(Attributes.SPAWN_REINFORCEMENTS_CHANCE);
    }

    protected boolean isSunSensitive() {
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.HUSK_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.HUSK_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.HUSK_DEATH;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.HUSK_STEP;
    }

    public boolean doHurtTarget(ServerLevel serverLevel, Entity entity) {
        boolean flag = super.doHurtTarget(serverLevel, entity);
        if (flag && this.getMainHandItem().isEmpty() && entity instanceof LivingEntity) {
            float f = this.level().getCurrentDifficultyAt(this.blockPosition()).getEffectiveDifficulty();
            ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.HUNGER, 140 * (int)f), (Entity)this);
        }
        return flag;
    }

    @Override
    protected void doUnderWaterConversion() {
        this.convertToZombieType(ModEntities.LOBBER_ZOMBIE.get());
        if (!this.isSilent()) {
            this.level().levelEvent((Entity)((Player)null), 1041, this.blockPosition(), 0);
        }
    }

    @Override
    public void performRangedAttack(LivingEntity p_29912_, float p_29913_) {
        ZombieFlesh zombieFlesh = new ZombieFlesh(this.level(), (LivingEntity)this, Items.ROTTEN_FLESH.getDefaultInstance());
        double d0 = p_29912_.getEyeY() - this.getEyeY();
        double d1 = p_29912_.getX() - this.getX();
        double d3 = p_29912_.getZ() - this.getZ();
        double d4 = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.1f;
        float f = this.level().getCurrentDifficultyAt(this.blockPosition()).getEffectiveDifficulty();
        zombieFlesh.shoot(d1, d0 + d4, d3, 0.8f, 0.1f);
        zombieFlesh.addEffect(new MobEffectInstance(MobEffects.HUNGER, (int)(40.0f + 80.0f * f)));
        this.playSound(SoundEvents.SNOW_GOLEM_SHOOT, 1.0f, 0.4f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)zombieFlesh);
    }
}

