/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity;

import baguchan.earthmobsmod.registry.ModEntities;
import baguchan.earthmobsmod.registry.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BegGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.event.EventHooks;

public class SkeletonWolf
extends Wolf {
    public SkeletonWolf(EntityType<? extends SkeletonWolf> p_30369_, Level p_30370_) {
        super(p_30369_, p_30370_);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(9, (Goal)new BegGoal((Wolf)this, 8.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, (arg_0, arg_1) -> ((SkeletonWolf)this).isAngryAt(arg_0, arg_1)));
        this.targetSelector.addGoal(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Player.class, true, (livingEntity, serverLevel) -> this.isWorstCondition()));
        this.targetSelector.addGoal(6, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Turtle.class, false, Turtle.BABY_ON_LAND_SELECTOR));
        this.targetSelector.addGoal(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Wolf.createAttributes().add(Attributes.MAX_HEALTH, 12.0).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    public void playSound(SoundEvent p_216991_) {
        if (p_216991_ == SoundEvents.WOLF_SHAKE) {
            super.playSound((SoundEvent)ModSounds.SKELETON_WOLF_SHAKE.get());
        } else {
            super.playSound(p_216991_);
        }
    }

    protected SoundEvent getAmbientSound() {
        if (this.isAngry()) {
            return (SoundEvent)ModSounds.SKELETON_WOLF_GROWL.get();
        }
        if (this.random.nextInt(3) != 0) {
            return (SoundEvent)ModSounds.SKELETON_WOLF_AMBIENT.get();
        }
        return this.isTame() && this.getHealth() < 20.0f ? (SoundEvent)ModSounds.SKELETON_WOLF_WHINE.get() : (SoundEvent)ModSounds.SKELETON_WOLF_PANT.get();
    }

    protected SoundEvent getHurtSound(DamageSource p_406243_) {
        return (SoundEvent)ModSounds.SKELETON_WOLF_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.SKELETON_WOLF_DEATH.get();
    }

    protected void playStepSound(BlockPos p_406221_, BlockState p_406277_) {
        this.playSound((SoundEvent)ModSounds.SKELETON_WOLF_STEP.get(), 0.15f, 1.0f);
    }

    protected boolean isWorstCondition() {
        return this.getLightLevelDependentMagicValue() < 0.4f;
    }

    public InteractionResult mobInteract(Player p_406380_, InteractionHand p_406261_) {
        block11: {
            ItemStack itemstack;
            block9: {
                block10: {
                    itemstack = p_406380_.getItemInHand(p_406261_);
                    Item item = itemstack.getItem();
                    if (!this.isTame()) break block9;
                    if ((itemstack.is(Items.BONE) || itemstack.is(Items.ROTTEN_FLESH)) && this.getHealth() < this.getMaxHealth()) {
                        FoodProperties foodproperties = (FoodProperties)itemstack.get(DataComponents.FOOD);
                        float f = foodproperties != null ? (float)foodproperties.nutrition() : 2.0f;
                        this.heal(2.0f * f);
                        this.usePlayerItem(p_406380_, p_406261_, itemstack);
                        this.gameEvent((Holder)GameEvent.EAT);
                        return InteractionResult.SUCCESS;
                    }
                    if (!(item instanceof DyeItem)) break block10;
                    DyeItem dyeitem = (DyeItem)item;
                    if (this.isOwnedBy((LivingEntity)p_406380_)) break block11;
                }
                if (this.isEquippableInSlotEvenSkeleton(itemstack, EquipmentSlot.BODY) && !this.isWearingBodyArmor() && this.isOwnedBy((LivingEntity)p_406380_) && !this.isBaby()) {
                    this.setBodyArmorItem(itemstack.copyWithCount(1));
                    itemstack.consume(1, (LivingEntity)p_406380_);
                    return InteractionResult.SUCCESS;
                }
                if (!itemstack.canPerformAction(ItemAbilities.SHEARS_REMOVE_ARMOR) || !this.isOwnedBy((LivingEntity)p_406380_) || !this.isWearingBodyArmor() || EnchantmentHelper.has((ItemStack)this.getBodyArmorItem(), (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE) && !p_406380_.isCreative()) {
                    if (this.isInSittingPose() && this.isWearingBodyArmor() && this.isOwnedBy((LivingEntity)p_406380_) && this.getBodyArmorItem().isDamaged() && this.getBodyArmorItem().isValidRepairItem(itemstack)) {
                        itemstack.shrink(1);
                        this.playSound(SoundEvents.WOLF_ARMOR_REPAIR);
                        ItemStack itemstack2 = this.getBodyArmorItem();
                        int i = (int)((float)itemstack2.getMaxDamage() * 0.125f);
                        itemstack2.setDamageValue(Math.max(0, itemstack2.getDamageValue() - i));
                        return InteractionResult.SUCCESS;
                    }
                    InteractionResult interactionresult = super.mobInteract(p_406380_, p_406261_);
                    if (!interactionresult.consumesAction() && this.isOwnedBy((LivingEntity)p_406380_)) {
                        this.setOrderedToSit(!this.isOrderedToSit());
                        this.jumping = false;
                        this.navigation.stop();
                        this.setTarget(null);
                        return InteractionResult.SUCCESS.withoutItem();
                    }
                    return interactionresult;
                }
                itemstack.hurtAndBreak(1, (LivingEntity)p_406380_, p_406261_);
                this.playSound(SoundEvents.ARMOR_UNEQUIP_WOLF);
                ItemStack itemstack1 = this.getBodyArmorItem();
                this.setBodyArmorItem(ItemStack.EMPTY);
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverlevel = (ServerLevel)level;
                    this.spawnAtLocation(serverlevel, itemstack1);
                }
                return InteractionResult.SUCCESS;
            }
            if (!this.level().isClientSide() && itemstack.is(Items.BONE) && !this.isAngry()) {
                itemstack.consume(1, (LivingEntity)p_406380_);
                this.tryToTame(p_406380_);
                return InteractionResult.SUCCESS_SERVER;
            }
        }
        return super.mobInteract(p_406380_, p_406261_);
    }

    public boolean isEquippableInSlotEvenSkeleton(ItemStack p_371603_, EquipmentSlot p_371841_) {
        Equippable equippable = (Equippable)p_371603_.get(DataComponents.EQUIPPABLE);
        return equippable == null ? p_371841_ == EquipmentSlot.MAINHAND && this.canUseSlot(EquipmentSlot.MAINHAND) : p_371841_ == equippable.slot() && this.canUseSlot(equippable.slot()) && equippable.canBeEquippedBy(EntityType.WOLF);
    }

    private void tryToTame(Player p_406358_) {
        if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)p_406358_)) {
            this.tame(p_406358_);
            this.navigation.stop();
            this.setTarget(null);
            this.setOrderedToSit(true);
            this.level().broadcastEntityEvent((Entity)this, (byte)7);
        } else {
            this.level().broadcastEntityEvent((Entity)this, (byte)6);
        }
    }

    public SkeletonWolf getBreedOffspring(ServerLevel p_149088_, AgeableMob p_149089_) {
        SkeletonWolf skeletonWolf = (SkeletonWolf)ModEntities.SKELETON_WOLF.get().create((Level)p_149088_, EntitySpawnReason.BREEDING);
        if (this.isTame()) {
            skeletonWolf.setOwnerReference(this.getOwnerReference());
            skeletonWolf.setTame(true, true);
        }
        return skeletonWolf;
    }

    public boolean isFood(ItemStack p_30440_) {
        return false;
    }

    public boolean removeWhenFarAway(double p_27598_) {
        return !this.isTame();
    }

    public static boolean isDarkEnoughToSpawn(ServerLevelAccessor p_33009_, BlockPos p_33010_, RandomSource p_33011_) {
        if (p_33009_.getBrightness(LightLayer.SKY, p_33010_) > p_33011_.nextInt(32)) {
            return false;
        }
        if (p_33009_.getBrightness(LightLayer.BLOCK, p_33010_) > 0) {
            return false;
        }
        int i = p_33009_.getLevel().isThundering() ? p_33009_.getMaxLocalRawBrightness(p_33010_, 10) : p_33009_.getMaxLocalRawBrightness(p_33010_);
        return i <= p_33011_.nextInt(8);
    }

    public float getWalkTargetValue(BlockPos p_27573_, LevelReader p_27574_) {
        return p_27574_.getBlockState(p_27573_.below()).is(Blocks.SOUL_SAND) || p_27574_.getBlockState(p_27573_.below()).is(Blocks.SOUL_SOIL) ? 10.0f : super.getWalkTargetValue(p_27573_, p_27574_);
    }

    public static boolean checkSkeletonWolfSpawnRules(EntityType<? extends SkeletonWolf> p_33018_, ServerLevelAccessor p_33019_, EntitySpawnReason p_33020_, BlockPos p_33021_, RandomSource p_33022_) {
        return (p_33019_.getBlockState(p_33021_.below()).is(Blocks.SOUL_SAND) || p_33019_.getBlockState(p_33021_.below()).is(Blocks.SOUL_SOIL) || p_33019_.getBlockState(p_33021_.below()).is(BlockTags.ANIMALS_SPAWNABLE_ON)) && SkeletonWolf.isDarkEnoughToSpawn(p_33019_, p_33021_, p_33022_) && SkeletonWolf.checkMobSpawnRules(p_33018_, (LevelAccessor)p_33019_, (EntitySpawnReason)p_33020_, (BlockPos)p_33021_, (RandomSource)p_33022_);
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.isTame();
    }
}

