/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity;

import baguchan.earthmobsmod.registry.ModEntities;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public class ZombifiedRabbit
extends Rabbit
implements Enemy {
    private static final EntityDataAccessor<Boolean> DATA_CONVERTING_ID = SynchedEntityData.defineId(ZombifiedRabbit.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int conversionTime;
    @javax.annotation.Nullable
    private UUID conversionStarter;

    public ZombifiedRabbit(EntityType<? extends Rabbit> p_29656_, Level p_29657_) {
        super(p_29656_, p_29657_);
        this.xpReward = 3;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.getAvailableGoals().stream().map(it -> it.getGoal()).filter(it -> it instanceof PanicGoal || it instanceof AvoidEntityGoal).findFirst().ifPresent(goal -> this.goalSelector.removeGoal(goal));
        this.goalSelector.addGoal(4, (Goal)new RabbitAttackGoal(this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CONVERTING_ID, (Object)false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Rabbit.createAttributes().add(Attributes.MAX_HEALTH, 8.0);
    }

    public void addAdditionalSaveData(ValueOutput p_34397_) {
        super.addAdditionalSaveData(p_34397_);
        p_34397_.putInt("ConversionTime", this.isConverting() ? this.conversionTime : -1);
        p_34397_.storeNullable("ConversionPlayer", UUIDUtil.CODEC, (Object)this.conversionStarter);
    }

    public void readAdditionalSaveData(ValueInput p_34387_) {
        super.readAdditionalSaveData(p_34387_);
        int i = p_34387_.getIntOr("ConversionTime", -1);
        if (i != -1) {
            UUID uuid = p_34387_.read("ConversionPlayer", UUIDUtil.CODEC).orElse(null);
            this.startConverting(uuid, i);
        } else {
            this.getEntityData().set(DATA_CONVERTING_ID, (Object)false);
            this.conversionTime = -1;
        }
    }

    public void tick() {
        if (!this.level().isClientSide() && this.isAlive() && this.isConverting()) {
            --this.conversionTime;
            if (this.conversionTime <= 0 && EventHooks.canLivingConvert((LivingEntity)this, (EntityType)EntityType.VILLAGER, timer -> {
                this.conversionTime = timer;
            })) {
                this.finishConversion((ServerLevel)this.level());
            }
        }
        super.tick();
    }

    public InteractionResult mobInteract(Player p_34394_, InteractionHand p_34395_) {
        ItemStack itemstack = p_34394_.getItemInHand(p_34395_);
        if (itemstack.is(Items.GOLDEN_CARROT)) {
            if (this.hasEffect(MobEffects.WEAKNESS)) {
                if (!p_34394_.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
                if (!this.level().isClientSide()) {
                    this.startConverting(p_34394_.getUUID(), this.random.nextInt(2401) + 3600);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.mobInteract(p_34394_, p_34395_);
    }

    public boolean isConverting() {
        return (Boolean)this.getEntityData().get(DATA_CONVERTING_ID);
    }

    private void startConverting(@javax.annotation.Nullable UUID p_34384_, int p_34385_) {
        this.conversionStarter = p_34384_;
        this.conversionTime = p_34385_;
        this.getEntityData().set(DATA_CONVERTING_ID, (Object)true);
        this.removeEffect(MobEffects.WEAKNESS);
        this.addEffect(new MobEffectInstance(MobEffects.STRENGTH, p_34385_, Math.min(this.level().getDifficulty().getId() - 1, 0)));
        this.level().broadcastEntityEvent((Entity)this, (byte)16);
    }

    private void finishConversion(ServerLevel p_34399_) {
        Player player;
        Rabbit rabbit = (Rabbit)this.convertTo(EntityType.RABBIT, ConversionParams.single((Mob)this, (boolean)false, (boolean)false), p_375894_ -> {});
        rabbit.finalizeSpawn((ServerLevelAccessor)p_34399_, p_34399_.getCurrentDifficultyAt(rabbit.blockPosition()), EntitySpawnReason.CONVERSION, (SpawnGroupData)null);
        if (this.conversionStarter == null || (player = p_34399_.getPlayerByUUID(this.conversionStarter)) instanceof ServerPlayer) {
            // empty if block
        }
        rabbit.addEffect(new MobEffectInstance(MobEffects.NAUSEA, 200, 0));
        if (!this.isSilent()) {
            p_34399_.levelEvent((Entity)((Player)null), 1027, this.blockPosition(), 0);
        }
        EventHooks.onLivingConvert((LivingEntity)this, (LivingEntity)rabbit);
    }

    public void aiStep() {
        boolean flag;
        if (this.isAlive() && (flag = this.isSunBurnTick()) && flag) {
            this.igniteForSeconds(8.0f);
        }
        super.aiStep();
    }

    public static boolean isDarkEnoughToSpawn(ServerLevelAccessor p_219010_, BlockPos p_219011_, RandomSource p_219012_) {
        if (p_219010_.getBrightness(LightLayer.SKY, p_219011_) > p_219012_.nextInt(32)) {
            return false;
        }
        DimensionType dimensiontype = p_219010_.dimensionType();
        int i = dimensiontype.monsterSpawnBlockLightLimit();
        if (i < 15 && p_219010_.getBrightness(LightLayer.BLOCK, p_219011_) > i) {
            return false;
        }
        int j = p_219010_.getLevel().isThundering() ? p_219010_.getMaxLocalRawBrightness(p_219011_, 10) : p_219010_.getMaxLocalRawBrightness(p_219011_);
        return j <= dimensiontype.monsterSpawnLightTest().sample(p_219012_);
    }

    public static boolean checkMonsterSpawnRules(EntityType<? extends ZombifiedRabbit> p_219014_, ServerLevelAccessor p_219015_, EntitySpawnReason p_219016_, BlockPos p_219017_, RandomSource p_219018_) {
        return p_219015_.getBlockState(p_219017_.below()).is(BlockTags.RABBITS_SPAWNABLE_ON) && p_219015_.getDifficulty() != Difficulty.PEACEFUL && ZombifiedRabbit.isDarkEnoughToSpawn(p_219015_, p_219017_, p_219018_) && ZombifiedRabbit.checkMobSpawnRules(p_219014_, (LevelAccessor)p_219015_, (EntitySpawnReason)p_219016_, (BlockPos)p_219017_, (RandomSource)p_219018_);
    }

    public boolean removeWhenFarAway(double p_27598_) {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public Rabbit getBreedOffspring(ServerLevel p_149035_, AgeableMob p_149036_) {
        Rabbit rabbit = (Rabbit)ModEntities.ZOMBIFIED_RABBIT.get().create((Level)p_149035_, EntitySpawnReason.BREEDING);
        if (rabbit == null) return rabbit;
        Rabbit.Variant rabbit$variant = ZombifiedRabbit.getRandomRabbitVariant((LevelAccessor)p_149035_, this.blockPosition());
        if (this.random.nextInt(20) == 0) return rabbit;
        if (p_149036_ instanceof Rabbit) {
            Rabbit rabbit1 = (Rabbit)p_149036_;
            if (this.random.nextBoolean()) {
                rabbit$variant = rabbit1.getVariant();
                return rabbit;
            }
        }
        rabbit$variant = this.getVariant();
        return rabbit;
    }

    private static Rabbit.Variant getRandomRabbitVariant(LevelAccessor p_262699_, BlockPos p_262700_) {
        Holder holder = p_262699_.getBiome(p_262700_);
        int i = p_262699_.getRandom().nextInt(100);
        if (holder.is(BiomeTags.SPAWNS_WHITE_RABBITS)) {
            return i < 80 ? Rabbit.Variant.WHITE : Rabbit.Variant.WHITE_SPLOTCHED;
        }
        if (holder.is(BiomeTags.SPAWNS_GOLD_RABBITS)) {
            return Rabbit.Variant.GOLD;
        }
        return i < 50 ? Rabbit.Variant.BROWN : (i < 90 ? Rabbit.Variant.SALT : Rabbit.Variant.BLACK);
    }

    static class RabbitAttackGoal
    extends MeleeAttackGoal {
        public RabbitAttackGoal(Rabbit p_29738_) {
            super((PathfinderMob)p_29738_, 1.4, true);
        }
    }
}

