/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.item;

import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ModEggItem
extends Item {
    private final Supplier<? extends EntityType<? extends ThrowableItemProjectile>> typeSupplier;

    public ModEggItem(Supplier<? extends EntityType<? extends ThrowableItemProjectile>> type, Item.Properties p_41126_) {
        super(p_41126_);
        this.typeSupplier = type;
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        level.playSound((Entity)((Player)null), player.getX(), player.getY(), player.getZ(), SoundEvents.EGG_THROW, SoundSource.PLAYERS, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!level.isClientSide()) {
            ThrowableItemProjectile thrownegg = (ThrowableItemProjectile)this.typeSupplier.get().create(level, EntitySpawnReason.MOB_SUMMONED);
            thrownegg.setPos(player.getX(), player.getEyeY() - (double)0.1f, player.getZ());
            thrownegg.setOwner((Entity)player);
            thrownegg.setItem(itemstack);
            thrownegg.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
            level.addFreshEntity((Entity)thrownegg);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!player.getAbilities().instabuild) {
            itemstack.shrink(1);
        }
        return InteractionResult.SUCCESS;
    }
}

