/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.item;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.level.Level;

public class TropicalBallItem
extends Item {
    public TropicalBallItem(Item.Properties p_41126_) {
        super(p_41126_);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        Player player;
        super.finishUsingItem(stack, level, livingEntity);
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)livingEntity;
            CriteriaTriggers.CONSUME_ITEM.trigger(serverplayer, stack);
            serverplayer.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        if (!(livingEntity instanceof Player) || !(player = (Player)livingEntity).isCreative()) {
            stack.shrink(1);
        }
        livingEntity.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 300));
        livingEntity.setAirSupply(Mth.clamp((int)(livingEntity.getAirSupply() + 600), (int)0, (int)livingEntity.getMaxAirSupply()));
        return stack;
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity livingEntity, InteractionHand p_41401_) {
        if ((livingEntity instanceof WaterAnimal || livingEntity instanceof Axolotl) && !livingEntity.isInWater() && livingEntity.getAirSupply() < livingEntity.getMaxAirSupply()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverplayer = (ServerPlayer)player;
                CriteriaTriggers.CONSUME_ITEM.trigger(serverplayer, stack);
                serverplayer.awardStat(Stats.ITEM_USED.get((Object)this));
            }
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            livingEntity.setAirSupply(Mth.clamp((int)(livingEntity.getAirSupply() + 1200), (int)0, (int)livingEntity.getMaxAirSupply()));
        }
        return super.interactLivingEntity(stack, player, livingEntity, p_41401_);
    }

    public ItemUseAnimation getUseAnimation(ItemStack p_41358_) {
        return ItemUseAnimation.DRINK;
    }
}

