/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.mixin;

import baguchan.earthmobsmod.api.IMoss;
import baguchan.earthmobsmod.message.MossMessage;
import baguchi.bagus_lib.api.IBaguPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Sheep.class})
public abstract class SheepMixin
extends Animal
implements IMoss,
IBaguPacket {
    private boolean moss;

    protected SheepMixin(EntityType<? extends Animal> p_27557_, Level p_27558_) {
        super(p_27557_, p_27558_);
    }

    @Override
    public boolean isMoss() {
        return this.moss;
    }

    @Override
    public void setMoss(boolean moss) {
        this.moss = moss;
        this.resync((Entity)this);
    }

    public void resync(Entity entity) {
        if (!this.level().isClientSide()) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)new MossMessage(this.getId(), this.moss), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData(ValueOutput p_422587_, CallbackInfo ci) {
        p_422587_.putBoolean("Moss", this.isMoss());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData(ValueInput p_421604_, CallbackInfo ci) {
        this.setMoss(p_421604_.getBooleanOr("Moss", false));
    }

    @Inject(method={"shear"}, at={@At(value="RETURN")})
    public void onSheared(ServerLevel p_376571_, SoundSource p_29819_, ItemStack p_372915_, CallbackInfo ci) {
        ItemEntity itementity;
        if (this.moss && (itementity = this.spawnAtLocation(p_376571_, Items.MOSS_BLOCK.getDefaultInstance(), 1.0f)) != null) {
            itementity.setDeltaMovement(itementity.getDeltaMovement().add((double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f), (double)(this.random.nextFloat() * 0.05f), (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f)));
        }
    }
}

