/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.world.biome;

import baguchan.earthmobsmod.EarthMobsConfig;
import baguchan.earthmobsmod.registry.ModBiomeModifiers;
import baguchan.earthmobsmod.registry.ModEntities;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;

public class EarthBiomeModifier
implements BiomeModifier {
    public static final EarthBiomeModifier INSTANCE = new EarthBiomeModifier();

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD) {
            if (biome.is(BiomeTags.IS_OVERWORLD) && !biome.is(Biomes.DEEP_DARK) && !biome.is(Tags.Biomes.IS_VOID)) {
                if ((Integer)EarthMobsConfig.COMMON.cluckshroomSpawnRate.get() > 0 && biome.is(Biomes.MUSHROOM_FIELDS)) {
                    builder.getMobSpawnSettings().addSpawn(MobCategory.CREATURE, ((Integer)EarthMobsConfig.COMMON.cluckshroomSpawnRate.get()).intValue(), new MobSpawnSettings.SpawnerData(ModEntities.CLUCK_SHROOM.get(), 3, 4));
                }
                if ((Integer)EarthMobsConfig.COMMON.fancyChickenSpawnRate.get() > 0 && biome.is(Tags.Biomes.IS_PLAINS) && !biome.is(Tags.Biomes.IS_COLD) && !biome.is(Tags.Biomes.IS_HOT)) {
                    builder.getMobSpawnSettings().addSpawn(MobCategory.CREATURE, ((Integer)EarthMobsConfig.COMMON.fancyChickenSpawnRate.get()).intValue(), new MobSpawnSettings.SpawnerData(ModEntities.FANCY_CHICKEN.get(), 3, 4));
                }
                if ((Integer)EarthMobsConfig.COMMON.woolyCowSpawnRate.get() > 0 && biome.is(Tags.Biomes.IS_COLD)) {
                    builder.getMobSpawnSettings().addSpawn(MobCategory.CREATURE, ((Integer)EarthMobsConfig.COMMON.woolyCowSpawnRate.get()).intValue(), new MobSpawnSettings.SpawnerData(ModEntities.WOOLY_COW.get(), 3, 4));
                }
                if ((Integer)EarthMobsConfig.COMMON.jollyLLamaSpawnRate.get() > 0 && biome.is(BiomeTags.SPAWNS_COLD_VARIANT_FARM_ANIMALS) && (biome.is(Tags.Biomes.IS_MOUNTAIN_PEAK) || biome.is(Tags.Biomes.IS_MOUNTAIN_SLOPE))) {
                    builder.getMobSpawnSettings().addSpawn(MobCategory.CREATURE, ((Integer)EarthMobsConfig.COMMON.jollyLLamaSpawnRate.get()).intValue(), new MobSpawnSettings.SpawnerData(ModEntities.JOLLY_LLAMA.get(), 3, 4));
                }
                if ((Integer)EarthMobsConfig.COMMON.umbraCowSpawnRate.get() > 0 && biome.is(Tags.Biomes.IS_COLD)) {
                    builder.getMobSpawnSettings().addSpawn(MobCategory.CREATURE, ((Integer)EarthMobsConfig.COMMON.umbraCowSpawnRate.get()).intValue(), new MobSpawnSettings.SpawnerData(ModEntities.UMBRA_COW.get(), 3, 4));
                }
                if ((Integer)EarthMobsConfig.COMMON.teacupPigSpawnRate.get() > 0 && biome.is(Tags.Biomes.IS_PLAINS)) {
                    builder.getMobSpawnSettings().addSpawn(MobCategory.CREATURE, ((Integer)EarthMobsConfig.COMMON.teacupPigSpawnRate.get()).intValue(), new MobSpawnSettings.SpawnerData(ModEntities.TEACUP_PIG.get(), 3, 4));
                }
                if ((Integer)EarthMobsConfig.COMMON.hornedSheepSpawnRate.get() > 0 && biome.is(Tags.Biomes.IS_MOUNTAIN)) {
                    builder.getMobSpawnSettings().addSpawn(MobCategory.CREATURE, ((Integer)EarthMobsConfig.COMMON.hornedSheepSpawnRate.get()).intValue(), new MobSpawnSettings.SpawnerData(ModEntities.HORNED_SHEEP.get(), 3, 6));
                }
                if ((Integer)EarthMobsConfig.COMMON.hyperRabbitSpawnRate.get() > 0 && (biome.is(Tags.Biomes.IS_PLAINS) || biome.is(BiomeTags.IS_FOREST))) {
                    builder.getMobSpawnSettings().addSpawn(MobCategory.CREATURE, ((Integer)EarthMobsConfig.COMMON.hyperRabbitSpawnRate.get()).intValue(), new MobSpawnSettings.SpawnerData(ModEntities.HYPER_RABBIT.get(), 3, 4));
                }
                if (!biome.is(Biomes.MUSHROOM_FIELDS)) {
                    if ((Integer)EarthMobsConfig.COMMON.boneSpiderSpawnRate.get() > 0 && biome.is(Tags.Biomes.IS_SPOOKY)) {
                        builder.getMobSpawnSettings().addSpawn(MobCategory.MONSTER, ((Integer)EarthMobsConfig.COMMON.boneSpiderSpawnRate.get()).intValue(), new MobSpawnSettings.SpawnerData(ModEntities.BONE_SPIDER.get(), 1, 1));
                    }
                    if ((Integer)EarthMobsConfig.COMMON.strayBoneSpiderSpawnRate.get() > 0 && biome.is(Tags.Biomes.IS_COLD_OVERWORLD)) {
                        builder.getMobSpawnSettings().addSpawn(MobCategory.MONSTER, ((Integer)EarthMobsConfig.COMMON.strayBoneSpiderSpawnRate.get()).intValue(), new MobSpawnSettings.SpawnerData(ModEntities.STRAY_BONE_SPIDER.get(), 1, 1));
                    }
                    if ((Integer)EarthMobsConfig.COMMON.lobberZombieSpawnRate.get() > 0) {
                        if (biome.is(BiomeTags.IS_FOREST)) {
                            builder.getMobSpawnSettings().addSpawn(MobCategory.MONSTER, ((Integer)EarthMobsConfig.COMMON.lobberZombieSpawnRate.get()).intValue(), new MobSpawnSettings.SpawnerData(ModEntities.LOBBER_ZOMBIE.get(), 3, 4));
                        }
                        if (biome.is(Tags.Biomes.IS_DESERT)) {
                            builder.getMobSpawnSettings().addSpawn(MobCategory.MONSTER, ((Integer)EarthMobsConfig.COMMON.lobberZombieSpawnRate.get()).intValue(), new MobSpawnSettings.SpawnerData(ModEntities.LOBBER_HUSK.get(), 3, 4));
                        }
                    }
                    if ((Integer)EarthMobsConfig.COMMON.boulderingZombieSpawnRate.get() > 0) {
                        if (biome.is(Tags.Biomes.IS_COLD) && biome.is(Tags.Biomes.IS_MOUNTAIN)) {
                            builder.getMobSpawnSettings().addSpawn(MobCategory.MONSTER, ((Integer)EarthMobsConfig.COMMON.boulderingZombieSpawnRate.get()).intValue(), new MobSpawnSettings.SpawnerData(ModEntities.BOULDERING_FROZEN_ZOMBIE.get(), 3, 4));
                        } else {
                            builder.getMobSpawnSettings().addSpawn(MobCategory.MONSTER, ((Integer)EarthMobsConfig.COMMON.boulderingZombieSpawnRate.get()).intValue(), new MobSpawnSettings.SpawnerData(ModEntities.BOULDERING_ZOMBIE.get(), 3, 4));
                        }
                    }
                    if ((Integer)EarthMobsConfig.COMMON.zombifiedRabbitSpawnRate.get() > 0) {
                        builder.getMobSpawnSettings().addSpawn(MobCategory.MONSTER, ((Integer)EarthMobsConfig.COMMON.zombifiedRabbitSpawnRate.get()).intValue(), new MobSpawnSettings.SpawnerData(ModEntities.ZOMBIFIED_RABBIT.get(), 3, 4));
                    }
                    if ((Integer)EarthMobsConfig.COMMON.boulderingZombieSpawnRate.get() > 0 && biome.is(Biomes.DRIPSTONE_CAVES)) {
                        builder.getMobSpawnSettings().addSpawn(MobCategory.MONSTER, ((Integer)EarthMobsConfig.COMMON.boulderingZombieSpawnRate.get()).intValue(), new MobSpawnSettings.SpawnerData(ModEntities.BOULDERING_FROZEN_ZOMBIE.get(), 3, 4));
                    }
                    if ((biome.is(BiomeTags.IS_DEEP_OCEAN) || biome.is(BiomeTags.IS_OCEAN)) && (Integer)EarthMobsConfig.COMMON.tropicalSlimeSpawnRate.get() > 0) {
                        builder.getMobSpawnSettings().addSpawn(MobCategory.MONSTER, ((Integer)EarthMobsConfig.COMMON.tropicalSlimeSpawnRate.get()).intValue(), new MobSpawnSettings.SpawnerData(ModEntities.TROPICAL_SLIME.get(), 3, 4));
                    }
                }
                if (biome.is(Biomes.FLOWER_FOREST)) {
                    if ((Integer)EarthMobsConfig.COMMON.moobloomSpawnRate.get() > 0) {
                        builder.getMobSpawnSettings().addSpawn(MobCategory.CREATURE, ((Integer)EarthMobsConfig.COMMON.moobloomSpawnRate.get()).intValue(), new MobSpawnSettings.SpawnerData(ModEntities.MOOBLOOM.get(), 3, 4));
                    }
                    if ((Integer)EarthMobsConfig.COMMON.moolipSpawnRate.get() > 0) {
                        builder.getMobSpawnSettings().addSpawn(MobCategory.CREATURE, ((Integer)EarthMobsConfig.COMMON.moolipSpawnRate.get()).intValue(), new MobSpawnSettings.SpawnerData(ModEntities.MOOLIP.get(), 3, 4));
                    }
                }
                if (biome.is(BiomeTags.IS_FOREST) && (Integer)EarthMobsConfig.COMMON.skeletonWolfOverWorldSpawnRate.get() > 0) {
                    builder.getMobSpawnSettings().addSpawn(MobCategory.MONSTER, ((Integer)EarthMobsConfig.COMMON.skeletonWolfOverWorldSpawnRate.get()).intValue(), new MobSpawnSettings.SpawnerData(ModEntities.SKELETON_WOLF.get(), 3, 4));
                }
                if ((Integer)EarthMobsConfig.COMMON.jumboRabbitSpawnRate.get() > 0 && (biome.is(Tags.Biomes.IS_PLAINS) || biome.is(BiomeTags.IS_FOREST) || biome.is(Tags.Biomes.IS_SANDY))) {
                    builder.getMobSpawnSettings().addSpawn(MobCategory.CREATURE, ((Integer)EarthMobsConfig.COMMON.jumboRabbitSpawnRate.get()).intValue(), new MobSpawnSettings.SpawnerData(ModEntities.JUMBO_RABBIT.get(), 3, 4));
                }
            }
            if ((Integer)EarthMobsConfig.COMMON.skeletonWolfNetherSpawnRate.get() > 0 && biome.is(Biomes.SOUL_SAND_VALLEY)) {
                builder.getMobSpawnSettings().addSpawn(MobCategory.MONSTER, ((Integer)EarthMobsConfig.COMMON.skeletonWolfNetherSpawnRate.get()).intValue(), new MobSpawnSettings.SpawnerData(ModEntities.SKELETON_WOLF.get(), 2, 3));
                builder.getMobSpawnSettings().addMobCharge(ModEntities.SKELETON_WOLF.get(), 0.7, (double)0.15f);
            }
            if ((Integer)EarthMobsConfig.COMMON.magmaCowSpawnRate.get() > 0 && biome.is(Biomes.BASALT_DELTAS)) {
                builder.getMobSpawnSettings().addSpawn(MobCategory.CREATURE, ((Integer)EarthMobsConfig.COMMON.magmaCowSpawnRate.get()).intValue(), new MobSpawnSettings.SpawnerData(ModEntities.MAGMA_COW.get(), 4, 6));
            }
            if ((Integer)EarthMobsConfig.COMMON.witherSkeletonWolfNetherSpawnRate.get() > 0 && biome.is(Biomes.SOUL_SAND_VALLEY)) {
                builder.getMobSpawnSettings().addSpawn(MobCategory.MONSTER, ((Integer)EarthMobsConfig.COMMON.witherSkeletonWolfNetherSpawnRate.get()).intValue(), new MobSpawnSettings.SpawnerData(ModEntities.WITHER_SKELETON_WOLF.get(), 2, 3));
                builder.getMobSpawnSettings().addMobCharge(ModEntities.WITHER_SKELETON_WOLF.get(), 0.7, (double)0.15f);
            }
        }
    }

    public MapCodec<? extends BiomeModifier> codec() {
        return ModBiomeModifiers.EARTH_ENTITY_MODIFIER_TYPE.get();
    }
}

