/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod;

import baguchan.earthmobsmod.api.IMoss;
import baguchan.earthmobsmod.api.IMuddyPig;
import baguchan.earthmobsmod.block.CarvedMelonBlock;
import baguchan.earthmobsmod.capability.ShadowCapability;
import baguchan.earthmobsmod.entity.FurnaceGolem;
import baguchan.earthmobsmod.entity.TeaCupPig;
import baguchan.earthmobsmod.entity.ZombifiedPig;
import baguchan.earthmobsmod.entity.ZombifiedRabbit;
import baguchan.earthmobsmod.registry.ModBlocks;
import baguchan.earthmobsmod.registry.ModCapability;
import baguchan.earthmobsmod.registry.ModDamageSource;
import baguchan.earthmobsmod.registry.ModEntities;
import baguchan.earthmobsmod.util.DyeUtil;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.TriState;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityStruckByLightningEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="earthmobsmod")
public class CommonEvents {
    @SubscribeEvent
    public static void addSpawn(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Villager) {
            Villager abstractVillager = (Villager)entity;
            abstractVillager.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)abstractVillager, ZombifiedRabbit.class, 10.0f, (double)0.65f, (double)0.7f));
        }
        if ((entity = event.getEntity()) instanceof WanderingTrader) {
            WanderingTrader wanderingTraderEntity = (WanderingTrader)entity;
            wanderingTraderEntity.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)wanderingTraderEntity, ZombifiedRabbit.class, 10.0f, (double)0.65f, (double)0.7f));
        }
    }

    @SubscribeEvent
    public static void initSpawn(FinalizeSpawnEvent event) {
        Mob entity = event.getEntity();
        ServerLevelAccessor serverLevelAccessor = event.getLevel();
        if (entity instanceof IMoss) {
            IMoss moss = (IMoss)entity;
            if (serverLevelAccessor.getBiome(BlockPos.containing((double)event.getX(), (double)event.getY(), (double)event.getZ())).is(Tags.Biomes.IS_SWAMP)) {
                moss.setMoss(true);
            }
        }
        if (entity instanceof IMuddyPig) {
            IMuddyPig muddy = (IMuddyPig)entity;
            if (serverLevelAccessor.getBiome(BlockPos.containing((double)event.getX(), (double)event.getY(), (double)event.getZ())).is(Tags.Biomes.IS_SWAMP)) {
                muddy.setMuddy(true);
                muddy.setColor(DyeColor.byId((int)DyeUtil.getRandomColor(serverLevelAccessor.getRandom()).getId()));
            }
        }
    }

    @SubscribeEvent
    public static void onToolUsing(BlockEvent.BlockToolModificationEvent event) {
        Direction direction;
        if (!event.isSimulated() && event.getItemAbility() == ItemAbilities.SHEARS_CARVE && event.getState().getBlock() == Blocks.MELON && (direction = event.getContext().getClickedFace()) != Direction.DOWN && direction != Direction.UP) {
            event.setFinalState((BlockState)((Block)ModBlocks.CARVED_MELON.get()).defaultBlockState().setValue(CarvedMelonBlock.FACING, (Comparable)direction));
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockState state;
        SpawnEggItem spawnEggItem;
        Player player;
        ItemStack stack;
        Item item;
        BlockPattern.BlockPatternMatch blockpattern$blockpatternmatch1;
        Direction direction;
        InteractionHand hand = event.getHand();
        ItemStack itemStack = event.getEntity().getItemInHand(hand);
        BlockPos pos = event.getPos();
        Level level = event.getEntity().level();
        if (itemStack.getItem() instanceof ShearsItem && event.getEntity().level().getBlockState(pos).getBlock() == Blocks.MELON && (direction = event.getHitVec().getDirection()) != Direction.DOWN && direction != Direction.UP) {
            itemStack.hurtAndBreak(1, (LivingEntity)event.getEntity(), hand);
            level.playSound(null, pos, SoundEvents.PUMPKIN_CARVE, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.setBlock(pos, (BlockState)((Block)ModBlocks.CARVED_MELON.get()).defaultBlockState().setValue(CarvedMelonBlock.FACING, (Comparable)direction), 2);
            event.setUseItem(TriState.TRUE);
        }
        if (itemStack.is(Blocks.CARVED_PUMPKIN.asItem()) && (blockpattern$blockpatternmatch1 = CommonEvents.getOrCreateFurnaceGolemBase().find((LevelReader)level, pos.relative(event.getFace()))) != null) {
            FurnaceGolem irongolem = (FurnaceGolem)ModEntities.FURNACE_GOLEM.get().create(level, EntitySpawnReason.MOB_SUMMONED);
            if (irongolem != null) {
                CommonEvents.spawnGolemInWorld(level, blockpattern$blockpatternmatch1, (Entity)irongolem, blockpattern$blockpatternmatch1.getBlock(1, 2, 0).getPos());
            }
            if (!event.getEntity().isCreative()) {
                itemStack.shrink(1);
            }
            event.getEntity().swing(hand);
            event.setCanceled(true);
        }
        if ((item = (stack = (player = event.getEntity()).getItemInHand(event.getHand())).getItem()) instanceof SpawnEggItem && (spawnEggItem = (SpawnEggItem)item).getType(stack) == ModEntities.TEACUP_PIG.get() && (state = level.getBlockState(pos)).is(Blocks.FLOWER_POT)) {
            event.setCanceled(true);
            level.playSound(null, pos, SoundEvents.BOOK_PUT, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                TeaCupPig teaCupPig = (TeaCupPig)ModEntities.TEACUP_PIG.get().spawn(serverLevel, stack, (LivingEntity)player, pos.below(), EntitySpawnReason.SPAWN_ITEM_USE, true, false);
                if (teaCupPig != null) {
                    stack.consume(1, (LivingEntity)player);
                    teaCupPig.setYRot(event.getEntity().getNearestViewDirection().getOpposite().toYRot());
                    teaCupPig.yRotO = event.getEntity().getNearestViewDirection().getOpposite().toYRot();
                    teaCupPig.setOldPosAndRot();
                    serverLevel.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, pos);
                    teaCupPig.setOnPot(true);
                }
            }
        }
    }

    public static void clearPatternBlocks(Level p_249604_, BlockPattern.BlockPatternMatch p_251190_) {
        for (int i = 0; i < p_251190_.getWidth(); ++i) {
            for (int j = 0; j < p_251190_.getHeight(); ++j) {
                BlockInWorld blockinworld = p_251190_.getBlock(i, j, 0);
                p_249604_.setBlock(blockinworld.getPos(), Blocks.AIR.defaultBlockState(), 2);
                p_249604_.levelEvent(2001, blockinworld.getPos(), Block.getId((BlockState)blockinworld.getState()));
            }
        }
    }

    public static void updatePatternBlocks(Level p_248711_, BlockPattern.BlockPatternMatch p_251935_) {
        for (int i = 0; i < p_251935_.getWidth(); ++i) {
            for (int j = 0; j < p_251935_.getHeight(); ++j) {
                BlockInWorld blockinworld = p_251935_.getBlock(i, j, 0);
                p_248711_.updateNeighborsAt(blockinworld.getPos(), Blocks.AIR);
            }
        }
    }

    private static BlockPattern getOrCreateFurnaceGolemBase() {
        return BlockPatternBuilder.start().aisle(new String[]{"   ", "#F#", " # "}).where('#', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)Blocks.IRON_BLOCK))).where('F', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)Blocks.BLAST_FURNACE))).build();
    }

    @SubscribeEvent
    public static void onUpdate(EntityTickEvent.Pre event) {
        Entity entity;
        ShadowCapability shadowCapability = (ShadowCapability)event.getEntity().getData(ModCapability.SHADOW_ATTACH);
        if (shadowCapability != null && (entity = event.getEntity()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            shadowCapability.tick(livingEntity);
        }
    }

    @SubscribeEvent
    public static void onLightning(EntityStruckByLightningEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Pig) {
            Pig pig = (Pig)entity;
            if (event.getEntity().getType() != ModEntities.ZOMBIFIED_PIG.get()) {
                ZombifiedPig zombifiedpig = (ZombifiedPig)ModEntities.ZOMBIFIED_PIG.get().create(event.getEntity().level(), EntitySpawnReason.CONVERSION);
                zombifiedpig.snapTo(pig.getX(), pig.getY(), pig.getZ(), pig.getYRot(), pig.getXRot());
                zombifiedpig.setNoAi(pig.isNoAi());
                zombifiedpig.setBaby(pig.isBaby());
                if (pig.hasCustomName()) {
                    zombifiedpig.setCustomName(pig.getCustomName());
                    zombifiedpig.setCustomNameVisible(pig.isCustomNameVisible());
                }
                zombifiedpig.setPersistenceRequired();
                EventHooks.onLivingConvert((LivingEntity)pig, (LivingEntity)zombifiedpig);
                event.getEntity().level().addFreshEntity((Entity)zombifiedpig);
                pig.discard();
                event.setCanceled(true);
            } else {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onKill(LivingDeathEvent event) {
        Object serverLevel;
        Rabbit rabbit;
        LivingEntity living = event.getEntity();
        Level level = event.getEntity().level();
        if ((event.getSource().getDirectEntity() instanceof Zombie || event.getSource().getDirectEntity() instanceof ZombifiedRabbit) && living instanceof Rabbit) {
            rabbit = (Rabbit)living;
            if (!(living instanceof Enemy) && level instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                ZombifiedRabbit zombierabbit = (ZombifiedRabbit)rabbit.convertTo(ModEntities.ZOMBIFIED_RABBIT.get(), ConversionParams.single((Mob)rabbit, (boolean)false, (boolean)true), p_390220_ -> {});
                if (zombierabbit != null) {
                    zombierabbit.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(zombierabbit.blockPosition()), EntitySpawnReason.CONVERSION, null);
                    EventHooks.onLivingConvert((LivingEntity)rabbit, (LivingEntity)zombierabbit);
                    if (!rabbit.isSilent()) {
                        level.levelEvent(null, 1026, rabbit.blockPosition(), 0);
                    }
                }
            }
        }
        if (event.getSource().is(ModDamageSource.ZOMBIFIED)) {
            if (living instanceof Rabbit) {
                rabbit = (Rabbit)living;
                if (!(living instanceof Enemy)) {
                    serverLevel = (ZombifiedRabbit)rabbit.convertTo(ModEntities.ZOMBIFIED_RABBIT.get(), ConversionParams.single((Mob)rabbit, (boolean)true, (boolean)true), rabbit1 -> {
                        if (rabbit1 != null && !rabbit1.isSilent()) {
                            level.levelEvent(null, 1026, rabbit1.blockPosition(), 0);
                        }
                    });
                }
            }
            if (living instanceof Villager) {
                Villager villager = (Villager)living;
                if (!(living instanceof Enemy) && level instanceof ServerLevel) {
                    serverLevel = (ServerLevel)level;
                    ZombieVillager zombieVillager = (ZombieVillager)villager.convertTo(EntityType.ZOMBIE_VILLAGER, ConversionParams.single((Mob)villager, (boolean)true, (boolean)true), arg_0 -> CommonEvents.lambda$onKill$2((ServerLevel)serverLevel, level, villager, arg_0));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onHurtCheck(EntityInvulnerabilityCheckEvent event) {
        ShadowCapability shadowCapability = (ShadowCapability)event.getEntity().getData(ModCapability.SHADOW_ATTACH);
        if (shadowCapability != null && !event.getSource().is(DamageTypeTags.BYPASSES_ARMOR) && !event.getSource().is(DamageTypeTags.IS_EXPLOSION) && !event.getSource().is(DamageTypeTags.IS_FIRE) && shadowCapability.getPercentBoost() > 0.9f) {
            event.setInvulnerable(true);
        }
    }

    @SubscribeEvent
    public static void onHurt(LivingIncomingDamageEvent event) {
        ShadowCapability shadowCapability = (ShadowCapability)event.getEntity().getData(ModCapability.SHADOW_ATTACH);
        if (shadowCapability != null && shadowCapability.getPercentBoost() >= 0.5f && !event.getSource().is(DamageTypeTags.BYPASSES_ARMOR) && !event.getSource().is(DamageTypeTags.IS_EXPLOSION) && !event.getSource().is(DamageTypeTags.IS_FIRE)) {
            event.setAmount(event.getAmount() * (1.0f - shadowCapability.getPercentBoost()));
            if (shadowCapability.getPercentBoost() > 0.9f) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingKnockback(LivingKnockBackEvent event) {
        ShadowCapability shadowCapability = (ShadowCapability)event.getEntity().getData(ModCapability.SHADOW_ATTACH);
        if (shadowCapability != null && shadowCapability.getPercentBoost() >= 0.5f) {
            event.setCanceled(true);
        }
    }

    private static void spawnGolemInWorld(Level level, BlockPattern.BlockPatternMatch blockPatternMatch, Entity summoner, BlockPos pos) {
        CommonEvents.clearPatternBlocks(level, blockPatternMatch);
        summoner.snapTo((double)pos.getX() + 0.5, (double)pos.getY() + 0.05, (double)pos.getZ() + 0.5, 0.0f, 0.0f);
        level.addFreshEntity(summoner);
        for (ServerPlayer serverplayer : level.getEntitiesOfClass(ServerPlayer.class, summoner.getBoundingBox().inflate(5.0))) {
            CriteriaTriggers.SUMMONED_ENTITY.trigger(serverplayer, summoner);
        }
        CommonEvents.updatePatternBlocks(level, blockPatternMatch);
    }

    private static /* synthetic */ void lambda$onKill$2(ServerLevel serverLevel, Level level, Villager villager, ZombieVillager p_370686_) {
        p_370686_.finalizeSpawn((ServerLevelAccessor)serverLevel, level.getCurrentDifficultyAt(p_370686_.blockPosition()), EntitySpawnReason.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, true));
        p_370686_.setVillagerData(villager.getVillagerData());
        p_370686_.setGossips(villager.getGossips());
        p_370686_.setTradeOffers(villager.getOffers());
        p_370686_.setVillagerXp(villager.getVillagerXp());
        EventHooks.onLivingConvert((LivingEntity)p_370686_, (LivingEntity)p_370686_);
        if (!p_370686_.isSilent()) {
            level.levelEvent(null, 1026, p_370686_.blockPosition(), 0);
        }
    }
}

