/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.capability;

import baguchan.earthmobsmod.entity.HyperRabbit;
import baguchan.earthmobsmod.registry.ModEffects;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;

public class ShadowCapability
implements IAttachmentSerializer<ShadowCapability> {
    private static final ResourceLocation SPEED_MODIFIER_BOOST_UUID = ResourceLocation.fromNamespaceAndPath((String)"earthmobsmod", (String)"shadow_speed");
    public Vec3 prevShadow = Vec3.ZERO;
    public Vec3 shadow = Vec3.ZERO;
    public Vec3 prevShadow2 = Vec3.ZERO;
    public Vec3 shadow2 = Vec3.ZERO;
    public Vec2 shadowRot = Vec2.ZERO;
    public Vec2 shadowRot2 = Vec2.ZERO;
    public Vec2 prevShadowRot = Vec2.ZERO;
    public Vec2 prevShadowRot2 = Vec2.ZERO;
    public float percentBoost = 0.0f;

    public void tick(LivingEntity mob) {
        HyperRabbit hyperRabbit;
        double elasticity = 0.25;
        this.prevShadow = this.shadow;
        this.prevShadow2 = this.shadow2;
        this.prevShadowRot = this.shadowRot;
        this.prevShadowRot2 = this.shadowRot2;
        this.shadowRot = new Vec2((float)((double)mob.getXRot() + (double)(this.shadowRot.x - mob.getXRot()) * elasticity * 0.75), (float)((double)mob.yBodyRot + (double)(this.shadowRot.y - mob.yBodyRot) * elasticity * 0.75));
        this.shadowRot2 = new Vec2((float)((double)this.shadowRot.x + (double)(this.shadowRot2.x - this.shadowRot.x) * elasticity * (double)0.35f), (float)((double)this.shadowRot.y + (double)(this.shadowRot2.y - this.shadowRot.y) * elasticity * (double)0.35f));
        float shadowX = (float)(this.shadow.x + (mob.getX() - this.shadow.x) * elasticity);
        float shadowY = (float)(this.shadow.y + (mob.getY() - this.shadow.y) * elasticity);
        float shadowZ = (float)(this.shadow.z + (mob.getZ() - this.shadow.z) * elasticity);
        float shadowX2 = (float)(this.shadow2.x + (this.shadow.x - this.shadow2.x) * elasticity * 0.375);
        float shadowY2 = (float)(this.shadow2.y + (this.shadow.y - this.shadow2.y) * elasticity * 0.375);
        float shadowZ2 = (float)(this.shadow2.z + (this.shadow.z - this.shadow2.z) * elasticity * 0.375);
        this.shadow = new Vec3((double)shadowX, (double)shadowY, (double)shadowZ);
        this.shadow2 = new Vec3((double)shadowX2, (double)shadowY2, (double)shadowZ2);
        if (!mob.level().isClientSide()) {
            this.removeBoost(mob);
        }
        if (mob instanceof HyperRabbit && (hyperRabbit = (HyperRabbit)mob).isSpark()) {
            this.percentBoost = 1.0f;
        } else if (mob.hasEffect(ModEffects.HYPER_SPARK)) {
            if (this.percentBoost >= 0.65f) {
                this.pushEntities(mob);
            }
            this.tryAddBooster(mob);
        } else {
            this.percentBoost = 0.0f;
        }
    }

    public void setPercentBoost(float percentBoost) {
        this.percentBoost = percentBoost;
    }

    public Vec3 getShadow() {
        return this.shadow;
    }

    public Vec3 getShadow2() {
        return this.shadow2;
    }

    public Vec3 getPrevShadow() {
        return this.prevShadow;
    }

    public Vec3 getPrevShadow2() {
        return this.prevShadow2;
    }

    public Vec2 getShadowRot() {
        return this.shadowRot;
    }

    public Vec2 getShadowRot2() {
        return this.shadowRot2;
    }

    public Vec2 getPrevShadowRot() {
        return this.prevShadowRot;
    }

    public Vec2 getPrevShadowRot2() {
        return this.prevShadowRot2;
    }

    protected void pushEntities(LivingEntity entity) {
        List list;
        if (!entity.level().isClientSide() && !(list = entity.level().getEntities(EntityTypeTest.forClass(LivingEntity.class), entity.getBoundingBox().expandTowards((double)0.05f, 0.0, (double)0.05f), EntitySelector.pushableBy((Entity)entity))).isEmpty()) {
            for (int l = 0; l < list.size(); ++l) {
                LivingEntity entity2 = (LivingEntity)list.get(l);
                if (entity == entity2 || entity.isAlliedTo((Entity)entity2)) continue;
                entity2.knockback(5.0 * (double)this.percentBoost, entity.getDeltaMovement().x, entity.getDeltaMovement().z);
                entity2.hurt(entity.damageSources().mobAttack(entity), (float)Mth.floor((float)(8.0f * this.percentBoost)));
            }
        }
    }

    protected void removeBoost(LivingEntity entity) {
        AttributeInstance attributeinstance = entity.getAttribute(Attributes.MOVEMENT_SPEED);
        if (attributeinstance != null && attributeinstance.hasModifier(SPEED_MODIFIER_BOOST_UUID)) {
            attributeinstance.removeModifier(SPEED_MODIFIER_BOOST_UUID);
        }
    }

    protected void tryAddBooster(LivingEntity entity) {
        this.percentBoost = entity.isSprinting() && !entity.isInWater() && entity.getPose() == Pose.STANDING ? (this.percentBoost <= 1.0f ? (this.percentBoost += 0.01f) : 1.0f) : (this.percentBoost >= 0.0f ? (this.percentBoost -= 0.1f) : 0.0f);
        if (this.percentBoost > 0.0f && !entity.level().isClientSide()) {
            AttributeInstance attributeinstance = entity.getAttribute(Attributes.MOVEMENT_SPEED);
            if (attributeinstance == null) {
                return;
            }
            float f = 0.2f * this.percentBoost;
            attributeinstance.addTransientModifier(new AttributeModifier(SPEED_MODIFIER_BOOST_UUID, (double)f, AttributeModifier.Operation.ADD_VALUE));
        }
    }

    public float getPercentBoost() {
        return this.percentBoost;
    }

    public ShadowCapability read(IAttachmentHolder iAttachmentHolder, ValueInput valueInput) {
        return null;
    }

    public boolean write(ShadowCapability shadowCapability, ValueOutput valueOutput) {
        return false;
    }
}

