/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.client.model;

import baguchan.earthmobsmod.client.render.state.BoulderingZombieRenderState;
import baguchi.bagus_lib.client.layer.IArmor;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class AbstractBoulderingZombieModel<T extends BoulderingZombieRenderState>
extends EntityModel<T>
implements IArmor {
    public final ModelPart head;
    public final ModelPart body;
    public final ModelPart left_arm;
    public final ModelPart right_arm;
    public final ModelPart left_leg;
    public final ModelPart right_leg;

    public AbstractBoulderingZombieModel(ModelPart root) {
        super(root);
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.left_arm = root.getChild("left_arm");
        this.right_arm = root.getChild("right_arm");
        this.left_leg = root.getChild("left_leg");
        this.right_leg = root.getChild("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 32).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(28, 28).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 48).addBox(-1.0f, -2.0f, -2.0f, 5.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(32, 0).addBox(-1.0f, -2.0f, -2.0f, 5.0f, 14.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(38, 44).addBox(-4.0f, -2.0f, -2.0f, 5.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(20, 44).addBox(-4.0f, -2.0f, -2.0f, 5.0f, 14.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(60, 0).addBox(-1.9f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(52, 30).addBox(-1.9f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(56, 46).addBox(-2.1f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(48, 14).addBox(-2.1f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity) {
        super.setupAnim(entity);
        this.head.yRot = ((BoulderingZombieRenderState)((Object)entity)).yRot * ((float)Math.PI / 180);
        this.head.xRot = ((BoulderingZombieRenderState)((Object)entity)).xRot * ((float)Math.PI / 180);
        AnimationUtils.animateZombieArms((ModelPart)this.left_arm, (ModelPart)this.right_arm, (boolean)((BoulderingZombieRenderState)((Object)entity)).isAggressive, (float)((BoulderingZombieRenderState)((Object)entity)).attackTime, (float)((BoulderingZombieRenderState)((Object)entity)).ageInTicks);
        this.right_leg.xRot = Mth.cos((float)(((BoulderingZombieRenderState)((Object)entity)).walkAnimationPos * 0.6662f)) * 1.4f * ((BoulderingZombieRenderState)((Object)entity)).walkAnimationSpeed * 0.5f;
        this.right_leg.yRot = 0.0f;
        this.right_leg.zRot = 0.0f;
        this.left_leg.xRot = Mth.cos((float)(((BoulderingZombieRenderState)((Object)entity)).walkAnimationPos * 0.6662f + (float)Math.PI)) * 1.4f * ((BoulderingZombieRenderState)((Object)entity)).walkAnimationSpeed * 0.5f;
        this.left_leg.yRot = 0.0f;
        this.left_leg.zRot = 0.0f;
        if (((BoulderingZombieRenderState)((Object)entity)).climbable) {
            this.left_arm.xRot -= Mth.sin((float)(0.25f * ((BoulderingZombieRenderState)((Object)entity)).ageInTicks)) * 0.225f;
            this.right_arm.xRot += Mth.sin((float)(0.25f * ((BoulderingZombieRenderState)((Object)entity)).ageInTicks)) * 0.225f;
            this.left_leg.xRot = -0.4f - Mth.sin((float)(0.25f * ((BoulderingZombieRenderState)((Object)entity)).ageInTicks)) * 0.225f;
            this.right_leg.xRot = -0.4f + Mth.sin((float)(0.25f * ((BoulderingZombieRenderState)((Object)entity)).ageInTicks)) * 0.225f;
        }
        if (((BoulderingZombieRenderState)((Object)entity)).isPassenger) {
            this.right_leg.xRot = -1.4137167f;
            this.right_leg.yRot = 0.31415927f;
            this.right_leg.zRot = 0.07853982f;
            this.left_leg.xRot = -1.4137167f;
            this.left_leg.yRot = -0.31415927f;
            this.left_leg.zRot = -0.07853982f;
        }
    }

    protected float rotlerpRad(float angle, float maxAngle, float mul) {
        float f = (mul - maxAngle) % ((float)Math.PI * 2);
        if (f < (float)(-Math.PI)) {
            f += (float)Math.PI * 2;
        }
        if (f >= (float)Math.PI) {
            f -= (float)Math.PI * 2;
        }
        return maxAngle + angle * f;
    }

    public void translateToHead(ModelPart part, PoseStack poseStack) {
        part.translateAndRotate(poseStack);
    }

    public void translateToChest(ModelPart part, PoseStack poseStack) {
        part.translateAndRotate(poseStack);
    }

    public void translateToLeg(ModelPart part, PoseStack poseStack) {
        part.translateAndRotate(poseStack);
    }

    public void translateToChestPat(ModelPart part, PoseStack poseStack) {
        part.translateAndRotate(poseStack);
        poseStack.scale(1.05f, 1.05f, 1.05f);
    }

    public Iterable<ModelPart> rightHandArmors() {
        return ImmutableList.of((Object)this.right_arm);
    }

    public Iterable<ModelPart> leftHandArmors() {
        return ImmutableList.of((Object)this.left_arm);
    }

    public Iterable<ModelPart> rightLegPartArmors() {
        return ImmutableList.of((Object)this.right_leg);
    }

    public Iterable<ModelPart> leftLegPartArmors() {
        return ImmutableList.of((Object)this.left_leg);
    }

    public Iterable<ModelPart> bodyPartArmors() {
        return ImmutableList.of((Object)this.body);
    }

    public Iterable<ModelPart> headPartArmors() {
        return ImmutableList.of((Object)this.head);
    }
}

