/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.client.model;

import baguchan.earthmobsmod.client.model.AbstractBoulderingZombieModel;
import baguchan.earthmobsmod.client.render.state.BoulderingZombieRenderState;
import baguchi.bagus_lib.client.layer.IArmor;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class BoulderingDrownedModel<T extends BoulderingZombieRenderState>
extends AbstractBoulderingZombieModel<T>
implements IArmor {
    public float swimAmount;

    public BoulderingDrownedModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition createBodyLayer(CubeDeformation cubeDeformation) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDeformation).texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 32).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, cubeDeformation).texOffs(28, 28).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 48).addBox(-1.0f, -2.0f, -2.0f, 5.0f, 14.0f, 4.0f, cubeDeformation).texOffs(32, 0).addBox(-1.0f, -2.0f, -2.0f, 5.0f, 14.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(38, 44).addBox(-4.0f, -2.0f, -2.0f, 5.0f, 14.0f, 4.0f, cubeDeformation).texOffs(20, 44).addBox(-4.0f, -2.0f, -2.0f, 5.0f, 14.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(60, 0).addBox(-1.9f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDeformation).texOffs(52, 30).addBox(-1.9f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(56, 46).addBox(-2.1f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDeformation).texOffs(48, 14).addBox(-2.1f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    @Override
    public void setupAnim(T entity) {
        super.setupAnim(entity);
        if (((BoulderingZombieRenderState)((Object)entity)).rightArmPose == HumanoidModel.ArmPose.THROW_SPEAR) {
            if (((BoulderingZombieRenderState)((Object)entity)).mainArm == HumanoidArm.RIGHT) {
                this.right_arm.xRot = this.right_arm.xRot * 0.5f - (float)Math.PI;
                this.right_arm.yRot = 0.0f;
            } else {
                this.left_arm.xRot = this.left_arm.xRot * 0.5f - (float)Math.PI;
                this.left_arm.yRot = 0.0f;
            }
        }
        if (this.swimAmount > 0.0f) {
            this.right_arm.xRot = this.rotlerpRad(this.swimAmount, this.right_arm.xRot, -2.5132742f) + this.swimAmount * 0.35f * Mth.sin((float)(0.1f * ((BoulderingZombieRenderState)((Object)entity)).ageInTicks));
            this.left_arm.xRot = this.rotlerpRad(this.swimAmount, this.left_arm.xRot, -2.5132742f) - this.swimAmount * 0.35f * Mth.sin((float)(0.1f * ((BoulderingZombieRenderState)((Object)entity)).ageInTicks));
            this.right_arm.zRot = this.rotlerpRad(this.swimAmount, this.right_arm.zRot, -0.15f);
            this.left_arm.zRot = this.rotlerpRad(this.swimAmount, this.left_arm.zRot, 0.15f);
            this.left_leg.xRot -= this.swimAmount * 0.55f * Mth.sin((float)(0.1f * ((BoulderingZombieRenderState)((Object)entity)).ageInTicks));
            this.right_leg.xRot += this.swimAmount * 0.55f * Mth.sin((float)(0.1f * ((BoulderingZombieRenderState)((Object)entity)).ageInTicks));
            this.head.xRot = 0.0f;
        }
    }

    @Override
    protected float rotlerpRad(float angle, float maxAngle, float mul) {
        float f = (mul - maxAngle) % ((float)Math.PI * 2);
        if (f < (float)(-Math.PI)) {
            f += (float)Math.PI * 2;
        }
        if (f >= (float)Math.PI) {
            f -= (float)Math.PI * 2;
        }
        return maxAngle + angle * f;
    }
}

