/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.client.model;

import java.util.Set;
import net.minecraft.client.model.BabyModelTransform;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.ChickenRenderState;
import net.minecraft.util.Mth;

public class FancyChickenModel<T extends ChickenRenderState>
extends EntityModel<T> {
    public static final MeshTransformer BABY_TRANSFORMER = new BabyModelTransform(Set.of("head"));
    private final ModelPart root;
    private final ModelPart bone;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart rightWing;
    private final ModelPart leftWing;
    private final ModelPart bill;
    private final ModelPart chin;

    public FancyChickenModel(ModelPart root) {
        super(root);
        this.root = root;
        this.bone = root.getChild("bone");
        this.head = this.bone.getChild("head");
        this.bill = this.bone.getChild("bill");
        this.chin = this.bone.getChild("chin");
        this.body = this.bone.getChild("body");
        this.rightLeg = this.bone.getChild("right_leg");
        this.leftLeg = this.bone.getChild("left_leg");
        this.rightWing = this.bone.getChild("right_wing");
        this.leftWing = this.bone.getChild("left_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition bone = partdefinition.addOrReplaceChild("bone", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)22.0f, (float)0.0f));
        PartDefinition head = bone.addOrReplaceChild("head", CubeListBuilder.create().texOffs(22, 11).addBox(-2.0f, -6.0f, -2.0f, 4.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(12, 19).addBox(0.0f, -10.0f, -3.0f, 0.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-9.0f, (float)-4.0f));
        PartDefinition bill = bone.addOrReplaceChild("bill", CubeListBuilder.create().texOffs(18, 0).addBox(-2.0f, -4.0f, -4.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-9.0f, (float)-4.0f));
        PartDefinition chin = bone.addOrReplaceChild("chin", CubeListBuilder.create().texOffs(24, 4).addBox(-1.0f, -2.0f, -3.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-9.0f, (float)-4.0f));
        PartDefinition body = bone.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -4.0f, -3.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-8.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = body.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 7).addBox(0.0f, -15.0f, 5.0f, 0.0f, 10.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)-4.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition right_wing = bone.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(14, 14).addBox(0.0f, 0.0f, -3.0f, 1.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-11.0f, (float)0.0f));
        PartDefinition right_leg = bone.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 24).addBox(-1.5f, 0.0f, -3.0f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.5f, (float)-5.0f, (float)1.0f));
        PartDefinition left_leg = bone.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 24).addBox(-1.5f, 0.0f, -3.0f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.5f, (float)-5.0f, (float)1.0f));
        PartDefinition left_wing = bone.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(14, 14).addBox(-1.0f, 0.0f, -3.0f, 1.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-11.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity) {
        float f;
        super.setupAnim(entity);
        this.head.xRot = ((ChickenRenderState)entity).xRot * ((float)Math.PI / 180);
        this.head.yRot = ((ChickenRenderState)entity).yRot * ((float)Math.PI / 180);
        this.bill.xRot = this.head.xRot;
        this.bill.yRot = this.head.yRot;
        this.chin.xRot = this.head.xRot;
        this.chin.yRot = this.head.yRot;
        this.rightLeg.xRot = Mth.cos((float)(((ChickenRenderState)entity).walkAnimationPos * 0.6662f)) * 1.4f * ((ChickenRenderState)entity).walkAnimationSpeed;
        this.leftLeg.xRot = Mth.cos((float)(((ChickenRenderState)entity).walkAnimationPos * 0.6662f + (float)Math.PI)) * 1.4f * ((ChickenRenderState)entity).walkAnimationSpeed;
        this.rightWing.zRot = f = (Mth.sin((float)((ChickenRenderState)entity).flap) + 1.0f) * ((ChickenRenderState)entity).flapSpeed;
        this.leftWing.zRot = -f;
    }
}

