/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.client.model;

import baguchan.earthmobsmod.client.animation.JollyLlamaAnimation;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LlamaRenderState;

public class JollyLlamaModel<T extends LlamaRenderState>
extends EntityModel<T> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart leg3;
    private final ModelPart leg4;
    private final ModelPart chest_left;
    private final ModelPart chest_right;
    private final KeyframeAnimation walkAnimation;
    private final KeyframeAnimation babyAnimation;

    public JollyLlamaModel(ModelPart root) {
        super(root);
        this.root = root;
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.leg1 = root.getChild("leg1");
        this.leg2 = root.getChild("leg2");
        this.leg3 = root.getChild("leg3");
        this.leg4 = root.getChild("leg4");
        this.chest_left = this.body.getChild("chest_left");
        this.chest_right = this.body.getChild("chest_right");
        this.walkAnimation = JollyLlamaAnimation.WALK.bake(root);
        this.babyAnimation = JollyLlamaAnimation.BABY.bake(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(36, 24).addBox(-2.0f, -14.0f, -10.0f, 4.0f, 4.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(44, 0).addBox(-4.0f, -16.0f, -6.0f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(39, 44).addBox(-4.5f, -16.0f, -6.5f, 9.0f, 12.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(16, 51).addBox(4.0f, -31.0f, -3.5f, 7.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(16, 51).mirror().addBox(-11.0f, -31.0f, -3.5f, 7.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 5).addBox(1.0f, -19.0f, -4.0f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-4.0f, -19.0f, -4.0f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)7.0f, (float)-6.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -10.0f, -7.0f, 12.0f, 18.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(0, 28).addBox(-6.5f, -6.0f, -6.5f, 13.0f, 13.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)2.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition chest_left = body.addOrReplaceChild("chest_left", CubeListBuilder.create().texOffs(72, 0).addBox(-4.0f, -2.5f, -3.5f, 8.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.0f, (float)3.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)1.5708f));
        PartDefinition chest_right = body.addOrReplaceChild("chest_right", CubeListBuilder.create().texOffs(72, 13).addBox(-4.0f, -2.5f, -3.5f, 8.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-9.0f, (float)3.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)1.5708f));
        PartDefinition leg1 = partdefinition.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(0, 51).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.5f, (float)10.0f, (float)6.0f));
        PartDefinition leg2 = partdefinition.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(0, 51).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.5f, (float)10.0f, (float)6.0f));
        PartDefinition leg3 = partdefinition.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(0, 51).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.5f, (float)10.0f, (float)-5.0f));
        PartDefinition leg4 = partdefinition.addOrReplaceChild("leg4", CubeListBuilder.create().texOffs(0, 51).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.5f, (float)10.0f, (float)-5.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity) {
        super.setupAnim(entity);
        this.head.xRot = ((LlamaRenderState)entity).xRot * ((float)Math.PI / 180);
        this.head.yRot = ((LlamaRenderState)entity).yRot * ((float)Math.PI / 180);
        this.chest_right.visible = ((LlamaRenderState)entity).hasChest;
        this.chest_left.visible = ((LlamaRenderState)entity).hasChest;
        if (((LlamaRenderState)entity).isBaby) {
            this.babyAnimation.applyStatic();
        }
        this.walkAnimation.applyWalk(((LlamaRenderState)entity).walkAnimationPos, ((LlamaRenderState)entity).walkAnimationSpeed, 2.0f, 2.5f);
    }
}

