/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.client.render;

import baguchan.earthmobsmod.client.ModModelLayers;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.AgeableMobRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.WolfArmorLayer;
import net.minecraft.client.renderer.entity.layers.WolfCollarLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.WolfRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.wolf.Wolf;

public class SkeletonWolfRenderer
extends AgeableMobRenderer<Wolf, WolfRenderState, WolfModel> {
    private static final ResourceLocation WOLF_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"earthmobsmod", (String)"textures/entity/skeleton_wolf/skeleton_wolf.png");
    private static final ResourceLocation WOLF_ANGRY_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"earthmobsmod", (String)"textures/entity/skeleton_wolf/skeleton_wolf_angry.png");

    public SkeletonWolfRenderer(EntityRendererProvider.Context p_174452_) {
        super(p_174452_, (EntityModel)new WolfModel(p_174452_.bakeLayer(ModModelLayers.SKELETON_WOLF)), (EntityModel)new WolfModel(p_174452_.bakeLayer(ModModelLayers.SKELETON_WOLF_BABY)), 0.5f);
        this.addLayer((RenderLayer)new WolfArmorLayer((RenderLayerParent)this, p_174452_.getModelSet(), p_174452_.getEquipmentRenderer()));
        this.addLayer((RenderLayer)new WolfCollarLayer((RenderLayerParent)this));
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)13.5f, (float)-7.0f));
        partdefinition1.addOrReplaceChild("real_head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -3.0f, -2.0f, 6.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(16, 14).addBox(-2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror().texOffs(16, 14).addBox(2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 10).mirror(false).addBox(-0.5f, -0.001f, -5.0f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.ZERO);
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(18, 14).addBox(-3.0f, -2.0f, -3.0f, 6.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)2.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("upper_body", CubeListBuilder.create().texOffs(21, 0).addBox(-3.0f, -3.0f, -3.0f, 8.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)14.0f, (float)-3.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        PartDefinition right_hind_leg = partdefinition.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(0, 18).addBox(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)16.0f, (float)7.0f));
        PartDefinition left_hind_leg = partdefinition.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(0, 18).mirror().addBox(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.5f, (float)16.0f, (float)7.0f));
        PartDefinition right_front_leg = partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(0, 18).addBox(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)16.0f, (float)-4.0f));
        PartDefinition left_front_leg = partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(0, 18).mirror().addBox(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.5f, (float)16.0f, (float)-4.0f));
        PartDefinition partdefinition2 = partdefinition.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-1.0f, (float)12.0f, (float)9.0f, (float)0.62831855f, (float)0.0f, (float)0.0f));
        partdefinition2.addOrReplaceChild("real_tail", CubeListBuilder.create().texOffs(9, 18).addBox(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    protected int getModelTint(WolfRenderState p_365181_) {
        float f = p_365181_.wetShade;
        return f == 1.0f ? -1 : ARGB.colorFromFloat((float)1.0f, (float)f, (float)f, (float)f);
    }

    public ResourceLocation getTextureLocation(WolfRenderState p_116526_) {
        return p_116526_.isAngry ? WOLF_ANGRY_LOCATION : WOLF_LOCATION;
    }

    public WolfRenderState createRenderState() {
        return new WolfRenderState();
    }

    public void extractRenderState(Wolf p_406305_, WolfRenderState p_363549_, float p_362105_) {
        super.extractRenderState((LivingEntity)p_406305_, (LivingEntityRenderState)p_363549_, p_362105_);
        p_363549_.isAngry = p_406305_.isAngry();
        p_363549_.isSitting = p_406305_.isInSittingPose();
        p_363549_.tailAngle = p_406305_.getTailAngle();
        p_363549_.headRollAngle = p_406305_.getHeadRollAngle(p_362105_);
        p_363549_.shakeAnim = p_406305_.getShakeAnim(p_362105_);
        p_363549_.texture = p_406305_.getTexture();
        p_363549_.wetShade = p_406305_.getWetShade(p_362105_);
        p_363549_.collarColor = p_406305_.isTame() ? p_406305_.getCollarColor() : null;
        p_363549_.bodyArmorItem = p_406305_.getBodyArmorItem().copy();
    }
}

