/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.client.render;

import baguchan.earthmobsmod.client.EarthRenderType;
import baguchan.earthmobsmod.client.ModModelLayers;
import baguchan.earthmobsmod.client.render.layer.TropicalSlimeOuterLayer;
import baguchan.earthmobsmod.client.render.state.TropicalSlimeRenderState;
import baguchan.earthmobsmod.entity.TropicalSlime;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SlimeModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public class TropicalSlimeRenderer
extends MobRenderer<TropicalSlime, TropicalSlimeRenderState, SlimeModel> {
    public static final ResourceLocation SLIME_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"earthmobsmod", (String)"textures/entity/tropical_slime/tropical_slime.png");
    public static final ResourceLocation NO_FISH_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"earthmobsmod", (String)"textures/entity/tropical_slime/tropical_slime_no_fish.png");
    public static final ResourceLocation SLIME_OUTER_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"earthmobsmod", (String)"textures/entity/tropical_slime/tropical_slime_outer.png");
    public final SlimeModel noFishSlimeModel;
    public final SlimeModel fishSlimeModel;

    public TropicalSlimeRenderer(EntityRendererProvider.Context p_174391_) {
        super(p_174391_, (EntityModel)new SlimeModel(p_174391_.bakeLayer(ModModelLayers.TROPICAL_SLIME)), 0.25f);
        this.addLayer(new TropicalSlimeOuterLayer((RenderLayerParent<TropicalSlimeRenderState, SlimeModel>)this, p_174391_.getModelSet()));
        this.noFishSlimeModel = new SlimeModel(p_174391_.bakeLayer(ModModelLayers.TROPICAL_SLIME_STABLE));
        this.fishSlimeModel = new SlimeModel(p_174391_.bakeLayer(ModModelLayers.TROPICAL_SLIME));
    }

    public void submit(TropicalSlimeRenderState p_433493_, PoseStack p_434615_, SubmitNodeCollector p_433768_, CameraRenderState p_450931_) {
        SlimeModel var10001 = p_433493_.fish ? this.fishSlimeModel : this.noFishSlimeModel;
        this.model = var10001;
        super.submit((LivingEntityRenderState)p_433493_, p_434615_, p_433768_, p_450931_);
    }

    public static LayerDefinition createInnerBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("cube", CubeListBuilder.create().texOffs(0, 40).addBox(-6.0f, 14.0f, -6.0f, 12.0f, 12.0f, 12.0f, new CubeDeformation(-2.8f)), PartPose.ZERO);
        partdefinition.addOrReplaceChild("right_eye", CubeListBuilder.create().texOffs(50, 34).addBox(-3.25f, 18.0f, -3.5f, 2.0f, 2.0f, 2.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("left_eye", CubeListBuilder.create().texOffs(50, 42).addBox(1.25f, 18.0f, -3.5f, 2.0f, 2.0f, 2.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(49, 49).addBox(0.0f, 21.0f, -3.5f, 1.0f, 1.0f, 1.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)3072);
    }

    public static LayerDefinition createStableInnerBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("cube", CubeListBuilder.create().texOffs(0, 40).addBox(-6.0f, 14.0f, -6.0f, 12.0f, 12.0f, 12.0f, new CubeDeformation(-2.8f)), PartPose.ZERO);
        partdefinition.addOrReplaceChild("right_eye", CubeListBuilder.create().texOffs(50, 34).addBox(-3.25f, 18.0f, -3.5f, 2.0f, 2.0f, 2.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("left_eye", CubeListBuilder.create().texOffs(50, 42).addBox(1.25f, 18.0f, -3.5f, 2.0f, 2.0f, 2.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(49, 49).addBox(0.0f, 21.0f, -3.5f, 1.0f, 1.0f, 1.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Nullable
    protected RenderType getRenderType(TropicalSlimeRenderState p_360858_, boolean p_115323_, boolean p_115324_, boolean p_115325_) {
        if (!p_115324_ && p_115323_) {
            if (!p_360858_.fish) {
                return RenderType.entityCutoutNoCull((ResourceLocation)NO_FISH_LOCATION);
            }
            return EarthRenderType.entityAnimationWithAllTexture(SLIME_LOCATION, 100, 48, (int)(p_360858_.ageInTicks - p_360858_.partialTick));
        }
        return super.getRenderType((LivingEntityRenderState)p_360858_, p_115323_, p_115324_, p_115325_);
    }

    protected float getShadowRadius(TropicalSlimeRenderState p_383137_) {
        return (float)p_383137_.size * 0.25f;
    }

    protected void scale(TropicalSlimeRenderState p_364158_, PoseStack p_115964_) {
        float f = 0.999f;
        p_115964_.scale(0.999f, 0.999f, 0.999f);
        p_115964_.translate(0.0f, 0.001f, 0.0f);
        float f1 = p_364158_.size;
        float f2 = p_364158_.squish / (f1 * 0.5f + 1.0f);
        float f3 = 1.0f / (f2 + 1.0f);
        p_115964_.scale(f3 * f1, 1.0f / f3 * f1, f3 * f1);
    }

    public TropicalSlimeRenderState createRenderState() {
        return new TropicalSlimeRenderState();
    }

    public void extractRenderState(TropicalSlime p_362664_, TropicalSlimeRenderState p_365237_, float p_361099_) {
        super.extractRenderState((LivingEntity)p_362664_, (LivingEntityRenderState)p_365237_, p_361099_);
        p_365237_.squish = Mth.lerp((float)p_361099_, (float)p_362664_.oSquish, (float)p_362664_.squish);
        p_365237_.size = p_362664_.getSize();
        p_365237_.fish = p_362664_.hasFish();
    }

    public ResourceLocation getTextureLocation(TropicalSlimeRenderState p_115974_) {
        return SLIME_LOCATION;
    }
}

