/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.client.render.layer;

import baguchan.earthmobsmod.client.ModModelLayers;
import baguchan.earthmobsmod.client.model.MuddyPigModel;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.context.ContextKey;

public class MuddyPigMudLayer<T extends LivingEntityRenderState, S extends EntityModel<T>>
extends RenderLayer<T, S> {
    private static final ResourceLocation MUD_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"earthmobsmod", (String)"textures/entity/muddypig/muddy_pig.png");
    private static final ResourceLocation DRY_MUD_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"earthmobsmod", (String)"textures/entity/muddypig/dry_muddy_pig.png");
    public static final ContextKey<Boolean> IS_MUD = new ContextKey(ResourceLocation.fromNamespaceAndPath((String)"earthmobsmod", (String)"mud"));
    public static final ContextKey<Boolean> IS_SHEARED = new ContextKey(ResourceLocation.fromNamespaceAndPath((String)"earthmobsmod", (String)"sheared"));
    private final MuddyPigModel model;
    private final MuddyPigModel babyModel;

    public MuddyPigMudLayer(RenderLayerParent<T, S> p_174533_, EntityModelSet p_174534_) {
        super(p_174533_);
        this.model = new MuddyPigModel(p_174534_.bakeLayer(ModModelLayers.MUDDY_PIG));
        this.babyModel = new MuddyPigModel(p_174534_.bakeLayer(ModModelLayers.MUDDY_PIG_BABY));
    }

    public void submit(PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int i, T entityRenderState, float v, float v1) {
        MuddyPigModel pigModel;
        boolean mud = (Boolean)entityRenderState.getRenderDataOrDefault(IS_MUD, (Object)false);
        MuddyPigModel muddyPigModel = pigModel = ((LivingEntityRenderState)entityRenderState).isBaby ? this.babyModel : this.model;
        if (mud) {
            if (((LivingEntityRenderState)entityRenderState).isInvisible) {
                if (entityRenderState.appearsGlowing()) {
                    submitNodeCollector.submitModel((Model)pigModel, entityRenderState, poseStack, RenderType.outline((ResourceLocation)MUD_LOCATION), i, LivingEntityRenderer.getOverlayCoords(entityRenderState, (float)0.0f), -16777216, (TextureAtlasSprite)null, ((LivingEntityRenderState)entityRenderState).outlineColor, (ModelFeatureRenderer.CrumblingOverlay)null);
                }
            } else {
                MuddyPigMudLayer.coloredCutoutModelCopyLayerRender((Model)pigModel, (ResourceLocation)MUD_LOCATION, (PoseStack)poseStack, (SubmitNodeCollector)submitNodeCollector, (int)i, entityRenderState, (int)-1, (int)1);
            }
        }
    }
}

