/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.data;

import baguchan.earthmobsmod.registry.ModBlocks;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;

public class BlockLootTables
extends BlockLootSubProvider {
    private final Set<Block> knownBlocks = new HashSet<Block>();
    private static final float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
    private static final float[] RARE_SAPLING_DROP_RATES = new float[]{0.025f, 0.027777778f, 0.03125f, 0.041666668f, 0.1f};
    private static final Set<Item> EXPLOSION_RESISTANT = Set.of();

    protected BlockLootTables(HolderLookup.Provider provider) {
        super(EXPLOSION_RESISTANT, FeatureFlags.REGISTRY.allFlags(), provider);
    }

    protected void add(Block block, LootTable.Builder builder) {
        super.add(block, builder);
        this.knownBlocks.add(block);
    }

    protected void generate() {
        this.dropSelf((Block)ModBlocks.BUTTERCUP.get());
        this.dropSelf((Block)ModBlocks.PINK_DAISY.get());
        this.dropSelf((Block)ModBlocks.CARVED_MELON_SHOOT.get());
        this.dropSelf((Block)ModBlocks.CARVED_MELON.get());
        this.dropSelf((Block)ModBlocks.RUBY.get());
        this.dropSelf((Block)ModBlocks.TROPICAL_SLIME_BLOCK.get());
        this.dropPottedContents((Block)ModBlocks.POTTED_BUTTERCUP.get());
        this.dropPottedContents((Block)ModBlocks.POTTED_PINK_DAISY.get());
    }

    private void registerEmpty(Block b) {
        this.add(b, LootTable.lootTable());
    }

    private void registerSlab(Block b) {
        this.add(b, this.createSlabItemTable(b));
    }

    protected Iterable<Block> getKnownBlocks() {
        return this.knownBlocks;
    }
}

