/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity;

import baguchan.earthmobsmod.registry.ModBuiltInLootTables;
import baguchan.earthmobsmod.registry.ModEntities;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class FancyChicken
extends Chicken {
    public int eggSpecialTime;

    public FancyChicken(EntityType<? extends FancyChicken> p_28236_, Level p_28237_) {
        super(p_28236_, p_28237_);
        this.eggSpecialTime = this.random.nextInt(6000) + 6000;
    }

    public void aiStep() {
        super.aiStep();
        Level var3 = this.level();
        if (var3 instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)var3;
            if (this.isAlive() && !this.isBaby() && !this.isChickenJockey() && --this.eggSpecialTime <= 0) {
                if (this.dropFromGiftLootTable(serverlevel, ModBuiltInLootTables.FANCY_CHICKEN_LAY, (arg_0, arg_1) -> ((FancyChicken)this).spawnAtLocation(arg_0, arg_1))) {
                    this.playSound(SoundEvents.CHICKEN_EGG, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                    this.gameEvent((Holder)GameEvent.ENTITY_PLACE);
                }
                this.eggSpecialTime = this.random.nextInt(6000) + 6000;
            }
            this.eggTime = 10;
        }
    }

    public void readAdditionalSaveData(ValueInput compound) {
        super.readAdditionalSaveData(compound);
        if (compound.getInt("SpecialEggLayTime").isPresent()) {
            compound.getInt("SpecialEggLayTime").ifPresent(p_409318_ -> {
                this.eggSpecialTime = p_409318_;
            });
        }
    }

    public void addAdditionalSaveData(ValueOutput compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("SpecialEggLayTime", this.eggSpecialTime);
    }

    public Chicken getBreedOffspring(ServerLevel p_148884_, AgeableMob p_148885_) {
        return (Chicken)ModEntities.FANCY_CHICKEN.get().create((Level)p_148884_, EntitySpawnReason.BREEDING);
    }
}

