/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity;

import baguchan.earthmobsmod.entity.goal.EatLavaGoal;
import baguchan.earthmobsmod.registry.ModEntities;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class MagmaCow
extends Cow {
    private static final EntityDataAccessor<Boolean> WEAKING = SynchedEntityData.defineId(MagmaCow.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int eatAnimationTick;
    private EatLavaGoal eatBlockGoal;

    public MagmaCow(EntityType<? extends MagmaCow> p_28285_, Level p_28286_) {
        super(p_28285_, p_28286_);
        this.setPathfindingMalus(PathType.LAVA, 8.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(WEAKING, (Object)false);
    }

    public void setWeaking(boolean weak) {
        this.entityData.set(WEAKING, (Object)weak);
    }

    public boolean isWeaking() {
        return (Boolean)this.entityData.get(WEAKING);
    }

    protected void registerGoals() {
        this.eatBlockGoal = new EatLavaGoal((Mob)this);
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.15, false));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.1, (Predicate)Ingredient.of((ItemLike)Items.MAGMA_CREAM), false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(5, (Goal)this.eatBlockGoal);
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, MagmaCube.class, true));
    }

    public void tick() {
        super.tick();
        if (this.isInWater() && !this.isWeaking()) {
            this.fizz();
        }
    }

    private void fizz() {
        if (this.level().isClientSide()) {
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getRandomX(this.getBbWidth()), this.getRandomY(), this.getRandomZ(this.getBbWidth()), 0.0, 0.0, 0.0);
            }
        }
        this.playSound(SoundEvents.LAVA_EXTINGUISH);
        this.setWeaking(true);
    }

    public InteractionResult mobInteract(Player p_28941_, InteractionHand p_28942_) {
        ItemStack itemstack = p_28941_.getItemInHand(p_28942_);
        if (itemstack.is(Items.BUCKET) && !this.isBaby()) {
            ItemStack itemstack1 = new ItemStack((ItemLike)Items.LAVA_BUCKET);
            ItemStack itemstack2 = ItemUtils.createFilledResult((ItemStack)itemstack, (Player)p_28941_, (ItemStack)itemstack1, (boolean)false);
            p_28941_.setItemInHand(p_28942_, itemstack2);
            SoundEvent soundevent = SoundEvents.BUCKET_FILL_LAVA;
            this.playSound(soundevent, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(p_28941_, p_28942_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 12.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f).add(Attributes.ARMOR, 10.0).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.KNOCKBACK_RESISTANCE, (double)0.6f);
    }

    public Cow getBreedOffspring(ServerLevel p_148884_, AgeableMob p_148885_) {
        return (Cow)ModEntities.MAGMA_COW.get().create((Level)p_148884_, EntitySpawnReason.BREEDING);
    }

    public void addAdditionalSaveData(ValueOutput p_29864_) {
        super.addAdditionalSaveData(p_29864_);
        p_29864_.putBoolean("Weaking", this.isWeaking());
    }

    public void readAdditionalSaveData(ValueInput p_29845_) {
        super.readAdditionalSaveData(p_29845_);
        this.setWeaking(p_29845_.getBooleanOr("Weaking", false));
    }

    protected void customServerAiStep(ServerLevel serverLevel) {
        this.eatAnimationTick = this.eatBlockGoal.getEatAnimationTick();
        super.customServerAiStep(serverLevel);
    }

    public void aiStep() {
        this.updateSwingTime();
        if (this.level().isClientSide()) {
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        }
        super.aiStep();
    }

    public void handleEntityEvent(byte p_29814_) {
        if (p_29814_ == 10) {
            this.eatAnimationTick = 40;
        } else if (p_29814_ == 11) {
            for (int i = 0; i < 7; ++i) {
                double d0 = this.random.nextGaussian() * 0.02;
                double d1 = this.random.nextGaussian() * 0.02;
                double d2 = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)ParticleTypes.LAVA, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d0, d1, d2);
            }
        } else {
            super.handleEntityEvent(p_29814_);
        }
    }

    public float getHeadEatAngleScale(float p_29883_) {
        if (this.eatAnimationTick > 4 && this.eatAnimationTick <= 36) {
            float f = ((float)(this.eatAnimationTick - 4) - p_29883_) / 32.0f;
            return 0.62831855f + 0.21991149f * Mth.sin((float)(f * 28.7f));
        }
        return this.eatAnimationTick > 0 ? 0.62831855f : this.getXRot() * ((float)Math.PI / 180);
    }

    public boolean isFood(ItemStack p_27600_) {
        return p_27600_.is(Items.MAGMA_CREAM);
    }

    public boolean canFreeze() {
        return super.canFreeze() && this.isWeaking();
    }

    public static boolean checkMagmaSpawnRules(EntityType<? extends Animal> p_218105_, LevelAccessor p_218106_, EntitySpawnReason p_218107_, BlockPos p_218108_, RandomSource p_218109_) {
        return true;
    }

    public float getWalkTargetValue(BlockPos p_27573_, LevelReader p_27574_) {
        if (p_27574_.getBlockState(p_27573_.below()).is(Blocks.BASALT) || p_27574_.getBlockState(p_27573_.below()).is(Blocks.BLACKSTONE)) {
            return 1.0f;
        }
        return p_27574_.getBlockState(p_27573_.below()).is(Blocks.MAGMA_BLOCK) ? 10.0f : p_27574_.getPathfindingCostFromLightLevels(p_27573_) - 0.5f;
    }

    public int getMaxSpawnClusterSize() {
        return 12;
    }

    public void ate() {
        this.heal(2.0f);
        this.setWeaking(false);
        if (this.isBaby()) {
            this.ageUp(60);
        }
        this.playSound(SoundEvents.FIRE_EXTINGUISH);
        this.level().broadcastEntityEvent((Entity)this, (byte)11);
    }
}

