/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity;

import baguchan.earthmobsmod.entity.WoolyCow;
import baguchan.earthmobsmod.registry.ModEntities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.Nullable;

public class UmbraCow
extends WoolyCow {
    public static final ResourceKey<LootTable> UMBRA_COW_SHEARD_LOOT_TABLE = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"earthmobsmod", (String)"entities/umbra_cow_sheared"));

    public UmbraCow(EntityType<? extends UmbraCow> p_28285_, Level p_28286_) {
        super(p_28285_, p_28286_);
    }

    @Override
    public Optional<ResourceKey<LootTable>> getDefaultLootTable() {
        if (this.isSheared()) {
            return Optional.of(UMBRA_COW_SHEARD_LOOT_TABLE);
        }
        return this.getType().getDefaultLootTable();
    }

    @Override
    public WoolyCow getBreedOffspring(ServerLevel p_148884_, AgeableMob p_148885_) {
        return (WoolyCow)ModEntities.UMBRA_COW.get().create((Level)p_148884_, EntitySpawnReason.BREEDING);
    }

    @Override
    public List<ItemStack> onSheared(@Nullable Player player, ItemStack item, Level level, BlockPos pos) {
        level.playSound(null, (Entity)this, SoundEvents.SHEEP_SHEAR, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 1.0f, 1.0f);
        if (!level.isClientSide()) {
            this.setSheared(true);
            int i = 1 + this.random.nextInt(3);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int j = 0; j < i; ++j) {
                items.add(new ItemStack((ItemLike)Blocks.BLACK_WOOL));
            }
            return items;
        }
        return Collections.emptyList();
    }
}

