/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity.goal;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.level.Level;

public class RangedAndMeleeAttack
extends Goal {
    protected final Mob mob;
    private final RangedAttackMob rangedAttackMob;
    @Nullable
    protected LivingEntity target;
    protected int attackTime = -1;
    private final double speedModifier;
    protected int seeTime;
    private final int attackIntervalMin;
    private final int attackIntervalMax;
    private final float attackRadius;
    private final float attackRadiusSqr;
    private int ticksUntilNextAttack;
    protected final int attackLength;

    public RangedAndMeleeAttack(RangedAttackMob p_25768_, double p_25769_, int p_25770_, float p_25771_, int attackLength) {
        this(p_25768_, p_25769_, p_25770_, p_25770_, p_25771_, attackLength);
    }

    public RangedAndMeleeAttack(RangedAttackMob p_25773_, double p_25774_, int p_25775_, int p_25776_, float p_25777_, int attackLength) {
        this.attackLength = attackLength;
        if (!(p_25773_ instanceof LivingEntity)) {
            throw new IllegalArgumentException("ArrowAttackGoal requires Mob implements RangedAttackMob");
        }
        this.rangedAttackMob = p_25773_;
        this.mob = (Mob)p_25773_;
        this.speedModifier = p_25774_;
        this.attackIntervalMin = p_25775_;
        this.attackIntervalMax = p_25776_;
        this.attackRadius = p_25777_;
        this.attackRadiusSqr = p_25777_ * p_25777_;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        LivingEntity livingentity = this.mob.getTarget();
        if (livingentity != null && livingentity.isAlive()) {
            this.target = livingentity;
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.canUse() || !this.mob.getNavigation().isDone();
    }

    public void start() {
        super.start();
        this.mob.setAggressive(true);
    }

    public void stop() {
        this.target = null;
        this.seeTime = 0;
        this.attackTime = -1;
        this.mob.setAggressive(false);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        double d0 = this.mob.distanceToSqr(this.target.getX(), this.target.getY(), this.target.getZ());
        boolean flag = this.mob.getSensing().hasLineOfSight((Entity)this.target);
        double attackReach = this.getAttackReachSqr(this.target);
        if (d0 <= 26.0) {
            this.mob.getNavigation().moveTo((Entity)this.target, this.speedModifier);
            this.checkAndPerformAttack(this.target, d0);
            this.attackTime = -1;
        } else {
            if (flag && this.seeTime < 10) {
                ++this.seeTime;
            } else if (this.seeTime > 0) {
                --this.seeTime;
            }
            if (!(d0 > (double)this.attackRadiusSqr) && this.seeTime >= 5) {
                this.mob.getNavigation().stop();
            } else {
                this.mob.getNavigation().moveTo((Entity)this.target, this.speedModifier);
            }
            this.mob.getLookControl().setLookAt((Entity)this.target, 30.0f, 30.0f);
            if (!flag) {
                float f = (float)Math.sqrt(d0) / this.attackRadius;
                this.attackTime = Mth.floor((float)(f * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
                return;
            }
            if (this.attackLength == this.attackTime) {
                this.doAttackAnimation();
            }
            if (--this.attackTime == 0) {
                float f = (float)Math.sqrt(d0) / this.attackRadius;
                float f1 = Mth.clamp((float)f, (float)0.1f, (float)1.0f);
                this.rangedAttackMob.performRangedAttack(this.target, f1);
                this.attackTime = Mth.floor((float)(f * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
            } else if (this.attackTime < 0) {
                this.attackTime = Mth.floor((double)Mth.lerp((double)(Math.sqrt(d0) / (double)this.attackRadius), (double)this.attackIntervalMin, (double)this.attackIntervalMax));
            }
        }
    }

    public void doAttackAnimation() {
    }

    protected void checkAndPerformAttack(LivingEntity p_25557_, double p_25558_) {
        double d0 = this.getAttackReachSqr(p_25557_);
        if (p_25558_ <= d0 && this.ticksUntilNextAttack <= 0) {
            this.resetAttackCooldown();
            this.mob.swing(InteractionHand.MAIN_HAND);
            this.mob.doHurtTarget(RangedAndMeleeAttack.getServerLevel((Level)this.mob.level()), (Entity)p_25557_);
        }
        if (this.ticksUntilNextAttack > 0) {
            --this.ticksUntilNextAttack;
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.adjustedTickDelay(20);
    }

    protected int getRangeAttackTime() {
        return this.attackTime;
    }

    public void setRangeAttackTime(int time) {
        this.attackTime = time;
    }

    protected boolean isTimeToAttack() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected int getTicksUntilNextAttack() {
        return this.ticksUntilNextAttack;
    }

    protected double getAttackReachSqr(LivingEntity p_25556_) {
        return this.mob.getBbWidth() * 2.0f * this.mob.getBbWidth() * 2.0f + p_25556_.getBbWidth();
    }
}

