/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.fluidtype;

import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;

public class MudFluidType
extends FluidType {
    public MudFluidType(FluidType.Properties properties) {
        super(properties);
    }

    public boolean move(FluidState state, LivingEntity entity, Vec3 movementVector, double gravity) {
        boolean flag = entity.getDeltaMovement().y <= 0.0;
        double d0 = entity.getY();
        double d1 = MudFluidType.getEffectiveGravity(entity);
        float f = entity.isSprinting() ? 0.9f : 0.8f;
        float f1 = 0.02f;
        float f2 = (float)entity.getAttributeValue(Attributes.WATER_MOVEMENT_EFFICIENCY);
        if (!entity.onGround()) {
            f2 *= 0.5f;
        }
        if (f2 > 0.0f) {
            f += (0.54600006f - f) * f2;
            f1 += (entity.getSpeed() - f1) * f2;
        }
        if (entity.hasEffect(MobEffects.DOLPHINS_GRACE)) {
            f = 0.96f;
        }
        entity.moveRelative(f1 *= (float)entity.getAttributeValue(NeoForgeMod.SWIM_SPEED), movementVector);
        Vec3 vec3 = entity.getDeltaMovement();
        if (entity.horizontalCollision && entity.onClimbable()) {
            vec3 = new Vec3(vec3.x, 0.2, vec3.z);
        }
        vec3 = vec3.multiply((double)f, (double)0.8f, (double)f);
        entity.setDeltaMovement(entity.getFluidFallingAdjustedMovement(d1, flag, vec3).add(0.0, d1 / 4.0, 0.0));
        Vec3 vec34 = entity.getDeltaMovement();
        if (entity.horizontalCollision && entity.isFree(vec34.x, vec34.y + (double)0.6f - entity.getY() + d0, vec34.z)) {
            entity.setDeltaMovement(vec34.x, (double)0.3f, vec34.z);
        }
        return true;
    }

    protected static double getEffectiveGravity(LivingEntity entity) {
        boolean flag = entity.getDeltaMovement().y <= 0.0;
        return flag && entity.hasEffect(MobEffects.SLOW_FALLING) ? Math.min(entity.getGravity(), 0.01) : entity.getGravity();
    }

    public static class MudRender
    implements IClientFluidTypeExtensions {
        private static final ResourceLocation TEXTURE_STILL = ResourceLocation.fromNamespaceAndPath((String)"earthmobsmod", (String)"block/mud");
        private static final ResourceLocation TEXTURE_FLOW = ResourceLocation.fromNamespaceAndPath((String)"earthmobsmod", (String)"block/flowing_mud");
        private static final ResourceLocation TEXTURE_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"earthmobsmod", (String)"textures/block/mud.png");

        public ResourceLocation getStillTexture() {
            return TEXTURE_STILL;
        }

        public ResourceLocation getFlowingTexture() {
            return TEXTURE_FLOW;
        }

        public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
            return TEXTURE_OVERLAY;
        }
    }
}

