/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.mixin;

import baguchan.earthmobsmod.api.IHasFlower;
import baguchan.earthmobsmod.api.IMuddyPig;
import baguchan.earthmobsmod.api.IOnMud;
import baguchan.earthmobsmod.message.MudMessage;
import baguchan.earthmobsmod.util.DyeUtil;
import baguchi.bagus_lib.api.IBaguPacket;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.IShearable;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Pig.class})
public abstract class PigMixin
extends Animal
implements IMuddyPig,
IShearable,
IHasFlower,
IBaguPacket {
    private boolean muddy;
    private byte dyeColor = 0;
    private static final Map<DyeColor, ItemLike> ITEM_BY_DYE = (Map)Util.make((Object)Maps.newEnumMap(DyeColor.class), p_29841_ -> {
        p_29841_.put(DyeColor.WHITE, Items.WHITE_DYE);
        p_29841_.put(DyeColor.ORANGE, Items.ORANGE_DYE);
        p_29841_.put(DyeColor.MAGENTA, Items.MAGENTA_DYE);
        p_29841_.put(DyeColor.LIGHT_BLUE, Items.LIGHT_BLUE_DYE);
        p_29841_.put(DyeColor.YELLOW, Items.YELLOW_DYE);
        p_29841_.put(DyeColor.LIME, Items.LIME_DYE);
        p_29841_.put(DyeColor.PINK, Items.PINK_DYE);
        p_29841_.put(DyeColor.GRAY, Items.GRAY_DYE);
        p_29841_.put(DyeColor.LIGHT_GRAY, Items.LIGHT_GRAY_DYE);
        p_29841_.put(DyeColor.CYAN, Items.CYAN_DYE);
        p_29841_.put(DyeColor.PURPLE, Items.PURPLE_DYE);
        p_29841_.put(DyeColor.BLUE, Items.BLUE_DYE);
        p_29841_.put(DyeColor.BROWN, Items.BROWN_DYE);
        p_29841_.put(DyeColor.GREEN, Items.GREEN_DYE);
        p_29841_.put(DyeColor.RED, Items.RED_DYE);
        p_29841_.put(DyeColor.BLACK, Items.BLACK_DYE);
    });
    private boolean inMud;
    private boolean isShaking;
    private float shakeAnim;
    private float shakeAnimO;

    protected PigMixin(EntityType<? extends Animal> p_27557_, Level p_27558_) {
        super(p_27557_, p_27558_);
    }

    @Override
    public boolean isMuddy() {
        return this.muddy;
    }

    @Override
    public void setMuddy(boolean playing) {
        this.muddy = playing;
        this.resync((Entity)this);
    }

    public void resync(Entity entity) {
        if (!this.level().isClientSide()) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)new MudMessage(this.getId(), this.muddy, this.dyeColor), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public float getBodyRollScale(float p_30433_) {
        float f = Mth.lerp((float)p_30433_, (float)this.shakeAnimO, (float)this.shakeAnim);
        return f;
    }

    @Override
    public void setSheared(boolean sheared) {
        byte b0 = this.dyeColor;
        this.dyeColor = sheared ? (byte)(b0 | 0x10) : (byte)(b0 & 0xFFFFFFEF);
        this.resync((Entity)this);
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.byId((int)(this.dyeColor & 0xF));
    }

    @Override
    public void setColor(DyeColor color) {
        byte b0 = this.dyeColor;
        this.dyeColor = (byte)(b0 & 0xF0 | color.getId() & 0xF);
        this.resync((Entity)this);
    }

    @Override
    public void setColorData(byte dyeColor) {
        this.dyeColor = dyeColor;
        this.resync((Entity)this);
    }

    @Override
    public boolean isSheared() {
        return (this.dyeColor & 0x10) != 0;
    }

    public void tick() {
        block8: {
            block11: {
                block10: {
                    block9: {
                        super.tick();
                        if (!this.isAlive() || !(this instanceof IOnMud) || !this.canMuddy((LivingEntity)this)) break block8;
                        if (!((IOnMud)((Object)this)).isOnMud() || this.isMuddy() && !this.isSheared() || this.isShaking) break block9;
                        this.isShaking = true;
                        this.inMud = true;
                        break block8;
                    }
                    if (!this.isInWater() || !this.isMuddy() || this.isShaking) break block10;
                    this.isShaking = true;
                    this.inMud = false;
                    break block8;
                }
                if (this.inMud || !this.isShaking) break block11;
                if (this.shakeAnim == 0.0f) {
                    this.playSound(SoundEvents.WOLF_SHAKE, this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                    this.gameEvent((Holder)GameEvent.ITEM_INTERACT_START);
                }
                this.shakeAnimO = this.shakeAnim;
                this.shakeAnim += 0.05f;
                if (this.shakeAnimO >= 2.0f) {
                    this.inMud = false;
                    this.isShaking = false;
                    this.shakeAnimO = 0.0f;
                    this.shakeAnim = 0.0f;
                    this.setMuddy(false);
                }
                if (!(this.shakeAnim > 0.4f)) break block8;
                float f = (float)this.getY();
                int i = (int)(Mth.sin((float)((this.shakeAnim - 0.4f) * (float)Math.PI)) * 7.0f);
                Vec3 vec3 = this.getDeltaMovement();
                for (int j = 0; j < i; ++j) {
                    float f1 = (this.random.nextFloat() * 2.0f - 1.0f) * this.getBbWidth() * 0.5f;
                    float f2 = (this.random.nextFloat() * 2.0f - 1.0f) * this.getBbWidth() * 0.5f;
                    this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() + (double)f1, (double)(f + 0.8f), this.getZ() + (double)f2, vec3.x, vec3.y, vec3.z);
                }
                break block8;
            }
            if (this.inMud && this.isShaking) {
                if (this.shakeAnim == 0.0f) {
                    this.playSound(SoundEvents.WOLF_SHAKE, this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                    this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
                }
                this.shakeAnimO = this.shakeAnim;
                this.shakeAnim += 0.05f;
                if (this.shakeAnimO >= 2.0f) {
                    this.inMud = false;
                    this.isShaking = false;
                    this.shakeAnimO = 0.0f;
                    this.shakeAnim = 0.0f;
                    this.setMuddy(true);
                    this.setSheared(false);
                    this.setColor(DyeUtil.getRandomColor(this.random));
                }
                if (this.shakeAnim > 0.4f) {
                    float f = (float)this.getY();
                    int i = (int)(Mth.sin((float)((this.shakeAnim - 0.4f) * (float)Math.PI)) * 7.0f);
                    Vec3 vec3 = this.getDeltaMovement();
                    for (int j = 0; j < i; ++j) {
                        float f1 = (this.random.nextFloat() * 2.0f - 1.0f) * this.getBbWidth() * 0.5f;
                        float f2 = (this.random.nextFloat() * 2.0f - 1.0f) * this.getBbWidth() * 0.5f;
                        this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() + (double)f1, (double)(f + 0.8f), this.getZ() + (double)f2, vec3.x, vec3.y, vec3.z);
                    }
                }
            }
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData(ValueOutput p_421731_, CallbackInfo ci) {
        p_421731_.putBoolean("Muddy", this.isMuddy());
        p_421731_.putBoolean("Sheared", this.isSheared());
        p_421731_.store("Color", DyeColor.LEGACY_ID_CODEC, (Object)this.getColor());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData(ValueInput p_422591_, CallbackInfo ci) {
        this.setMuddy(p_422591_.getBooleanOr("Muddy", false));
        this.setSheared(p_422591_.getBooleanOr("Sheared", false));
        this.setColor(p_422591_.read("Color", DyeColor.LEGACY_ID_CODEC).orElse(DyeColor.PINK));
    }

    public boolean isShearable(@Nullable Player player, ItemStack item, Level level, BlockPos pos) {
        return this.isAlive() && !this.isSheared() && !this.isBaby() && this.isMuddy();
    }

    public List<ItemStack> onSheared(@Nullable Player player, ItemStack item, Level level, BlockPos pos) {
        level.playSound(null, (Entity)this, SoundEvents.SHEEP_SHEAR, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 1.0f, 1.0f);
        this.gameEvent((Holder)GameEvent.SHEAR, (Entity)player);
        if (!level.isClientSide()) {
            this.setSheared(true);
            int i = 1 + this.random.nextInt(3);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int j = 0; j < i; ++j) {
                items.add(new ItemStack(ITEM_BY_DYE.get(this.getColor())));
            }
            return items;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean hasFlower() {
        return !this.isSheared() && this.isMuddy();
    }
}

