/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.registry;

import baguchan.earthmobsmod.EarthMobsMod;
import baguchan.earthmobsmod.block.CarvedMelonBlock;
import baguchan.earthmobsmod.block.TropicalSlimeBlock;
import baguchan.earthmobsmod.registry.ModFluids;
import baguchan.earthmobsmod.registry.ModItems;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"earthmobsmod");
    public static final DeferredBlock<LiquidBlock> MUD = ModBlocks.registerWithoutItem("mud", prop -> new LiquidBlock((FlowingFluid)ModFluids.MUD.value(), prop), () -> BlockBehaviour.Properties.of().mapColor(MapColor.WATER).replaceable().noCollision().strength(100.0f).pushReaction(PushReaction.DESTROY).noLootTable().liquid().sound(SoundType.EMPTY));
    public static final DeferredBlock<Block> RUBY = ModBlocks.register("ruby_block", prop -> new Block(prop.requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundType.METAL)), BlockBehaviour.Properties::of);
    public static final DeferredBlock<Block> CARVED_MELON = ModBlocks.register("carved_melon", prop -> new CarvedMelonBlock(prop.strength(1.0f).sound(SoundType.WOOD)), BlockBehaviour.Properties::of);
    public static final DeferredBlock<Block> CARVED_MELON_SHOOT = ModBlocks.register("carved_melon_shoot", prop -> new CarvedMelonBlock(prop.strength(1.0f).sound(SoundType.WOOD)), BlockBehaviour.Properties::of);
    public static final DeferredBlock<Block> TROPICAL_SLIME_BLOCK = ModBlocks.register("tropical_slime_block", prop -> new TropicalSlimeBlock(prop.mapColor(MapColor.COLOR_BLUE).friction(0.8f).noOcclusion().sound(SoundType.SLIME_BLOCK)), BlockBehaviour.Properties::of);
    public static final DeferredBlock<FlowerBlock> BUTTERCUP = ModBlocks.register("buttercup", prop -> new FlowerBlock(MobEffects.ABSORPTION, 30.0f, prop.noCollision().pushReaction(PushReaction.DESTROY).offsetType(BlockBehaviour.OffsetType.XZ).instabreak().sound(SoundType.GRASS)), () -> BlockBehaviour.Properties.of());
    public static final DeferredBlock<FlowerBlock> PINK_DAISY = ModBlocks.register("pink_daisy", prop -> new FlowerBlock(MobEffects.REGENERATION, 10.0f, prop.noCollision().pushReaction(PushReaction.DESTROY).offsetType(BlockBehaviour.OffsetType.XZ).instabreak().sound(SoundType.GRASS)), () -> BlockBehaviour.Properties.of());
    public static final DeferredBlock<Block> POTTED_BUTTERCUP = ModBlocks.registerWithoutItem("potted_buttercup", prop -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, BUTTERCUP, prop), () -> BlockBehaviour.Properties.of().instabreak().noOcclusion().pushReaction(PushReaction.DESTROY));
    public static final DeferredBlock<Block> POTTED_PINK_DAISY = ModBlocks.registerWithoutItem("potted_pink_daisy", prop -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, PINK_DAISY, prop), () -> BlockBehaviour.Properties.of().instabreak().noOcclusion().pushReaction(PushReaction.DESTROY));

    private static <T extends Block> DeferredBlock<Block> registerWithoutItem(String name, Supplier<BlockBehaviour.Properties> properties) {
        return ModBlocks.registerWithoutItem(name, Block::new, properties);
    }

    private static <T extends Block> DeferredBlock<T> registerWithoutItem(String name, Function<BlockBehaviour.Properties, T> builder, Supplier<BlockBehaviour.Properties> properties) {
        return ModBlocks.registerWithoutItem(name, ModBlocks.createKey(name), builder, properties);
    }

    private static <T extends Block> DeferredBlock<T> registerWithoutItem(String name, ResourceKey<Block> key, Function<BlockBehaviour.Properties, T> builder, Supplier<BlockBehaviour.Properties> properties) {
        return BLOCKS.register(name, () -> (Block)builder.apply(((BlockBehaviour.Properties)properties.get()).setId(key)));
    }

    private static <T extends Block> DeferredBlock<Block> register(String name, Supplier<BlockBehaviour.Properties> properties) {
        return ModBlocks.register(name, Block::new, properties);
    }

    private static <T extends Block> DeferredBlock<T> register(String name, Function<BlockBehaviour.Properties, T> builder, Supplier<BlockBehaviour.Properties> properties) {
        return ModBlocks.register(name, ModBlocks.createKey(name), builder, properties);
    }

    private static <T extends Block> DeferredBlock<T> register(String name, ResourceKey<Block> key, Function<BlockBehaviour.Properties, T> builder, Supplier<BlockBehaviour.Properties> properties) {
        return ModBlocks.baseRegister(name, key, builder, properties, deferredBlock -> ModBlocks.registerBlockItem(deferredBlock, name));
    }

    private static ResourceKey<Block> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"earthmobsmod", (String)name));
    }

    private static <T extends Block> DeferredBlock<T> baseRegister(String name, ResourceKey<Block> key, Function<BlockBehaviour.Properties, T> builder, Supplier<BlockBehaviour.Properties> properties, Function<DeferredBlock<T>, Supplier<? extends Item>> item) {
        DeferredBlock registered = BLOCKS.register(name, () -> (Block)builder.apply(((BlockBehaviour.Properties)properties.get()).setId(key)));
        ModItems.ITEMS.register(name, item.apply(registered));
        return registered;
    }

    private static <T extends Block> DeferredBlock<T> registerTorchBlock(String name, Function<BlockBehaviour.Properties, T> block, DeferredBlock<T> wallTorchBlock, BlockBehaviour.Properties properties) {
        DeferredBlock ret = BLOCKS.register(name, () -> (Block)block.apply(properties.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)EarthMobsMod.prefix(name)))));
        ModItems.ITEMS.registerItem(name, itemProps -> new StandingAndWallBlockItem((Block)ret.get(), (Block)wallTorchBlock.get(), Direction.DOWN, itemProps.useBlockDescriptionPrefix()), new Item.Properties());
        return ret;
    }

    private static <T extends Block> Supplier<BlockItem> registerBlockItem(DeferredBlock<T> deferredBlock, String name) {
        return () -> {
            DeferredBlock block = Objects.requireNonNull(deferredBlock);
            Item.Properties properties = new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"earthmobsmod", (String)name))).useBlockDescriptionPrefix();
            return new BlockItem((Block)block.get(), properties);
        };
    }

    public static void initFire() {
        FireBlock fireblock = (FireBlock)Blocks.FIRE;
        fireblock.setFlammable((Block)BUTTERCUP.get(), 60, 100);
        fireblock.setFlammable((Block)PINK_DAISY.get(), 60, 100);
    }
}

