/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.chunk;

import dev.imprex.orebfuscator.chunk.VarBitBuffer;

public class SimpleVarBitBuffer
implements VarBitBuffer {
    private final int bitsPerEntry;
    private final int entriesPerLong;
    private final long adjustmentMask;
    private final int size;
    private final long[] buffer;

    public static int calculateArraySize(int bitsPerEntry, int size) {
        return bitsPerEntry == 0 ? 0 : (int)Math.ceil((float)size / (float)(64 / bitsPerEntry));
    }

    public SimpleVarBitBuffer(int bitsPerEntry, int size) {
        this.bitsPerEntry = bitsPerEntry;
        this.entriesPerLong = 64 / bitsPerEntry;
        this.adjustmentMask = (1L << bitsPerEntry) - 1L;
        this.size = size;
        this.buffer = new long[(int)Math.ceil((float)size / (float)this.entriesPerLong)];
    }

    @Override
    public int get(int index) {
        int position = index / this.entriesPerLong;
        int offset = (index - position * this.entriesPerLong) * this.bitsPerEntry;
        return (int)(this.buffer[position] >> offset & this.adjustmentMask);
    }

    @Override
    public void set(int index, int value) {
        int position = index / this.entriesPerLong;
        int offset = (index - position * this.entriesPerLong) * this.bitsPerEntry;
        this.buffer[position] = this.buffer[position] & (this.adjustmentMask << offset ^ 0xFFFFFFFFFFFFFFFFL) | ((long)value & this.adjustmentMask) << offset;
    }

    @Override
    public long[] toArray() {
        return this.buffer;
    }

    @Override
    public int size() {
        return this.size;
    }

    public String toString() {
        return String.format("[size=%d, length=%d, bitsPerEntry=%d, entriesPerLong=%d]", this.size, this.buffer.length, this.bitsPerEntry, this.entriesPerLong);
    }
}

