/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.config.context;

import dev.imprex.orebfuscator.config.context.ConfigMessage;
import net.imprex.shaded.org.jetbrains.annotations.Contract;
import net.imprex.shaded.org.jetbrains.annotations.NotNull;

public interface ConfigParsingContext {
    @NotNull
    public ConfigParsingContext section(@NotNull String var1, boolean var2);

    @NotNull
    default public ConfigParsingContext section(@NotNull String path) {
        return this.section(path, false);
    }

    public void warn(@NotNull ConfigMessage var1, Object ... var2);

    public void warn(@NotNull String var1, @NotNull ConfigMessage var2, Object ... var3);

    default public boolean disableIfError(boolean enabled) {
        if (enabled && this.hasErrors()) {
            this.warn(ConfigMessage.DISABLED_ERRORS, new Object[0]);
            return false;
        }
        return enabled;
    }

    public void error(@NotNull ConfigMessage var1, Object ... var2);

    public void error(@NotNull String var1, @NotNull ConfigMessage var2, Object ... var3);

    default public void errorMinValue(@NotNull String path, long min, long value) {
        if (value < min) {
            this.error(path, ConfigMessage.VALUE_MIN, value, min);
        }
    }

    default public void errorMinMaxValue(@NotNull String path, long min, long max, long value) {
        if (value < min || value > max) {
            this.error(path, ConfigMessage.VALUE_MIN_MAX, value, min, max);
        }
    }

    @Contract(pure=true)
    public boolean hasErrors();
}

