/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.config.migrations;

import dev.imprex.orebfuscator.config.migrations.ConfigMigration;
import dev.imprex.orebfuscator.config.yaml.ConfigurationSection;
import java.util.List;
import java.util.Map;
import net.imprex.shaded.org.jetbrains.annotations.NotNull;

class ConfigMigrationV3
implements ConfigMigration {
    ConfigMigrationV3() {
    }

    @Override
    public int sourceVersion() {
        return 3;
    }

    @Override
    @NotNull
    public ConfigurationSection migrate(@NotNull ConfigurationSection root) {
        ConfigMigrationV3.migrateAdvancedConfig(root);
        ConfigMigrationV3.migrateCacheConfig(root);
        ConfigMigrationV3.migrateProximityConfigs(root);
        return root;
    }

    private static void migrateAdvancedConfig(ConfigurationSection root) {
        ConfigMigration.migrateNames(root.getSection("advanced"), List.of(Map.entry("obfuscationWorkerThreads", "obfuscation.threads"), Map.entry("obfuscationTimeout", "obfuscation.timeout"), Map.entry("maxMillisecondsPerTick", "obfuscation.maxMillisecondsPerTick"), Map.entry("proximityHiderThreads", "proximity.threads"), Map.entry("proximityDefaultBucketSize", "proximity.defaultBucketSize"), Map.entry("proximityThreadCheckInterval", "proximity.threadCheckInterval"), Map.entry("proximityPlayerCheckInterval", "proximity.playerCheckInterval")));
    }

    private static void migrateCacheConfig(ConfigurationSection root) {
        ConfigMigration.migrateNames(root.getSection("cache"), List.of(Map.entry("maximumSize", "memoryCache.maximumSize"), Map.entry("expireAfterAccess", "memoryCache.expireAfterAccess"), Map.entry("enableDiskCache", "diskCache.enabled"), Map.entry("baseDirectory", "diskCache.directory"), Map.entry("maximumOpenRegionFiles", "diskCache.maximumOpenFiles"), Map.entry("deleteRegionFilesAfterAccess", "diskCache.deleteFilesAfterAccess"), Map.entry("maximumTaskQueueSize", "diskCache.maximumTaskQueueSize")));
    }

    private static void migrateProximityConfigs(ConfigurationSection root) {
        ConfigurationSection configContainer = root.getSection("proximity");
        if (configContainer == null) {
            return;
        }
        for (ConfigurationSection config : configContainer.getSubSections()) {
            ConfigurationSection hiddenBlocks;
            if (config.isSection("defaults")) {
                Integer y = config.getInt("defaults.y");
                if (config.getBoolean("defaults.above", false).booleanValue()) {
                    config.set("minY", y);
                    config.set("maxY", 2031);
                } else {
                    config.set("minY", -2032);
                    config.set("maxY", y);
                }
                config.set("useBlockBelow", config.getBoolean("defaults.useBlockBelow"));
            }
            if (config.isBoolean("useRayCastCheck") || config.isBoolean("useFastGazeCheck")) {
                config.set("rayCastCheck.enabled", config.getBoolean("useRayCastCheck", config.getBoolean("useFastGazeCheck")));
            }
            if ((hiddenBlocks = config.getSection("hiddenBlocks")) == null) continue;
            for (ConfigurationSection block : hiddenBlocks.getSubSections()) {
                if (!block.isInt("y") || !block.isBoolean("above")) continue;
                Integer y = block.getInt("y");
                if (block.getBoolean("above", false).booleanValue()) {
                    block.set("minY", y);
                    block.set("maxY", 2031);
                    continue;
                }
                block.set("minY", -2032);
                block.set("maxY", y);
            }
        }
    }
}

