/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.config.yaml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.imprex.shaded.org.jetbrains.annotations.Contract;
import net.imprex.shaded.org.jetbrains.annotations.NotNull;
import net.imprex.shaded.org.jetbrains.annotations.Nullable;

public class ConfigurationSection {
    static final char PATH_SEPARATOR = '.';
    protected final Map<String, Object> map = new LinkedHashMap<String, Object>();
    private final String path;

    protected ConfigurationSection(@NotNull String path) {
        Objects.requireNonNull(path, "Path cannot be null");
        this.path = path;
    }

    @NotNull
    public String getName() {
        return this.path;
    }

    @NotNull
    public Set<String> getKeys() {
        return this.map.keySet();
    }

    public boolean contains(@NotNull String path) {
        return this.get(path, null) != null;
    }

    public void set(@NotNull String path, @Nullable Object value) {
        String segment;
        int start;
        Objects.requireNonNull(path, "Path cannot be null");
        int end = -1;
        ConfigurationSection section = this;
        while ((end = path.indexOf(46, start = end + 1)) != -1) {
            segment = path.substring(start, end);
            ConfigurationSection subSection = section.getSection(segment);
            if (subSection == null) {
                if (value == null) {
                    return;
                }
                section = section.createSection(segment);
                continue;
            }
            section = subSection;
        }
        segment = path.substring(start);
        if (section == this) {
            if (value == null) {
                this.map.remove(segment);
            } else {
                this.map.put(segment, value);
            }
        } else {
            section.set(segment, value);
        }
    }

    @Nullable
    public Object get(@NotNull String path) {
        return this.get(path, null);
    }

    @Nullable
    @Contract(value="_, !null -> !null")
    public Object get(@NotNull String path, @Nullable Object defaultValue) {
        int start;
        Objects.requireNonNull(path, "Path cannot be null");
        if (path.isBlank()) {
            return this;
        }
        int end = -1;
        ConfigurationSection section = this;
        while ((end = path.indexOf(46, start = end + 1)) != -1) {
            if ((section = section.getSection(path.substring(start, end))) != null) continue;
            return defaultValue;
        }
        String segment = path.substring(start);
        if (section == this) {
            Object result = this.map.get(segment);
            return result == null ? defaultValue : result;
        }
        return section.get(segment, defaultValue);
    }

    @NotNull
    public ConfigurationSection createSection(@NotNull String path) {
        String segment;
        int start;
        Objects.requireNonNull(path, "Cannot create section at empty path");
        if (path.isBlank()) {
            return this;
        }
        int end = -1;
        ConfigurationSection section = this;
        while ((end = path.indexOf(46, start = end + 1)) != -1) {
            segment = path.substring(start, end);
            ConfigurationSection subSection = section.getSection(segment);
            if (subSection == null) {
                section = section.createSection(segment);
                continue;
            }
            section = subSection;
        }
        segment = path.substring(start);
        if (section == this) {
            ConfigurationSection result = new ConfigurationSection(segment);
            this.map.put(segment, result);
            return result;
        }
        return section.createSection(segment);
    }

    public boolean isBoolean(@NotNull String path) {
        return this.get(path) instanceof Boolean;
    }

    @Nullable
    public Boolean getBoolean(@NotNull String path) {
        return this.getBoolean(path, null);
    }

    @Nullable
    @Contract(value="_, !null -> !null")
    public Boolean getBoolean(@NotNull String path, @Nullable Boolean defaultValue) {
        Boolean value;
        Object object = this.get(path, defaultValue);
        return object instanceof Boolean ? (value = (Boolean)object) : defaultValue;
    }

    public boolean isInt(@NotNull String path) {
        return this.get(path) instanceof Integer;
    }

    @Nullable
    public Integer getInt(@NotNull String path) {
        return this.getInt(path, null);
    }

    @Nullable
    @Contract(value="_, !null -> !null")
    public Integer getInt(@NotNull String path, @Nullable Integer defaultValue) {
        Integer n;
        Object object = this.get(path, defaultValue);
        if (object instanceof Number) {
            Number value = (Number)object;
            n = value.intValue();
        } else {
            n = defaultValue;
        }
        return n;
    }

    public boolean isLong(@NotNull String path) {
        return this.get(path) instanceof Long;
    }

    @Nullable
    public Long getLong(@NotNull String path) {
        return this.getLong(path, null);
    }

    @Nullable
    @Contract(value="_, !null -> !null")
    public Long getLong(@NotNull String path, @Nullable Long defaultValue) {
        Long l;
        Object object = this.get(path, defaultValue);
        if (object instanceof Number) {
            Number value = (Number)object;
            l = value.longValue();
        } else {
            l = defaultValue;
        }
        return l;
    }

    public boolean isDouble(@NotNull String path) {
        return this.get(path) instanceof Double;
    }

    @Nullable
    public Double getDouble(@NotNull String path) {
        return this.getDouble(path, null);
    }

    @Nullable
    @Contract(value="_, !null -> !null")
    public Double getDouble(@NotNull String path, @Nullable Double defaultValue) {
        Double d;
        Object object = this.get(path, defaultValue);
        if (object instanceof Number) {
            Number value = (Number)object;
            d = value.doubleValue();
        } else {
            d = defaultValue;
        }
        return d;
    }

    public boolean isNumber(@NotNull String path) {
        return this.get(path) instanceof Number;
    }

    public boolean isString(@NotNull String path) {
        return this.get(path) instanceof String;
    }

    @Nullable
    public String getString(@NotNull String path) {
        return this.getString(path, null);
    }

    @Nullable
    @Contract(value="_, !null -> !null")
    public String getString(@NotNull String path, @Nullable String defaultValue) {
        String value;
        Object object = this.get(path, defaultValue);
        return object instanceof String ? (value = (String)object) : defaultValue;
    }

    public boolean isList(@NotNull String path) {
        return this.get(path) instanceof List;
    }

    @Nullable
    public List<?> getList(@NotNull String path) {
        return this.getList(path, null);
    }

    @Nullable
    @Contract(value="_, !null -> !null")
    public List<?> getList(@NotNull String path, List<?> defaultValue) {
        List value;
        Object object = this.get(path, defaultValue);
        return object instanceof List ? (value = (List)object) : defaultValue;
    }

    @NotNull
    public List<String> getStringList(@NotNull String path) {
        List<?> list = this.getList(path);
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Object object : list) {
            if (!(object instanceof String) && !ConfigurationSection.isPrimitiveWrapper(object)) continue;
            result.add(String.valueOf(object));
        }
        return result;
    }

    public boolean isSection(@NotNull String path) {
        return this.get(path) instanceof ConfigurationSection;
    }

    @Nullable
    public ConfigurationSection getSection(@NotNull String path) {
        ConfigurationSection value;
        Object object = this.get(path);
        return object instanceof ConfigurationSection ? (value = (ConfigurationSection)object) : null;
    }

    @NotNull
    public List<ConfigurationSection> getSubSections() {
        ArrayList<ConfigurationSection> result = new ArrayList<ConfigurationSection>();
        for (Object value : this.map.values()) {
            if (!(value instanceof ConfigurationSection)) continue;
            ConfigurationSection subSection = (ConfigurationSection)value;
            result.add(subSection);
        }
        return result;
    }

    private static boolean isPrimitiveWrapper(@Nullable Object input) {
        return input instanceof Integer || input instanceof Boolean || input instanceof Character || input instanceof Byte || input instanceof Short || input instanceof Double || input instanceof Long || input instanceof Float;
    }

    public int hashCode() {
        return Objects.hash(this.map, this.path);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigurationSection other = (ConfigurationSection)obj;
        return Objects.equals(this.map, other.map) && Objects.equals(this.path, other.path);
    }
}

