/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.config.yaml;

import dev.imprex.shaded.org.yaml.snakeyaml.comments.CommentLine;
import dev.imprex.shaded.org.yaml.snakeyaml.nodes.MappingNode;
import dev.imprex.shaded.org.yaml.snakeyaml.nodes.Node;
import dev.imprex.shaded.org.yaml.snakeyaml.nodes.NodeTuple;
import dev.imprex.shaded.org.yaml.snakeyaml.nodes.ScalarNode;
import dev.imprex.shaded.org.yaml.snakeyaml.nodes.SequenceNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.imprex.shaded.org.jetbrains.annotations.NotNull;
import net.imprex.shaded.org.jetbrains.annotations.Nullable;

class NodeCommentData {
    private final List<CommentLine> blockComments;
    private final List<CommentLine> inLineComments;
    private final List<CommentLine> endComments;
    private final Map<String, NodeCommentData> children = new HashMap<String, NodeCommentData>();
    private final Map<Object, List<CommentLine>> sequenceValueComments;

    public NodeCommentData() {
        this.blockComments = Collections.emptyList();
        this.inLineComments = Collections.emptyList();
        this.endComments = null;
        this.sequenceValueComments = null;
    }

    public NodeCommentData(@NotNull NodeTuple nodeTuple) {
        Node keyNode = nodeTuple.getKeyNode();
        Node valueNode = nodeTuple.getValueNode();
        this.blockComments = keyNode.getBlockComments();
        this.endComments = null;
        this.inLineComments = valueNode instanceof SequenceNode ? Collections.emptyList() : (valueNode instanceof MappingNode ? keyNode.getInLineComments() : valueNode.getInLineComments());
        if (valueNode instanceof SequenceNode) {
            SequenceNode sequenceNode = (SequenceNode)valueNode;
            this.sequenceValueComments = new HashMap<Object, List<CommentLine>>();
            for (Node value : sequenceNode.getValue()) {
                if (!(value instanceof ScalarNode)) continue;
                ScalarNode scalarNode = (ScalarNode)value;
                this.sequenceValueComments.put(scalarNode.getValue(), scalarNode.getInLineComments());
            }
        } else {
            this.sequenceValueComments = null;
        }
    }

    public NodeCommentData(@NotNull MappingNode node) {
        this.blockComments = node.getBlockComments();
        this.inLineComments = node.getInLineComments();
        this.endComments = node.getEndComments();
        this.sequenceValueComments = null;
    }

    public void addChild(@NotNull String key, @NotNull NodeCommentData commentData) {
        this.children.put(key, commentData);
    }

    @Nullable
    public NodeCommentData getChild(@NotNull String key) {
        return this.children.get(key);
    }

    public void apply(@NotNull NodeTuple nodeTuple) {
        Node keyNode = nodeTuple.getKeyNode();
        Node valueNode = nodeTuple.getValueNode();
        keyNode.setBlockComments(this.blockComments);
        if (valueNode instanceof MappingNode) {
            keyNode.setInLineComments(this.inLineComments);
        } else if (!(valueNode instanceof SequenceNode)) {
            valueNode.setInLineComments(this.inLineComments);
        }
        if (valueNode instanceof SequenceNode) {
            SequenceNode sequenceNode = (SequenceNode)valueNode;
            if (this.sequenceValueComments != null) {
                for (Node value : sequenceNode.getValue()) {
                    ScalarNode scalarNode;
                    List<CommentLine> inlineComments;
                    if (!(value instanceof ScalarNode) || (inlineComments = this.sequenceValueComments.get((scalarNode = (ScalarNode)value).getValue())) == null) continue;
                    scalarNode.setInLineComments(inlineComments);
                }
            }
        }
    }

    public void apply(@NotNull MappingNode node) {
        node.setBlockComments(this.blockComments);
        node.setInLineComments(this.inLineComments);
        node.setEndComments(this.endComments);
    }
}

