/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.reflect.predicate;

import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.imprex.shaded.org.jetbrains.annotations.NotNull;

public interface ClassPredicate
extends Predicate<Class<?>> {
    @Override
    public boolean test(@NotNull Class<?> var1);

    @NotNull
    public String requirement();

    public static class RegexClassPredicate
    implements ClassPredicate {
        @NotNull
        private final Pattern expected;

        public RegexClassPredicate(@NotNull Pattern expected) {
            this.expected = Objects.requireNonNull(expected);
        }

        @Override
        public boolean test(@NotNull Class<?> type) {
            Objects.requireNonNull(type);
            return this.expected.matcher(type.getTypeName()).matches();
        }

        @Override
        @NotNull
        public String requirement() {
            return String.format("{regex %s}", this.expected);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof RegexClassPredicate)) return false;
            RegexClassPredicate other = (RegexClassPredicate)obj;
            if (!Objects.equals(this.expected, other.expected)) return false;
            return true;
        }
    }

    public static class AnyClassPredicate
    implements ClassPredicate {
        @NotNull
        private final Set<Class<?>> expected;

        public AnyClassPredicate(@NotNull Set<Class<?>> expected) {
            this.expected = Objects.requireNonNull(expected);
        }

        @Override
        public boolean test(@NotNull Class<?> type) {
            Objects.requireNonNull(type);
            return this.expected.contains(type);
        }

        @Override
        @NotNull
        public String requirement() {
            return String.format("{any %s}", this.expected.stream().map(Class::getTypeName).collect(Collectors.joining(", ", "(", ")")));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof AnyClassPredicate)) return false;
            AnyClassPredicate other = (AnyClassPredicate)obj;
            if (!Objects.equals(this.expected, other.expected)) return false;
            return true;
        }
    }

    public static class SubClassPredicate
    implements ClassPredicate {
        @NotNull
        private final Class<?> expected;

        public SubClassPredicate(@NotNull Class<?> expected) {
            this.expected = Objects.requireNonNull(expected);
        }

        @Override
        public boolean test(@NotNull Class<?> type) {
            Objects.requireNonNull(type);
            return this.expected.isAssignableFrom(type);
        }

        @Override
        @NotNull
        public String requirement() {
            return String.format("{sub-class-of %s}", this.expected.getTypeName());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof SubClassPredicate)) return false;
            SubClassPredicate other = (SubClassPredicate)obj;
            if (!Objects.equals(this.expected, other.expected)) return false;
            return true;
        }
    }

    public static class SuperClassPredicate
    implements ClassPredicate {
        @NotNull
        private final Class<?> expected;

        public SuperClassPredicate(@NotNull Class<?> expected) {
            this.expected = Objects.requireNonNull(expected);
        }

        @Override
        public boolean test(@NotNull Class<?> type) {
            Objects.requireNonNull(type);
            return type.isAssignableFrom(this.expected);
        }

        @Override
        @NotNull
        public String requirement() {
            return String.format("{super-class-of %s}", this.expected.getTypeName());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof SuperClassPredicate)) return false;
            SuperClassPredicate other = (SuperClassPredicate)obj;
            if (!Objects.equals(this.expected, other.expected)) return false;
            return true;
        }
    }

    public static class IsClassPredicate
    implements ClassPredicate {
        @NotNull
        private final Class<?> expected;

        public IsClassPredicate(@NotNull Class<?> expected) {
            this.expected = Objects.requireNonNull(expected);
        }

        @Override
        public boolean test(@NotNull Class<?> type) {
            Objects.requireNonNull(type);
            return this.expected.equals(type);
        }

        @Override
        @NotNull
        public String requirement() {
            return String.format("{is %s}", this.expected.getTypeName());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof IsClassPredicate)) return false;
            IsClassPredicate other = (IsClassPredicate)obj;
            if (!Objects.equals(this.expected, other.expected)) return false;
            return true;
        }
    }

    public static class Builder<TParent> {
        private final Function<ClassPredicate, TParent> returnFunction;

        public Builder(Function<ClassPredicate, TParent> returnFunction) {
            this.returnFunction = returnFunction;
        }

        @NotNull
        public TParent is(@NotNull Class<?> type) {
            return this.returnFunction.apply(new IsClassPredicate(type));
        }

        @NotNull
        public TParent superOf(@NotNull Class<?> type) {
            return this.returnFunction.apply(new SuperClassPredicate(type));
        }

        @NotNull
        public TParent subOf(@NotNull Class<?> type) {
            return this.returnFunction.apply(new SubClassPredicate(type));
        }

        @NotNull
        public TParent any(@NotNull Set<Class<?>> types) {
            return this.returnFunction.apply(new AnyClassPredicate(types));
        }

        @NotNull
        public TParent any(Class<?> ... types) {
            return this.any(Set.of(types));
        }

        @NotNull
        public TParent regex(@NotNull Pattern pattern) {
            return this.returnFunction.apply(new RegexClassPredicate(pattern));
        }
    }
}

