/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.reflect.predicate;

import dev.imprex.orebfuscator.reflect.accessor.FieldAccessor;
import dev.imprex.orebfuscator.reflect.predicate.AbstractMemberPredicate;
import dev.imprex.orebfuscator.reflect.predicate.ClassPredicate;
import dev.imprex.orebfuscator.reflect.predicate.RequirementCollector;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.imprex.shaded.org.jetbrains.annotations.NotNull;
import net.imprex.shaded.org.jetbrains.annotations.Nullable;

public final class FieldPredicate
extends AbstractMemberPredicate<FieldPredicate, FieldAccessor, Field> {
    @Nullable
    private ClassPredicate type;

    public FieldPredicate(@NotNull Function<FieldPredicate, Stream<FieldAccessor>> producer, @NotNull Supplier<String> className) {
        super(producer, () -> String.format("Can't find field in class %s matching: ", className.get()));
    }

    @Override
    public boolean test(@NotNull Field field) {
        return super.test(field) && (this.type == null || this.type.test(field.getType()));
    }

    @Override
    void requirements(@NotNull RequirementCollector collector) {
        super.requirements(collector);
        if (this.type != null) {
            collector.collect("type", this.type.requirement());
        }
    }

    @NotNull
    public FieldPredicate type(@NotNull ClassPredicate matcher) {
        this.type = Objects.requireNonNull(matcher);
        return this;
    }

    @NotNull
    public ClassPredicate.Builder<FieldPredicate> type() {
        return new ClassPredicate.Builder<FieldPredicate>(this::type);
    }

    @Override
    @NotNull
    protected FieldPredicate instance() {
        return this;
    }
}

