/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.util;

public record BlockPos(int x, int y, int z) implements Comparable<BlockPos>
{
    private static final int BITS_PER_X = 26;
    private static final int BITS_PER_Z = 26;
    private static final int BITS_PER_Y = 12;
    private static final int OFFSET_Y = 0;
    private static final int OFFSET_Z = 12;
    private static final int OFFSET_X = 38;
    private static final long MASK_X = 0x3FFFFFFL;
    private static final long MASK_Y = 4095L;
    private static final long MASK_Z = 0x3FFFFFFL;
    public static final int Y_SIZE = 4064;
    public static final int MAX_Y = 2031;
    public static final int MIN_Y = -2032;

    public BlockPos add(int x, int y, int z) {
        return x == 0 && y == 0 && z == 0 ? this : new BlockPos(this.x + x, this.y + y, this.z + z);
    }

    public double distanceSquared(double x, double y, double z) {
        double dx = (double)this.x - x;
        double dy = (double)this.y - y;
        double dz = (double)this.z - z;
        return dx * dx + dy * dy + dz * dz;
    }

    public long toLong() {
        return ((long)this.x & 0x3FFFFFFL) << 38 | ((long)this.y & 0xFFFL) << 0 | ((long)this.z & 0x3FFFFFFL) << 12;
    }

    public static BlockPos fromLong(long value) {
        int x = (int)(value << 0 >> 38);
        int y = (int)(value << 52 >> 52);
        int z = (int)(value << 26 >> 38);
        return new BlockPos(x, y, z);
    }

    public int toSectionPos() {
        return (this.x & 0xF) << 12 | (this.y & 0xFFF) << 0 | (this.z & 0xF) << 16;
    }

    public static BlockPos fromSectionPos(int x, int z, int sectionPos) {
        int y = sectionPos << 20 >> 20;
        return new BlockPos(x += sectionPos >> 12 & 0xF, y, z += sectionPos >> 16 & 0xF);
    }

    @Override
    public int compareTo(BlockPos other) {
        if (this.y == other.y) {
            if (this.z == other.z) {
                return this.x - other.x;
            }
            return this.z - other.z;
        }
        return this.y - other.y;
    }

    @Override
    public String toString() {
        return "BlockPos [x=" + this.x + ", y=" + this.y + ", z=" + this.z + "]";
    }
}

